/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxIndex;
import jp.co.extreme.orm.entity.OrmAbstractEntity;
import jp.co.extreme.orm.entity.OrmPersistenceEntity;
import jp.co.extreme.orm.entity.OrmPersistenceField;

@OrmPersistenceEntity(primaryKeyField="dataSourceId, tableName", columnNameConvert=true)
public class MmdxModel
extends OrmAbstractEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3421939068063823152L;
    public long dataSourceId;
    public String tableName;
    public String logicalName;
    public String wordCode;
    public String note;
    @OrmPersistenceField(enable=false)
    public List<MmdxField> fieldList = new ArrayList<MmdxField>();
    @OrmPersistenceField(enable=false)
    public Map<String, MmdxField> fieldNameMap = new TreeMap<String, MmdxField>();
    @OrmPersistenceField(enable=false)
    public Map<String, MmdxIndex> indexNameMap = new TreeMap<String, MmdxIndex>();
    @OrmPersistenceField(enable=false)
    public String primaryIndexName;

    public MmdxModel() {
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.dataSourceId = -1L;
        this.tableName = null;
        this.logicalName = null;
        this.wordCode = null;
        this.note = null;
        this.fieldList.clear();
        this.fieldNameMap.clear();
        this.indexNameMap.clear();
        this.primaryIndexName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(MmdxField mmdxField) {
        List<MmdxField> list = this.fieldList;
        synchronized (list) {
            this.fieldList.add(mmdxField);
            this.fieldNameMap.put(mmdxField.columnName, mmdxField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmdxField removeField(int index) {
        List<MmdxField> list = this.fieldList;
        synchronized (list) {
            MmdxField mmdField = this.fieldList.remove(index);
            this.fieldNameMap.remove(mmdField.columnName);
            return mmdField;
        }
    }

    public MmdxField getField(int index) {
        return this.fieldList.get(index);
    }

    public int getFieldCount() {
        return this.fieldList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldIndexByName(String fieldName) {
        List<MmdxField> list = this.fieldList;
        synchronized (list) {
            int resValue = -1;
            if (BcStringUtil.isEmpty(fieldName)) {
                return resValue;
            }
            int i = 0;
            while (i < this.getFieldCount()) {
                MmdxField field2 = this.getField(i);
                if (BcStringUtil.equals(field2.columnName, fieldName)) {
                    resValue = i;
                    break;
                }
                ++i;
            }
            return resValue;
        }
    }

    public MmdxField getFieldByName(String fieldName) {
        return this.fieldNameMap.get(fieldName);
    }

    public MmdxIndex getPrimaryKey() {
        MmdxIndex mmdxIndex = null;
        if (!BcStringUtil.isEmpty(this.primaryIndexName)) {
            mmdxIndex = this.getIndex(this.primaryIndexName);
        }
        return mmdxIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(MmdxIndex mmdxIndex) {
        List<MmdxField> list = this.fieldList;
        synchronized (list) {
            this.indexNameMap.put(mmdxIndex.indexName, mmdxIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmdxIndex getIndex(String indexName) {
        List<MmdxField> list = this.fieldList;
        synchronized (list) {
            return this.indexNameMap.get(indexName);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return BcCloneUtil.createClone(this);
    }
}

