/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.ffmpeg;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcProcessExecutor;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.ffmpeg.FfprobeParamBuiler;
import jp.co.extreme.module.xfil.model.MovieInfo;

public class FfprobeHelper
extends BcLoggableObject {
    protected BcProcessExecutor processExecutor = new BcProcessExecutor();
    private String ffprobePath;
    private BcResult result;

    public FfprobeHelper() {
        BcResult result = new BcResult();
        result.addError("FFprobe is not set.");
        this.setResult(result);
    }

    public static FfprobeHelper getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void setLogger(BcLogger logger) {
        super.setLogger(logger);
        this.processExecutor.setLogger(logger);
    }

    public String getFfprobePath() {
        return this.ffprobePath;
    }

    public void setFfprobePath(String ffprobePath) {
        this.ffprobePath = ffprobePath;
        this.getLogger().info("FFprobe path=" + ffprobePath);
        if (!BcStringUtil.isEmpty(ffprobePath)) {
            File file = new File(ffprobePath);
            if (file.exists()) {
                if (!file.setExecutable(true, false)) {
                    this.result.addError(String.format("%s is not executable.", file.getName()));
                }
            } else {
                BcResult result = new BcResult();
                result.addError(BcWords.getInstance().$_does_not_exists(file.getPath()));
                this.setResult(result);
                return;
            }
        }
        try {
            this.getLogger().info(this.getVersion());
            this.setResult(new BcResult());
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            BcResult result = new BcResult();
            result.addError(ex);
            this.setResult(result);
        }
    }

    public Integer getVersion() throws Exception {
        FfprobeParamBuiler ffprobeParamBuiler = new FfprobeParamBuiler();
        List<String> argList = ffprobeParamBuiler.version().build();
        BcProcessExecutor.BcProcessResult processResult = this.processExecutor.execute(this.ffprobePath, argList);
        return processResult.exitValue;
    }

    public BcResult getResult() {
        return this.result;
    }

    public void setResult(BcResult result) {
        this.result = result;
    }

    public static List<String> createArgList(File imputFile) throws Exception {
        FfprobeParamBuiler ffprobeParamBuiler = new FfprobeParamBuiler();
        ffprobeParamBuiler.hide_banner();
        ffprobeParamBuiler.loglevel_error();
        ffprobeParamBuiler.show_streams();
        ffprobeParamBuiler.show_format();
        ffprobeParamBuiler.print_format(PrintFormat.json);
        List<String> argList = ffprobeParamBuiler.build();
        argList.add(imputFile.getPath());
        return argList;
    }

    public MovieInfo createMovieInfo(File file) throws Exception {
        List<String> argList = FfprobeHelper.createArgList(file);
        BcProcessExecutor.BcProcessResult processResult = this.processExecutor.execute(this.ffprobePath, argList);
        MovieInfo movieInfo = null;
        if (processResult.exitValue == 0) {
            movieInfo = this.parce(processResult.out);
        } else {
            this.getLogger().error("FFprobe:exitValue=" + processResult.exitValue);
        }
        return movieInfo;
    }

    protected MovieInfo parce(String jsonStr) throws Exception {
        JsonNode jsonNode = null;
        try {
            jsonNode = JacksonUtil.getObjectMapper().readTree(jsonStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JsonNode streams = jsonNode.get("streams");
        JsonNode stream_video = null;
        int i = 0;
        while (i < streams.size()) {
            JsonNode stream = streams.get(i);
            JsonNode codec_type = stream.get("codec_type");
            if (codec_type.asText().equals("video")) {
                stream_video = stream;
                break;
            }
            ++i;
        }
        MovieInfo movieInfo = new MovieInfo();
        movieInfo.note = jsonStr;
        movieInfo.width = -1;
        try {
            JsonNode width = stream_video.get("width");
            movieInfo.width = width.asInt();
        }
        catch (Exception width) {
            // empty catch block
        }
        movieInfo.height = -1;
        try {
            JsonNode height = stream_video.get("height");
            movieInfo.height = height.asInt();
        }
        catch (Exception height) {
            // empty catch block
        }
        JsonNode format = jsonNode.get("format");
        movieInfo.durationMillis = -1L;
        try {
            JsonNode duration = format.get("duration");
            movieInfo.durationMillis = (long)(duration.asDouble() * 1000.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return movieInfo;
    }

    public static enum PrintFormat {
        json;

    }

    private static final class SingletonHolder {
        private static final FfprobeHelper instance = new FfprobeHelper();

        private SingletonHolder() {
        }
    }
}

