/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.swing.SwgUtil;

public class FxDndSourceHelper
extends BcLoggableObject {
    public void setup(final Node source) throws Exception {
        this.getLogger().debug("FxDndSourceHelper#setup:source=" + source);
        source.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ev) {
                try {
                    FxDndSourceHelper.this.onDragDetected(ev, source);
                }
                catch (Exception ex) {
                    FxDndSourceHelper.this.handleException(ex);
                }
            }
        });
        source.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
                try {
                    FxDndSourceHelper.this.onDragDone(ev);
                }
                catch (Exception ex) {
                    FxDndSourceHelper.this.handleException(ex);
                }
            }
        });
    }

    protected void onDragDetected(MouseEvent ev, Node source) throws Exception {
        Dragboard dragboard = source.startDragAndDrop(TransferMode.ANY);
        dragboard.setDragView((Image)source.snapshot(null, null));
        ClipboardContent content = new ClipboardContent();
        content.putString(String.valueOf(source.getClass().getName()) + ":" + source.hashCode());
        dragboard.setContent((Map)content);
    }

    protected void onDragDone(DragEvent ev) throws Exception {
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

