/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.async.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeoutException;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.async.AsyncProcessor;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaAsyncCLI {
    private static final long TIMEOUT_MS = 600000L;
    private static final Logger LOG = LoggerFactory.getLogger(TikaAsyncCLI.class);

    public static void main(String[] args) throws Exception {
        Path tikaConfigPath = Paths.get(args[0], new String[0]);
        PipesIterator pipesIterator = PipesIterator.build(tikaConfigPath);
        long start = System.currentTimeMillis();
        try (AsyncProcessor processor = new AsyncProcessor(tikaConfigPath, pipesIterator);){
            for (FetchEmitTuple t : pipesIterator) {
                boolean offered = processor.offer(t, 600000L);
                if (offered) continue;
                throw new TimeoutException("timed out waiting to add a fetch emit tuple");
            }
            processor.finished();
            while (processor.checkActive()) {
                Thread.sleep(500L);
            }
            long elapsed = System.currentTimeMillis() - start;
            LOG.info("Successfully finished processing {} files in {} ms", (Object)processor.getTotalProcessed(), (Object)elapsed);
        }
    }
}

