/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.depend.bcel;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.depend.AbstractAnalyzer;
import org.apache.tools.ant.util.depend.bcel.DependencyVisitor;

public class FullAnalyzer
extends AbstractAnalyzer {
    public FullAnalyzer() {
        block2: {
            try {
                new ClassParser("force");
            }
            catch (Exception e) {
                if (e instanceof IOException) break block2;
                throw new BuildException(e);
            }
        }
    }

    @Override
    protected void determineDependencies(Vector<File> files, Vector<String> classes) {
        Hashtable<String, String> dependencies = new Hashtable<String, String>();
        Hashtable<File, File> containers = new Hashtable<File, File>();
        Hashtable<String, String> toAnalyze = new Hashtable<String, String>();
        Enumeration<String> e = this.getRootClasses();
        while (e.hasMoreElements()) {
            String classname = e.nextElement();
            toAnalyze.put(classname, classname);
        }
        int count = 0;
        int maxCount = this.isClosureRequired() ? 1000 : 2;
        while (toAnalyze.size() != 0 && count++ < maxCount) {
            DependencyVisitor dependencyVisitor = new DependencyVisitor();
            for (String classname : toAnalyze.keySet()) {
                dependencies.put(classname, classname);
                try {
                    File container = this.getClassContainer(classname);
                    if (container == null) continue;
                    containers.put(container, container);
                    ClassParser parser = null;
                    parser = container.getName().endsWith(".class") ? new ClassParser(container.getPath()) : new ClassParser(container.getPath(), String.valueOf(classname.replace('.', '/')) + ".class");
                    JavaClass javaClass = parser.parse();
                    DescendingVisitor traverser = new DescendingVisitor(javaClass, dependencyVisitor);
                    traverser.visit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            toAnalyze.clear();
            Enumeration<String> depsEnum = dependencyVisitor.getDependencies();
            while (depsEnum.hasMoreElements()) {
                String className = depsEnum.nextElement();
                if (dependencies.containsKey(className)) continue;
                toAnalyze.put(className, className);
            }
        }
        files.removeAllElements();
        for (File f : containers.keySet()) {
            files.add(f);
        }
        classes.removeAllElements();
        for (String dependency : dependencies.keySet()) {
            classes.add(dependency);
        }
    }

    @Override
    protected boolean supportsFileDependencies() {
        return true;
    }
}

