/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.EngineUtils;
import org.apache.bsf.util.JavaUtils;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.ObjInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaEngine
extends BSFEngineImpl {
    Class javaclass = null;
    static Hashtable codeToClass = new Hashtable();
    static String serializeCompilation = "";
    static String placeholder = "$$CLASSNAME$$";
    String minorPrefix;
    private Log logger = LogFactory.getLog(this.getClass().getName());
    private int uniqueFileOffset = -1;

    @Override
    public Object call(Object object, String method, Object[] args) throws BSFException {
        throw new BSFException(499, "call() is not currently supported by JavaEngine");
    }

    @Override
    public void compileScript(String source, int lineNo, int columnNo, Object script, CodeBuffer cb) throws BSFException {
        ObjInfo oldRet = cb.getFinalServiceMethodStatement();
        if (oldRet != null && oldRet.isExecutable()) {
            cb.addServiceMethodStatement(String.valueOf(oldRet.objName) + ";");
        }
        cb.addServiceMethodStatement(script.toString());
        cb.setFinalServiceMethodStatement(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        block17: {
            block18: {
                retval = null;
                classname = null;
                gf = null;
                script = basescript = oscript.toString();
                try {
                    try {
                        this.javaclass = (Class)JavaEngine.codeToClass.get(basescript);
                        if (this.javaclass != null) {
                            classname = this.javaclass.getName();
                        } else {
                            gf = this.openUniqueFile(this.tempDir, "BSFJava", ".java");
                            if (gf == null) {
                                throw new BSFException("couldn't create JavaEngine scratchfile");
                            }
                            classname = gf.className;
                            gf.fos.write(("import java.lang.*;import java.util.*;public class " + classname + " {\n" + "  static public Object BSFJavaEngineEntry(org.apache.bsf.BSFManager bsf) {\n").getBytes());
                            startpoint = script.indexOf(JavaEngine.placeholder);
                            if (startpoint >= 0) {
                                changed = new StringBuffer();
                                while (startpoint >= 0) {
                                    changed.setLength(0);
                                    if (startpoint > 0) {
                                        changed.append(script.substring(0, startpoint));
                                    }
                                    changed.append(classname);
                                    endpoint = startpoint + JavaEngine.placeholder.length();
                                    if (endpoint < script.length()) {
                                        changed.append(script.substring(endpoint));
                                    }
                                    script = changed.toString();
                                    startpoint = script.indexOf(JavaEngine.placeholder, startpoint);
                                }
                            }
                            gf.fos.write(script.getBytes());
                            gf.fos.write("\n  }\n}\n".getBytes());
                            gf.fos.close();
                            var12_13 = JavaEngine.serializeCompilation;
                            synchronized (var12_13) {
                                JavaUtils.JDKcompile(gf.file.getPath(), this.classPath);
                            }
                            this.javaclass = EngineUtils.loadClass(this.mgr, classname);
                            JavaEngine.codeToClass.put(basescript, this.javaclass);
                        }
                        callArgs = new Object[]{this.mgr};
                        retval = this.internalCall(this, "BSFJavaEngineEntry", callArgs);
                        break block17;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BSFException(10, e.getMessage());
                    }
                }
                catch (Throwable var13_15) {
                    if (classname == null) break block18;
                    file = new File(String.valueOf(this.tempDir) + File.separatorChar + classname + ".class");
                    file = new File(this.tempDir);
                    this.minorPrefix = String.valueOf(classname) + "$";
                    minorClassfiles = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.indexOf(JavaEngine.this.minorPrefix) == 0 && name.lastIndexOf(".class") == name.length() - 6;
                        }
                    });
                    i = 0;
                    ** while (i < minorClassfiles.length)
                }
lbl-1000:
                // 1 sources

                {
                    file = new File(minorClassfiles[i]);
                    ++i;
                    continue;
                }
            }
            throw var13_15;
        }
        if (classname != null) {
            file = new File(String.valueOf(this.tempDir) + File.separatorChar + classname + ".class");
            file = new File(this.tempDir);
            this.minorPrefix = String.valueOf(classname) + "$";
            minorClassfiles = file.list(new /* invalid duplicate definition of identical inner class */);
            i = 0;
            while (i < minorClassfiles.length) {
                file = new File(minorClassfiles[i]);
                ++i;
            }
        }
        return retval;
    }

    @Override
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
    }

    Object internalCall(Object object, String method, Object[] args) throws BSFException {
        Object retval = null;
        try {
            if (this.javaclass != null) {
                Class[] argtypes = new Class[args.length];
                int i = 0;
                while (i < args.length) {
                    argtypes[i] = args[i].getClass();
                    ++i;
                }
                Method m = MethodUtils.getMethod(this.javaclass, method, argtypes);
                retval = m.invoke(null, args);
            }
        }
        catch (Exception e) {
            throw new BSFException(10, e.getMessage());
        }
        return retval;
    }

    private GeneratedFile openUniqueFile(String directory, String prefix, String suffix) {
        File file = null;
        FileOutputStream fos = null;
        int max = 1000;
        GeneratedFile gf = null;
        String className = null;
        int i = max;
        ++this.uniqueFileOffset;
        while (fos == null && i > 0) {
            block6: {
                try {
                    className = String.valueOf(prefix) + this.uniqueFileOffset;
                    file = new File(String.valueOf(directory) + File.separatorChar + className + suffix);
                    if (file != null && !file.exists()) {
                        fos = new FileOutputStream(file);
                    }
                }
                catch (Exception e) {
                    if (file.exists()) break block6;
                    this.logger.error("openUniqueFile: unexpected ", e);
                }
            }
            --i;
            ++this.uniqueFileOffset;
        }
        if (fos == null) {
            this.logger.error("openUniqueFile: Failed " + max + "attempts.");
        } else {
            gf = new GeneratedFile(file, fos, className);
        }
        return gf;
    }

    private class GeneratedFile {
        File file = null;
        FileOutputStream fos = null;
        String className = null;

        GeneratedFile(File file, FileOutputStream fos, String className) {
            this.file = file;
            this.fos = fos;
            this.className = className;
        }
    }
}

