/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.session;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.session.BcSession;

public class BcSessionValidator
extends BcLoggableObject
implements AutoCloseable {
    private ValidationTask validationTask;
    private Timer timer;
    private Map<String, ? extends BcSession> map;
    private String name = "";

    public Map<String, ? extends BcSession> getMap() {
        return this.map;
    }

    public void setMap(Map<String, ? extends BcSession> objectPoolManager) {
        this.map = objectPoolManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void validate(BcSession session) throws Exception {
        if (session.getInvalidatedTime() != null) {
            this.getLogger().info("Invalidated time=" + BcTimeUtil.toString(session.getInvalidatedTime(), "yyyy/MM/dd HH:mm:ss.SSS"));
            return;
        }
        if (session.getMaxInactiveInterval() <= 0) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - session.getLastAccessedTime();
        if (elapsedTime > (long)(session.getMaxInactiveInterval() * 1000)) {
            this.getLogger().info(String.valueOf(this.name) + " timeout: id=" + session.getId() + " elapsedTime(millis)=" + elapsedTime);
            BcSession oldValue = this.map.remove(session.getId());
            session.invalidate();
        }
    }

    public void validate() throws Exception {
        this.getLogger().debug(String.valueOf(this.name) + " validating...");
        BcSession[] sessions = this.map.values().toArray(new BcSession[0]);
        int i = 0;
        while (i < sessions.length) {
            BcSession session = sessions[i];
            try {
                this.validate(session);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }

    public void startValidationTask(long delay, long period) throws Exception {
        if (this.validationTask != null) {
            throw new Exception("validationTask=" + this.validationTask);
        }
        this.validationTask = new ValidationTask();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.validationTask, delay, period);
        this.getLogger().info(String.valueOf(this.name) + " validationTask started.");
    }

    @Override
    public void close() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.validationTask = null;
        this.timer = null;
    }

    protected class ValidationTask
    extends TimerTask {
        protected ValidationTask() {
        }

        @Override
        public void run() {
            try {
                BcSessionValidator.this.validate();
            }
            catch (Exception ex) {
                BcSessionValidator.this.getLogger().error(ex);
            }
        }
    }
}

