/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.util.FxUtil;

public class HfxMemoryPane
extends HBox {
    Label logField = new Label();
    ScheduledFuture scheduledFuture;

    public HfxMemoryPane() throws Exception {
        this.getChildren().add((Object)this.logField);
        this.setPadding(new Insets(4.0, 4.0, 4.0, 4.0));
        this.setPrefSize(420.0, 26.0);
        FxUtil.setEditable((Node)this, false);
    }

    public void start() throws Exception {
        if (this.scheduledFuture == null) {
            LapTimeRunnable \uff4capTimeRunnable = new LapTimeRunnable();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(\uff4capTimeRunnable, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    public void stop() throws Exception {
        if (this.scheduledFuture != null) {
            if (!this.scheduledFuture.isCancelled()) {
                boolean bl = this.scheduledFuture.cancel(true);
            }
            this.scheduledFuture = null;
        }
    }

    class LapTimeRunnable
    implements Runnable {
        LapTimeRunnable() {
        }

        @Override
        public void run() {
            Runtime \uff52untime = Runtime.getRuntime();
            long heapMax = \uff52untime.maxMemory();
            long heapTotal = \uff52untime.totalMemory();
            long heapFree = \uff52untime.freeMemory();
            long usage = heapTotal - heapFree;
            double usageRate = (double)usage / (double)heapTotal * 100.0;
            final StringBuilder sb = new StringBuilder();
            try {
                sb.append("max:" + BcSIUnitUtil.toByteString(heapMax));
                sb.append("  total:" + BcSIUnitUtil.toByteString(heapTotal));
                sb.append("  usage:" + BcSIUnitUtil.toByteString(usage));
                sb.append("  free:" + BcSIUnitUtil.toByteString(heapFree));
                sb.append("  usageRate:" + String.format("%.1f", usageRate) + "%");
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ((LapTimeRunnable)LapTimeRunnable.this).HfxMemoryPane.this.logField.setText(sb.toString());
                }
            });
        }
    }
}

