/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.client;

import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentLinkedQueue;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf.rmo.ScfLoggerRMO;

public class ScfAbstractProcessingMonitor
extends BcLoggableObject {
    protected String handleId;
    protected int remotePort;
    protected String remoteAddress;
    protected Socket socket;
    protected long startTime;
    protected InvokeThread invokeThread;
    protected ReceiveThread receiveThread;
    protected ConcurrentLinkedQueue<Object> dataQueue = new ConcurrentLinkedQueue();
    protected RmiRequest rmiReq;
    protected RmiRespons rmiRes;

    protected void doConnect() {
        this.startTime = System.currentTimeMillis();
        this.rmiRes = null;
        try {
            this.createLogger();
            this.socket = new Socket(this.remoteAddress, this.remotePort);
            ObjectOutputStream objos = new ObjectOutputStream(this.socket.getOutputStream());
            objos.flush();
            objos.writeObject("logger_100");
            objos.flush();
            objos.reset();
            objos.writeObject(this.handleId);
            objos.flush();
            objos.reset();
            ObjectInputStream objis = new ObjectInputStream(this.socket.getInputStream());
            this.receiveThread = new ReceiveThread();
            this.receiveThread.setLogger(this.getLogger());
            this.receiveThread.start(objis);
            this.invokeThread = new InvokeThread();
            this.invokeThread.start();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }

    protected void createLogger() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfLoggerRMO.class.getName());
        rmiReq.setMethodName(ScfLoggerRMO.Method.createLogger.getMethodName());
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        this.handleId = rmiRes.getDataAsString();
        this.remoteAddress = rmiRes.getDataAsString();
        this.remotePort = rmiRes.getDataAsInteger();
        this.getLogger().debug("createLogger:handleId=" + this.handleId + " remotePort=" + this.remotePort);
    }

    protected void removeLogger() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfLoggerRMO.class.getName());
        rmiReq.setMethodName(ScfLoggerRMO.Method.removeLogger.getMethodName());
        rmiReq.addData(this.handleId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
    }

    protected void rmoteMethodInvoke() {
        try {
            this.rmiReq.putData((Object)"lhId", this.handleId);
            this.rmiRes = ScfClientContainer.getInstance().getAgent().invoke(this.rmiReq);
            this.destruct();
            switch (this.rmiRes.getStatusId()) {
                case 1: {
                    this.successed();
                    break;
                }
                default: {
                    throw new Exception("Invarid rmiRes.statusId=" + this.rmiRes.getStatusId());
                }
            }
        }
        catch (ServerException ex) {
            Throwable causeThrowable = ex.getCause();
            try {
                this.destruct();
            }
            catch (Exception ex2) {
                this.getLogger().error(ex2);
            }
            this.exceptionOccurred(causeThrowable);
        }
        catch (Exception ex) {
            try {
                this.destruct();
            }
            catch (Exception ex2) {
                this.getLogger().error(ex2);
            }
            this.exceptionOccurred(ex);
        }
    }

    public void dataReceived(int command, Object data) throws Exception {
        this.dataQueue.add(data);
    }

    protected void successed() {
    }

    protected void exceptionOccurred(Throwable throwable) {
        this.getLogger().error(throwable);
    }

    protected void destruct() throws Exception {
        if (this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        if (this.handleId != null) {
            try {
                this.removeLogger();
                this.handleId = null;
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        if (this.receiveThread != null) {
            this.receiveThread.stopThread();
            this.receiveThread = null;
        }
        this.invokeThread = null;
    }

    public RmiRequest getRequest() {
        return this.rmiReq;
    }

    public void setRequest(RmiRequest rmiReq) {
        this.rmiReq = rmiReq;
    }

    public RmiRespons getResponse() throws Exception {
        return this.rmiRes;
    }

    class InvokeThread
    extends BcThread {
        public InvokeThread() throws Exception {
            this.setPriority(1);
        }

        @Override
        protected void run2() throws Exception {
            ScfAbstractProcessingMonitor.this.rmoteMethodInvoke();
            this.stopThread();
        }
    }

    class ReceiveThread
    extends BcThread {
        protected ObjectInputStream objis;

        public ReceiveThread() throws Exception {
            this.setPriority(1);
        }

        public void start(ObjectInputStream objis) throws Exception {
            this.objis = objis;
            this.startThread();
        }

        @Override
        protected void run2() throws Exception {
            try {
                int command = (Integer)this.objis.readObject();
                byte[] dataBytes = (byte[])this.objis.readObject();
                ScfAbstractProcessingMonitor.this.dataReceived(command, dataBytes);
            }
            catch (EOFException command) {
            }
            catch (SocketException command) {
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                this.stopThread();
                try {
                    this.objis.close();
                }
                catch (Exception ex2) {
                    this.getLogger().error(ex2);
                }
            }
        }
    }
}

