/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.module.xsod.fx.XsodController;
import jp.co.extreme.module.xsod.fx.XsodOrderRowPane;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodOrder;

public class XsodOrderPlanListPane
extends FxBorderPane {
    FxBorderPane borderPane = new FxBorderPane();
    HBox topBox = XsodUiFactory.getInstance().createHBox();
    HBox bottomBox = XsodUiFactory.getInstance().createHBox();
    Button cancelButton;
    Button nextButton;
    Pane listBasePane;
    List<XsodOrderRowPane> orderRowPaneList;

    public XsodOrderPlanListPane() throws Exception {
        this.cancelButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u6ce8\u6587\u3092\u3084\u3081\u308b.toString());
        this.nextButton = XsodUiFactory.getInstance().createButton(XsodWords.getInstance().\u6ce8\u6587\u3059\u308b.toString());
        this.listBasePane = new Pane();
        this.orderRowPaneList = new ArrayList<XsodOrderRowPane>();
        this.initComponent();
        this.clear();
    }

    protected void initComponent() throws Exception {
        Text titleText = new Text();
        titleText.setFill((Paint)Color.VIOLET);
        titleText.setStrokeWidth(1.5);
        titleText.setStroke((Paint)Color.VIOLET);
        titleText.setUnderline(true);
        titleText.setFont(XsodUiFactory.getInstance().defaultFont);
        titleText.setText(String.valueOf(XsodWords.getInstance().\u6ce8\u6587\u4e88\u5b9a.toString()) + "\uff08\u6700\u5927" + XsodUiFactory.getInstance().orderPlanMax + "\u500b\u307e\u3067\uff09");
        this.topBox.setAlignment(Pos.CENTER);
        this.topBox.getChildren().addAll((Object[])new Node[]{titleText});
        this.borderPane.setTop((Node)this.topBox);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.cancelButton});
        this.nextButton.setOnAction(this.actionEventHandler);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.nextButton});
        this.bottomBox.setAlignment(Pos.CENTER);
        this.borderPane.setBottom((Node)this.bottomBox);
        this.borderPane.setCenter((Node)this.listBasePane);
        StackPane baseParent = XsodUiFactory.getInstance().createBackgrondNode((Node)this.borderPane, Color.AZURE);
        this.setCenter((Node)baseParent);
    }

    public void clear() throws Exception {
        this.orderRowPaneList.clear();
        this.dispOrderList();
    }

    public void addOrder(XsodOrder order) throws Exception {
        BcLogUtil.debug("addOrder\uff1aorder.merchandiseCode=" + order.merchandiseCode);
        XsodOrderRowPane orderRowPane1 = null;
        int i = 0;
        while (i < this.orderRowPaneList.size()) {
            XsodOrderRowPane orderRowPane2 = this.orderRowPaneList.get(i);
            if (order.merchandiseCode.equals(orderRowPane2.order.merchandiseCode)) {
                orderRowPane1 = orderRowPane2;
                break;
            }
            ++i;
        }
        if (orderRowPane1 == null) {
            if ((double)this.orderRowPaneList.size() >= XsodUiFactory.getInstance().orderPlanMax) {
                BcLogUtil.debug("\u6ce8\u6587\u4e88\u5b9a\u6700\u5927\u6570(" + XsodUiFactory.getInstance().orderPlanMax + ")\u306b\u5230\u9054");
                return;
            }
            orderRowPane1 = new XsodOrderRowPane(1);
            orderRowPane1.setData(order);
            this.orderRowPaneList.add(orderRowPane1);
            this.dispOrderList();
        } else {
            orderRowPane1.order.quantity += order.quantity;
            orderRowPane1.update();
        }
    }

    protected void dispOrderList() throws Exception {
        this.listBasePane.getChildren().clear();
        double x = 4.0;
        double rowSpace = 8.0;
        int i = 0;
        while (i < this.orderRowPaneList.size()) {
            XsodOrderRowPane orderRowPane = this.orderRowPaneList.get(i);
            double y = (double)i * (XsodUiFactory.getInstance().orderPlanRowHeight + rowSpace);
            FxUtil.setLocation(this.listBasePane, (Region)orderRowPane, x, y, 200.0, XsodUiFactory.getInstance().orderPlanRowHeight);
            ++i;
        }
        if (this.orderRowPaneList.size() > 0) {
            this.cancelButton.setDisable(false);
            this.nextButton.setDisable(false);
        } else {
            this.cancelButton.setDisable(true);
            this.nextButton.setDisable(true);
        }
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.cancelButton) {
            this.clear();
        } else if (ev.getSource() == this.nextButton) {
            ArrayList<XsodOrder> orderList = new ArrayList<XsodOrder>();
            int i = 0;
            while (i < this.orderRowPaneList.size()) {
                XsodOrderRowPane orderRowPane = this.orderRowPaneList.get(i);
                orderList.add(orderRowPane.order);
                ++i;
            }
            XsodController.getInstance().confirmOrderFix(orderList);
        }
    }
}

