/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilCrawl;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureParameter;

public class XfilVisitFile
extends BcLoggableObject {
    boolean isWindows = BcRuntimeUtil.getOsType() == BcRuntimeUtil.OsType.Windows;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileVisitResult visitFile(Path path, DtsSession dtsSessionWk, XfilUriEntityDAO uriEntityDao, boolean overwrirte, List<String> fileExtentionList, long indexGroupId, XfilCrawl crawl, XfilVideoCaptureParameter videoCaptureParameter, String note, List<String> exclusionPathList) throws Exception {
        this.getLogger().info("SimpleFileVisitor:path=" + path + " file=" + path.toFile().getPath() + " exists=" + path.toFile().exists());
        if (Files.isHidden(path)) {
            this.getLogger().info("hidden");
            return FileVisitResult.CONTINUE;
        }
        if (!BcCollectionUtil.isEmpty(exclusionPathList)) {
            for (String exclusionPath : exclusionPathList) {
                if (!XfilUtil.isTarget(path.toString(), exclusionPath, true)) continue;
                this.getLogger().debug("exclusion:" + exclusionPath);
                if (!Files.isDirectory(path, new LinkOption[0])) return FileVisitResult.CONTINUE;
                return FileVisitResult.SKIP_SUBTREE;
            }
        }
        XfilUriEntity uriEntity1 = XfilUtil.toUriEntity(path, true);
        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
        if (Files.isDirectory(path, new LinkOption[0])) {
            if (!path.toFile().getName().equalsIgnoreCase("VIDEO_TS")) return FileVisitResult.CONTINUE;
            uriEntity1 = XfilUtil.toUriEntity(path.getParent(), this.isWindows);
            uriEntity1.childCount = path.toFile().listFiles().length;
            fileVisitResult = FileVisitResult.SKIP_SUBTREE;
        } else {
            uriEntity1.childCount = -1;
            if (!XfilUtil.isAllowedFileExtention(fileExtentionList, uriEntity1.extention)) {
                String msg = String.format("Extention '%s' is not allowd.", uriEntity1.extention);
                this.getLogger().warning(msg);
                return FileVisitResult.CONTINUE;
            }
        }
        List uriEntityList = uriEntityDao.getListByPath(dtsSessionWk, indexGroupId, uriEntity1.directory, uriEntity1.name, false);
        if (!BcCollectionUtil.isEmpty(uriEntityList)) {
            XfilUriEntity uriEntity2 = (XfilUriEntity)BcCollectionUtil.getFirst(uriEntityList);
            String msg = BcWords.getInstance().$_exists(BcStringUtil.singleQuotation(uriEntity1.name));
            this.getLogger().info(msg);
            if (!overwrirte) {
                return FileVisitResult.CONTINUE;
            }
            uriEntity1.id = uriEntity2.id;
            uriEntity1.addTimestamp = uriEntity2.addTimestamp;
            uriEntity1.updateTimestamp = uriEntity2.updateTimestamp;
        }
        uriEntity1.indexGroupId = indexGroupId;
        uriEntity1.crawlId = crawl.id;
        if (videoCaptureParameter != null) {
            uriEntity1.videoCaptureParameter = JacksonUtil.getObjectMapper().writeValueAsString((Object)videoCaptureParameter);
        }
        uriEntity1.text01 = note;
        uriEntityDao.putEntity(dtsSessionWk, uriEntity1);
        this.getLogger().info("ADD:id=" + uriEntity1.id + " path=" + path.toString());
        return fileVisitResult;
    }
}

