/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.fx.XdtsProfileTableModel2;
import jp.co.extreme.module.xdts.stub.XdtsProfileStub;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.swing.SwgTableViewUtil;

class XdtsProfileSelectPane2
extends FxBorderPane {
    XdtsProfileTableModel2 bcTableModel = new XdtsProfileTableModel2();
    InnerTableView tableView = new InnerTableView();
    int columnIndex;

    public XdtsProfileSelectPane2() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.bcTableModel.profileList = XdtsProfileStub.getInstance().getProfileList();
        FxTableRowList tableRowList = new FxTableRowList(this.bcTableModel);
        BcTableColumnModel bcTableColumnModel = XdtsUtil.createDataSourceTableColumnModel(false);
        SwgTableViewUtil.setEditable(bcTableColumnModel, false);
        BcTableColumn bcTableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().selection;
        mmdField.dataClass = Boolean.class;
        mmdField.columnCount = 8;
        bcTableColumn.setMmdField(mmdField);
        bcTableColumn.isEditable = true;
        bcTableColumnModel.addColumn(bcTableColumn);
        this.columnIndex = bcTableColumnModel.getColumnCount() - 1;
        this.tableView = new InnerTableView();
        FxTableUtil.createColumn(bcTableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowList);
        this.tableView.setEditable(true);
        FxTableUtil.setSortable(this.tableView, false);
        TableColumn fxTableColumn = (TableColumn)this.tableView.getColumns().get(this.tableView.getColumns().size() - 1);
        this.tableView.getColumns().remove((Object)fxTableColumn);
        this.tableView.getColumns().add(0, (Object)fxTableColumn);
        this.tableView.setTableMenuButtonVisible(true);
        this.setCenter((Node)this.tableView);
        FxUtil.defaultInitialize((Node)this);
    }

    protected List<Long> getDataSourceIdList() throws Exception {
        ArrayList<Long> dataSourceIdList = new ArrayList<Long>();
        int i = 0;
        while (i < this.bcTableModel.getRowCount()) {
            Object isSelect = this.bcTableModel.getValueAt(i, this.columnIndex);
            if (Boolean.TRUE.equals(isSelect)) {
                Long dataSourceId = (Long)this.bcTableModel.getValueAt(i, 0);
                dataSourceIdList.add(dataSourceId);
            }
            ++i;
        }
        return dataSourceIdList;
    }

    protected void setDataSourceIdList(Collection<Long> dataSourceIdCollection) throws Exception {
        int i = 0;
        while (i < this.bcTableModel.getRowCount()) {
            Long dataSourceId1 = (Long)this.bcTableModel.getValueAt(i, 0);
            Boolean isSelect = Boolean.FALSE;
            for (Long dataSourceId2 : dataSourceIdCollection) {
                if (!dataSourceId1.equals(dataSourceId2)) continue;
                isSelect = Boolean.TRUE;
                break;
            }
            this.bcTableModel.setValueAt(isSelect, i, this.columnIndex);
            ++i;
        }
    }

    public void storeData(HtsvSiteContext siteContext) throws Exception {
        String dataSourceId = BcCsvUtil.toCsv(this.getDataSourceIdList());
        siteContext.propertyMap.put(XdtsConstants.Property.dataSourceId.name(), dataSourceId);
    }

    public void setData(HtsvSiteContext siteContext) throws Exception {
        String dataSourceIdStr = siteContext.propertyMap.get(XdtsConstants.Property.dataSourceId.name());
        List<String> dataSourceIdStrList = BcCsvUtil.parseCsvRow(dataSourceIdStr, true);
        BcLogUtil.debug("dataSourceIdStrList=" + dataSourceIdStrList);
        ArrayList<Long> dataSourceIdList = new ArrayList<Long>();
        int i = 0;
        while (i < dataSourceIdStrList.size()) {
            long dataSourceId = Integer.parseInt(dataSourceIdStrList.get(i));
            dataSourceIdList.add(dataSourceId);
            ++i;
        }
        this.setDataSourceIdList(dataSourceIdList);
    }

    public BcResult validation() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        String[] items = new String[]{SqlWords.getInstance().dataSource};
        inputValidator.select_$_or_more_$(items, this.getDataSourceIdList().size(), 1L, result.getErrorList());
        return result;
    }

    class InnerTableView<S>
    extends FxTableView<S> {
        public InnerTableView() throws Exception {
            TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionMode(SelectionMode.SINGLE);
        }

        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
        }
    }
}

