/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import com.sun.xml.internal.ws.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxComboBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.extension.FxxPeriodPane;
import jp.co.extreme.fx.extension.FxxRadioButtonControl;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsCheckBoxPane;
import jp.co.extreme.module.xdts.fx.XdtsControlOptionPane;
import jp.co.extreme.module.xdts.fx.XdtsControlUnit;
import jp.co.extreme.module.xdts.fx.XdtsExtractionConditionEditPane;
import jp.co.extreme.module.xdts.fx.XdtsFxCondition;
import jp.co.extreme.module.xdts.fx.XdtsSelectColumnPane;
import jp.co.extreme.module.xdts.fx.XdtsStagePane;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsColumn;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import jp.co.extreme.module.xdts.swg.XdtsConditionTempPanel;
import jp.co.extreme.swing.SwgUtil;

public class XdtsConditionModelToFx
extends BcLoggableObject {
    protected EventHandler<ActionEvent> actionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent ev) {
            try {
                if (ev.getSource() instanceof Node) {
                    Node node = (Node)ev.getSource();
                    XdtsControlUnit controlUnit = (XdtsControlUnit)node.getUserData();
                    XdtsConditionModelToFx.this.optionButtonAction(node, controlUnit);
                }
            }
            catch (Exception ex) {
                SwgUtil.getExceptionHandler().handleException(ex, null);
            }
        }
    };

    protected XdtsControlUnit createControlUnit(XdtsSelect selectContext, XdtsControlContext controlContext, XdtsUserSetting userSetting, boolean isEdid) throws Exception {
        Region region;
        FxTextArea textArea;
        FxNodeUnit nodeUnit = new FxNodeUnit();
        String defaultValue = XdtsUtil.getDefaultValue(controlContext, userSetting);
        if (controlContext.contextType == XdtsConstants.ContextType.Select) {
            XdtsSelectColumnPane selectColumnPane = new XdtsSelectColumnPane();
            int i = 0;
            while (i < selectContext.columnList.size()) {
                XdtsColumn selectColumn = selectContext.columnList.get(i);
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(selectColumn.elemet.template);
                row.add(selectColumn.alias);
                row.add(selectColumn.order);
                selectColumnPane.tableModel.addRow(row);
                ++i;
            }
            selectColumnPane.temp();
            selectColumnPane.setPrefSize(580.0, 320.0);
            nodeUnit.addRightNodes(new Node[]{selectColumnPane});
        } else if (controlContext.contextType == XdtsConstants.ContextType.From) {
            textArea = new FxTextArea();
            textArea.setPrefColumnCount(controlContext.columnCount);
            textArea.setPrefRowCount(controlContext.rowCount);
            textArea.setText(selectContext.from.template);
            FxUtil.setPrefSize((Node)textArea);
            nodeUnit.addRightNodes(new Node[]{textArea});
        } else if (controlContext.contextType == XdtsConstants.ContextType.Where) {
            textArea = new FxTextArea();
            textArea.setPrefColumnCount(controlContext.columnCount);
            textArea.setPrefRowCount(controlContext.rowCount);
            textArea.setText(selectContext.whereBase.template);
            FxUtil.setPrefSize((Node)textArea);
            nodeUnit.addRightNodes(new Node[]{textArea});
        } else if (controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
            region = this.createReagion(controlContext, defaultValue);
            nodeUnit.addRightNodes(new Node[]{region});
        } else if (controlContext.contextType == XdtsConstants.ContextType.General || controlContext.contextType == XdtsConstants.ContextType.RowLimit) {
            region = this.createReagion(controlContext, defaultValue);
            nodeUnit.addRightNodes(new Node[]{region});
        }
        Tooltip tooltip = null;
        if (!BcStringUtil.isEmpty(controlContext.description)) {
            tooltip = new Tooltip(controlContext.description);
        }
        this.setTooltip(nodeUnit.getRightNodeList(), tooltip);
        FxLabel label = new FxLabel();
        label.setText(controlContext.displayName);
        this.setTooltip((Node)label, tooltip);
        nodeUnit.setLeftNode((Node)label);
        XdtsControlUnit controlUnit = new XdtsControlUnit();
        controlUnit.selectContext = selectContext;
        controlUnit.controlContext = controlContext;
        controlUnit.nodeUnit = nodeUnit;
        controlUnit.userSetting = userSetting;
        if (isEdid) {
            FxButton optionButton = new FxButton();
            optionButton.setOnAction(this.actionEventHandler);
            optionButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
            FxUtil.setFixedSize((Region)optionButton, 20.0, 20.0);
            optionButton.setUserData(controlUnit);
            nodeUnit.addRightNodes(new Node[]{optionButton});
        }
        return controlUnit;
    }

    protected Region createReagion(XdtsControlContext controlContext, String defaultValue) throws Exception {
        Object region = null;
        List<String> optionList = XdtsUtil.createOptionList(controlContext);
        if (controlContext.controlType == XdtsConstants.ControlType.Text) {
            if (BcCollectionUtil.isEmpty(optionList)) {
                if (controlContext.rowCount > 1) {
                    FxTextArea textArea = new FxTextArea();
                    textArea.setPrefColumnCount(controlContext.columnCount);
                    textArea.setPrefRowCount(controlContext.rowCount);
                    textArea.setText(defaultValue);
                    region = textArea;
                } else {
                    FxTextField textField = new FxTextField();
                    textField.setPrefColumnCount(controlContext.columnCount);
                    textField.setText(defaultValue);
                    region = textField;
                }
            } else {
                FxComboBox comboBox = new FxComboBox();
                comboBox.setEditable(true);
                comboBox.columnCount.set(controlContext.columnCount);
                for (String option : optionList) {
                    comboBox.getItems().add((Object)option);
                }
                if (!BcStringUtil.isEmpty(defaultValue)) {
                    comboBox.getSelectionModel().select((Object)defaultValue);
                }
                FxUtil.setPrefSize(comboBox);
                region = comboBox;
            }
        } else if (controlContext.controlType == XdtsConstants.ControlType.CheckBox) {
            XdtsCheckBoxPane checkBoxPane = new XdtsCheckBoxPane(21);
            FxCssUtil.setBackgroundColor(checkBoxPane, Color.RED);
            for (String option : optionList) {
                FxCheckBox checkBox = new FxCheckBox();
                checkBox.setUserData(option);
                checkBox.setText(option);
                FxUtil.setPrefSize((Node)checkBox);
                checkBoxPane.addCheckBox((ButtonBase)checkBox);
                if (!option.equals(defaultValue)) continue;
                checkBox.setSelected(true);
            }
            checkBoxPane.setPrefWidth(checkBoxPane.width);
            checkBoxPane.setPrefHeight(22.0);
            region = checkBoxPane;
        } else if (controlContext.controlType == XdtsConstants.ControlType.RadioButton) {
            FxxRadioButtonControl radioButtonControl = new FxxRadioButtonControl(true);
            FxCssUtil.setBackgroundColor((Region)radioButtonControl, Color.RED);
            if (!BcCollectionUtil.isEmpty(optionList)) {
                String[] keys;
                String[] values = keys = BcStringUtil.toStringArray(optionList);
                radioButtonControl.setData(keys, values);
            }
            radioButtonControl.setUnspecified(true);
            if (!BcStringUtil.isEmpty(defaultValue)) {
                radioButtonControl.setInputText(defaultValue);
            }
            region = radioButtonControl;
        } else if (controlContext.controlType == XdtsConstants.ControlType.DateTime || controlContext.controlType == XdtsConstants.ControlType.Date) {
            FxxPeriodPane periodPane = null;
            if (controlContext.controlType == XdtsConstants.ControlType.DateTime) {
                periodPane = new FxxPeriodPane(2);
            } else if (controlContext.controlType == XdtsConstants.ControlType.Date) {
                periodPane = new FxxPeriodPane(1);
            }
            Calendar calendar1 = null;
            Calendar calendar2 = null;
            if (!BcStringUtil.isEmpty(defaultValue)) {
                List<String> valueList = BcCsvUtil.parseCsvRow(defaultValue, true);
                calendar1 = BcTimeUtil.toCalendar(valueList.get(0));
                calendar2 = BcTimeUtil.toCalendar(valueList.get(1));
            }
            periodPane.dateTimePane1.setCalendar(calendar1);
            periodPane.dateTimePane2.setCalendar(calendar2);
            region = periodPane;
        } else if (controlContext.controlType == XdtsConstants.ControlType.Boolean) {
            FxxRadioButtonControl radioButtonControl = new FxxRadioButtonControl(true);
            radioButtonControl.setUnspecified(true);
            String[] keys = new String[]{Boolean.toString(true), Boolean.toString(false)};
            String[] values = new String[]{StringUtils.capitalize((String)Boolean.toString(true)), StringUtils.capitalize((String)Boolean.toString(false))};
            radioButtonControl.setData(keys, values);
            radioButtonControl.setUnspecified(true);
            if (!BcStringUtil.isEmpty(defaultValue)) {
                boolean bool = BcBooleanUtil.parseBoolean(defaultValue);
                radioButtonControl.setInputText(Boolean.toString(bool));
            }
            region = radioButtonControl;
        } else {
            throw new Exception("controlContext.controlType=" + (Object)((Object)controlContext.controlType));
        }
        return region;
    }

    public void setTooltip(Node node, Tooltip tooltip) throws Exception {
        if (node instanceof Control) {
            Control control = (Control)node;
            control.setTooltip(tooltip);
        }
    }

    public void setTooltip(Collection<Node> nodeCollection, Tooltip tooltip) throws Exception {
        for (Node node : nodeCollection) {
            this.setTooltip(node, tooltip);
        }
    }

    public String conv(XdtsColumn selectColumn) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(selectColumn.elemet);
        if (!BcStringUtil.isEmpty(selectColumn.alias)) {
            sb.append(" AS ");
            sb.append(selectColumn.alias);
        }
        return sb.toString();
    }

    public XdtsFxCondition createFxCondition(XdtsExtractionCondition extractionCondition, XdtsUserSetting userSetting, boolean isEdit) throws Exception {
        XdtsFxCondition fxCondition = new XdtsFxCondition();
        fxCondition.controlUnitMap1 = new HashMap<Integer, List<XdtsControlUnit>>();
        this.getLogger().info("XdtsSelectContext\u6570=" + extractionCondition.selectList.size());
        int i = 0;
        while (i < extractionCondition.selectList.size()) {
            XdtsSelect selectContext = extractionCondition.selectList.get(i);
            List<XdtsControlUnit> controlUnitList1 = this.createControlUnitList(selectContext, selectContext.controlContextList, userSetting, isEdit);
            fxCondition.controlUnitMap1.put(selectContext.id, controlUnitList1);
            ++i;
        }
        return fxCondition;
    }

    protected List<XdtsControlUnit> createControlUnitList(XdtsSelect selectContext, List<XdtsControlContext> controlContextList, XdtsUserSetting userSetting, boolean isEdit) throws Exception {
        List<XdtsControlContext> controlContextList2 = XdtsSqlParserUtil.sortControlContext(controlContextList);
        ArrayList<XdtsControlUnit> controlUnitList = new ArrayList<XdtsControlUnit>();
        for (XdtsControlContext controlContext : controlContextList2) {
            if (!isEdit && controlContext.displayOrder <= 0) continue;
            XdtsControlUnit controlUnit = this.createControlUnit(selectContext, controlContext, userSetting, isEdit);
            controlUnitList.add(controlUnit);
        }
        return controlUnitList;
    }

    public static List<XdtsControlUnit> sortControlUnit(Collection<XdtsControlUnit> controlUnitCollection, boolean isDisp) throws Exception {
        BcTableModel sortTable = BcTableUtil.createTableModelByHeaderValues("order", "value");
        for (XdtsControlUnit controlUnit : controlUnitCollection) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(controlUnit.controlContext.displayOrder);
            row.add(controlUnit);
            sortTable.addRow(row);
        }
        BcTableUtil.sort(sortTable, true, 0);
        ArrayList<XdtsControlUnit> controlUnitList = new ArrayList<XdtsControlUnit>();
        int i = 0;
        while (i < sortTable.getRowCount()) {
            XdtsControlUnit controlUnit = (XdtsControlUnit)sortTable.getValueAt(i, 1);
            if (isDisp) {
                if (controlUnit.controlContext.displayOrder > 0) {
                    controlUnitList.add(controlUnit);
                }
            } else {
                controlUnitList.add(controlUnit);
            }
            ++i;
        }
        return controlUnitList;
    }

    public void optionButtonAction(Node optionButton, final XdtsControlUnit controlUnit1) throws Exception {
        Object windowObject = FxUtil.getWindow2(optionButton);
        Window window = null;
        java.awt.Window awtWindow = null;
        if (windowObject instanceof Window) {
            window = (Window)windowObject;
        } else {
            boolean cfr_ignored_0 = windowObject instanceof java.awt.Window;
        }
        final XdtsControlOptionPane controlOptionPane = new XdtsControlOptionPane(null);
        controlOptionPane.setControlContext(controlUnit1.controlContext);
        if (window != null) {
            InnerStagePane stagePane = new InnerStagePane();
            stagePane.setCenter((Node)controlOptionPane);
            class CloseEventHandler
            implements BcEventHandler<BcEvent> {
                private final /* synthetic */ InnerStagePane val$stagePane;

                CloseEventHandler(InnerStagePane innerStagePane) {
                    this.val$stagePane = innerStagePane;
                }

                @Override
                public void handle(BcEvent ev) throws Exception {
                    this.val$stagePane.close();
                }
            }
            CloseEventHandler closeEventHandler = new CloseEventHandler(stagePane);
            controlOptionPane.closeHandlerList.addEventHandler(closeEventHandler);
            stagePane.show(window, XdtsWords.getInstance().controlSettings.toPlain());
            if (controlOptionPane.isCompleted) {
                Parent parent;
                XdtsControlUnit controlUnit2 = this.createControlUnit(controlUnit1.selectContext, controlUnit1.controlContext, controlUnit1.userSetting, false);
                Node node = BcCollectionUtil.getLast(controlUnit1.nodeUnit.getRightNodeList());
                controlUnit1.nodeUnit = controlUnit2.nodeUnit;
                controlUnit1.nodeUnit.addRightNodes(node);
                Parent preParent = optionButton.getParent();
                while ((parent = preParent.getParent()) != null) {
                    if (parent instanceof XdtsExtractionConditionEditPane) {
                        XdtsExtractionConditionEditPane extractionConditionEditPane = (XdtsExtractionConditionEditPane)parent;
                        extractionConditionEditPane.repaint();
                        break;
                    }
                    preParent = parent;
                }
            }
        } else {
            final java.awt.Window awtWindow2 = awtWindow;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FxScene fxScene = new FxScene((Parent)controlOptionPane);
                        JFXPanel jfxPanel = new JFXPanel();
                        jfxPanel.setScene((Scene)fxScene);
                        XdtsConditionTempPanel conditionTempPanel = new XdtsConditionTempPanel();
                        conditionTempPanel.add((Component)jfxPanel, "Center");
                        conditionTempPanel.showAsDialog(awtWindow2, controlUnit1.controlContext.tableColumnName);
                        boolean cfr_ignored_0 = controlOptionPane.isCompleted;
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }
    }

    class InnerStagePane
    extends XdtsStagePane {
        @Override
        protected Stage createStage() throws Exception {
            Stage stage = super.createStage();
            stage.setWidth(900.0);
            stage.setHeight(600.0);
            stage.setResizable(false);
            stage.getIcons().add((Object)FxImageHelper.getImage("gear_64x64.png"));
            return stage;
        }
    }
}

