/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcGeneralComparator;
import jp.co.extreme.base.util.BcIndexer;
import jp.co.extreme.base.util.BcReflectUtil;

public final class BcSortUtil {
    protected static BcTableColumnModel createTableColumnModel(List<Object> fieldNameList) throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        int i = 0;
        while (i < fieldNameList.size()) {
            Object fieldName = fieldNameList.get(i);
            BcTableColumn tableColumn = new BcTableColumn();
            tableColumn.setHeaderValue(fieldName);
            tableColumnModel.addColumn(tableColumn);
            ++i;
        }
        return tableColumnModel;
    }

    public static <T> BcIndexer createIndexer(Collection<T> entityCollection, List<Object> fieldNameList, boolean ascending) throws Exception {
        if (entityCollection.size() <= 0) {
            return new BcIndexer();
        }
        BcTableColumnModel tableColumnModel = BcSortUtil.createTableColumnModel(fieldNameList);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        ArrayList<BcTableColumn> sortColumnList = new ArrayList<BcTableColumn>();
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            tableColumn.ascending = ascending;
            sortColumnList.add(tableColumn);
            ++i;
        }
        for (T entity : entityCollection) {
            List<Object> row = BcReflectUtil.createValueList(entity, fieldNameList);
            tableModel.addRow(row);
        }
        BcTableUtil.sort(tableModel, sortColumnList);
        return tableModel.getIndexer();
    }

    public static <T> BcIndexer createIndexer(Collection<T> entityCollection, boolean ascending, Object ... fieldNames) throws Exception {
        return BcSortUtil.createIndexer(entityCollection, Arrays.asList(fieldNames), ascending);
    }

    public static <T> List<T> createList(List<T> entityList, BcIndexer indexer) throws Exception {
        ArrayList<T> newList = new ArrayList<T>();
        int i = 0;
        while (i < indexer.getSize()) {
            int modelIndex = indexer.toModelId(i);
            T entity = entityList.get(modelIndex);
            newList.add(entity);
            ++i;
        }
        return newList;
    }

    public static <T> void sort(List<T> entityList, List<Object> fieldNameList, boolean ascending) throws Exception {
        BcIndexer indexer = BcSortUtil.createIndexer(entityList, fieldNameList, ascending);
        List<T> newList = BcSortUtil.createList(entityList, indexer);
        entityList.clear();
        entityList.addAll(newList);
    }

    public static <T> void sort(List<T> entityList, boolean ascending, Object ... fieldNames) throws Exception {
        BcSortUtil.sort(entityList, Arrays.asList(fieldNames), ascending);
    }

    public static <T> List sort(Collection<T> entityCollection, boolean ascending, Object ... fieldNames) throws Exception {
        ArrayList<T> entityList = new ArrayList<T>(entityCollection);
        BcSortUtil.sort(entityList, ascending, fieldNames);
        return entityList;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator comparator) throws Exception {
        Object[] array = collection.toArray();
        Arrays.sort(array, comparator);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static <T> List<T> sort(Collection<T> collection) throws Exception {
        return BcSortUtil.sort(collection, BcGeneralComparator.getInstance());
    }
}

