/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.runtime;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.zip.BcZipUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class BcUrlClassLoader
extends URLClassLoader {
    private Map<String, byte[]> bytesMap = new HashMap<String, byte[]>();

    public BcUrlClassLoader(URL[] urls, ClassLoader parentLoader) {
        super(urls, parentLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String className) throws ClassNotFoundException {
        Map<String, byte[]> map = this.bytesMap;
        synchronized (map) {
            byte[] bytes = this.bytesMap.get(className);
            if (bytes == null) {
                try {
                    bytes = this.findClass_L2(className);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                if (bytes != null) {
                    this.bytesMap.put(className, bytes);
                }
            }
            if (bytes != null) {
                return this.defineClass(className, bytes, 0, bytes.length);
            }
        }
        throw new ClassNotFoundException(className);
    }

    protected byte[] findClass_L2(String className) throws Exception {
        String className2 = String.valueOf(className.replace('.', '/')) + '.' + "class";
        byte[] bytes = null;
        URL[] urls = this.getURLs();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            if (BcZipUtil.isZipFile(url.getFile())) {
                bytes = this.findClass_L3(url, className2);
                if (bytes != null) {
                    break;
                }
            } else {
                BcLogUtil.warning("Not suported file." + url.getFile());
            }
            ++i;
        }
        return bytes;
    }

    protected byte[] findClass_L3(URL url, String className2) throws Exception {
        byte[] bytes = null;
        try (ZipFile zipFile = new ZipFile(url.getFile());){
            List<ZipEntry> zipEntryList = BcZipUtil.createEntryList(zipFile);
            int i = 0;
            while (i < zipEntryList.size()) {
                ZipEntry zipEntry = zipEntryList.get(i);
                if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(className2)) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BcZipUtil.extract(zipFile, zipEntry, baos);
                    bytes = baos.toByteArray();
                    break;
                }
                ++i;
            }
        }
        return bytes;
    }

    public void addZipFile(File file) throws Exception {
        try (ZipFile zipFile = new ZipFile(file);){
            List<ZipEntry> zipEntryList = BcZipUtil.createEntryList(zipFile);
            int i = 0;
            while (i < zipEntryList.size()) {
                ZipEntry zipEntry = zipEntryList.get(i);
                if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(".class")) {
                    String className = BcFileUtil.getBaseName(zipEntry.getName().replace('/', '.'));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BcZipUtil.extract(zipFile, zipEntry, baos);
                    byte[] bytes = baos.toByteArray();
                    this.bytesMap.put(className, bytes);
                }
                ++i;
            }
        }
    }
}

