/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSTypeDefinition;

public final class XSNamedMap4Types
extends XSNamedMapImpl {
    private final short fType;

    public XSNamedMap4Types(String namespace, SymbolHash map, short type) {
        super(namespace, map);
        this.fType = type;
    }

    public XSNamedMap4Types(String[] namespaces, SymbolHash[] maps, int num, short type) {
        super(namespaces, maps, num);
        this.fType = type;
    }

    @Override
    public synchronized int getLength() {
        if (this.fLength == -1) {
            int length = 0;
            int i = 0;
            while (i < this.fNSNum) {
                length += this.fMaps[i].getLength();
                ++i;
            }
            int pos = 0;
            Object[] array = new XSObject[length];
            int i2 = 0;
            while (i2 < this.fNSNum) {
                pos += this.fMaps[i2].getValues(array, pos);
                ++i2;
            }
            this.fLength = 0;
            this.fArray = new XSObject[length];
            int i3 = 0;
            while (i3 < length) {
                XSTypeDefinition type = (XSTypeDefinition)array[i3];
                if (type.getTypeCategory() == this.fType) {
                    this.fArray[this.fLength++] = type;
                }
                ++i3;
            }
        }
        return this.fLength;
    }

    @Override
    public XSObject itemByName(String namespace, String localName) {
        int i = 0;
        while (i < this.fNSNum) {
            if (XSNamedMap4Types.isEqual(namespace, this.fNamespaces[i])) {
                XSTypeDefinition type = (XSTypeDefinition)this.fMaps[i].get(localName);
                if (type != null && type.getTypeCategory() == this.fType) {
                    return type;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    @Override
    public synchronized XSObject item(int index) {
        if (this.fArray == null) {
            this.getLength();
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[index];
    }
}

