/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class Log4jListener
implements BuildListener {
    private final boolean initialized;
    public static final String LOG_ANT = "org.apache.tools.ant";

    public Log4jListener() {
        Logger log = Logger.getLogger(LOG_ANT);
        Logger rootLog = Logger.getRootLogger();
        boolean bl = this.initialized = !(rootLog.getAllAppenders() instanceof NullEnumeration);
        if (!this.initialized) {
            log.error("No log4j.properties in build area");
        }
    }

    @Override
    public void buildStarted(BuildEvent event) {
        if (this.initialized) {
            Logger log = Logger.getLogger(Project.class.getName());
            log.info("Build started.");
        }
    }

    @Override
    public void buildFinished(BuildEvent event) {
        if (this.initialized) {
            Logger log = Logger.getLogger(Project.class.getName());
            if (event.getException() == null) {
                log.info("Build finished.");
            } else {
                log.error("Build finished with error.", event.getException());
            }
        }
    }

    @Override
    public void targetStarted(BuildEvent event) {
        if (this.initialized) {
            Logger log = Logger.getLogger(Target.class.getName());
            log.info("Target \"" + event.getTarget().getName() + "\" started.");
        }
    }

    @Override
    public void targetFinished(BuildEvent event) {
        if (this.initialized) {
            String targetName = event.getTarget().getName();
            Logger cat = Logger.getLogger(Target.class.getName());
            if (event.getException() == null) {
                cat.info("Target \"" + targetName + "\" finished.");
            } else {
                cat.error("Target \"" + targetName + "\" finished with error.", event.getException());
            }
        }
    }

    @Override
    public void taskStarted(BuildEvent event) {
        if (this.initialized) {
            Task task = event.getTask();
            Logger log = Logger.getLogger(task.getClass().getName());
            log.info("Task \"" + task.getTaskName() + "\" started.");
        }
    }

    @Override
    public void taskFinished(BuildEvent event) {
        if (this.initialized) {
            Task task = event.getTask();
            Logger log = Logger.getLogger(task.getClass().getName());
            if (event.getException() == null) {
                log.info("Task \"" + task.getTaskName() + "\" finished.");
            } else {
                log.error("Task \"" + task.getTaskName() + "\" finished with error.", event.getException());
            }
        }
    }

    @Override
    public void messageLogged(BuildEvent event) {
        if (this.initialized) {
            Object categoryObject = event.getTask();
            if (categoryObject == null && (categoryObject = event.getTarget()) == null) {
                categoryObject = event.getProject();
            }
            Logger log = Logger.getLogger(categoryObject.getClass().getName());
            switch (event.getPriority()) {
                case 0: {
                    log.error(event.getMessage());
                    break;
                }
                case 1: {
                    log.warn(event.getMessage());
                    break;
                }
                case 2: {
                    log.info(event.getMessage());
                    break;
                }
                case 3: {
                    log.debug(event.getMessage());
                    break;
                }
                case 4: {
                    log.debug(event.getMessage());
                    break;
                }
                default: {
                    log.error(event.getMessage());
                }
            }
        }
    }
}

