/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.ftp;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.util.TrustManagerUtils;

public final class FTPClientExample {
    public static final String USAGE = "Expected Parameters: [options] <hostname> <user> <password> [<remote file> [<local file>]]\n\nDefault behavior is to download a file and use ASCII transfer mode.\n\t-a - use local active mode (default is local passive)\n\t-A - anonymous login (omit user and password parameters)\n\t-b - use binary transfer mode\n\t-c cmd - issue arbitrary command (remote is used as a parameter if provided) \n\t-d - list directory details using MLSD (remote is used as the pathname if provided)\n\t-e - use EPSV with IPv4 (default false)\n\t-E - encoding to use for control channel\n\t-f - issue FEAT command (remote and local files are ignored)\n\t-h - list hidden files (applies to -l and -n only)\n\t-i - issue SIZE command for a file\n\t-k secs - use keep-alive timer (setControlKeepAliveTimeout)\n\t-l - list files using LIST (remote is used as the pathname if provided)\n\t     Files are listed twice: first in raw mode, then as the formatted parsed data.\n\t     N.B. if the wrong server-type is used, output may be lost. Use -U or -S as necessary.\n\t-L - use lenient future dates (server dates may be up to 1 day into future)\n\t-m - list file details using MDTM (remote is used as the pathname if provided)\n\t-n - list file names using NLST (remote is used as the pathname if provided)\n\t-p true|false|protocol[,true|false] - use FTPSClient with the specified protocol and/or isImplicit setting\n\t-s - store file on server (upload)\n\t-S - systemType set server system type (e.g. UNIX VMS WINDOWS)\n\t-t - list file details using MLST (remote is used as the pathname if provided)\n\t-U - save unparseable responses\n\t-w msec - wait time for keep-alive reply (setControlKeepAliveReplyTimeout)\n\t-T  all|valid|none - use one of the built-in TrustManager implementations (none = JVM default)\n\t-y format - set default date format string\n\t-Y format - set recent date format string\n\t-Z timezone - set the server time zone for parsing LIST responses\n\t-z timezone - set the time zone for displaying MDTM, LIST, MLSD, MLST responses\n\t-PrH server[:port] - HTTP Proxy host and optional port[80] \n\t-PrU user - HTTP Proxy server user\n\t-PrP password - HTTP Proxy server password\n\t-# - add hash display during transfers\n";

    private static CopyStreamListener createListener() {
        return new CopyStreamListener(){
            private long megsTotal;

            @Override
            public void bytesTransferred(CopyStreamEvent event) {
                this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
            }

            @Override
            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                long megs = totalBytesTransferred / 1000000L;
                long l = this.megsTotal;
                while (l < megs) {
                    System.err.print("#");
                    ++l;
                }
                this.megsTotal = megs;
            }
        };
    }

    public static void main(String[] args) throws UnknownHostException {
        boolean error;
        block173: {
            FTPClientConfig config;
            FTPClient ftp;
            String local;
            String remote;
            String displayTimeZoneId;
            String serverTimeZoneId;
            String doCommand;
            long keepAliveTimeoutSeconds;
            boolean lenient;
            boolean size;
            boolean mdtm;
            boolean mlsd;
            boolean mlst;
            boolean feat;
            boolean useEpsvWithIPv4;
            boolean localActive;
            boolean listNames;
            boolean listFiles;
            boolean binaryTransfer;
            boolean storeFile;
            block170: {
                storeFile = false;
                binaryTransfer = false;
                error = false;
                listFiles = false;
                listNames = false;
                boolean hidden = false;
                localActive = false;
                useEpsvWithIPv4 = false;
                feat = false;
                boolean printHash = false;
                mlst = false;
                mlsd = false;
                mdtm = false;
                boolean saveUnparseable = false;
                size = false;
                lenient = false;
                keepAliveTimeoutSeconds = -1L;
                int controlKeepAliveReplyTimeoutMillis = -1;
                int minParams = 5;
                String protocol = null;
                doCommand = null;
                String trustmgr = null;
                String proxyHost = null;
                int proxyPort = 80;
                String proxyUser = null;
                String proxyPassword = null;
                String user = null;
                String password = null;
                String encoding = null;
                serverTimeZoneId = null;
                displayTimeZoneId = null;
                String serverType = null;
                String defaultDateFormat = null;
                String recentDateFormat = null;
                int base = 0;
                base = 0;
                while (base < args.length) {
                    if (args[base].equals("-s")) {
                        storeFile = true;
                    } else if (args[base].equals("-a")) {
                        localActive = true;
                    } else if (args[base].equals("-A")) {
                        user = "anonymous";
                        password = String.valueOf(System.getProperty("user.name")) + "@" + InetAddress.getLocalHost().getHostName();
                    } else if (args[base].equals("-b")) {
                        binaryTransfer = true;
                    } else if (args[base].equals("-c")) {
                        doCommand = args[++base];
                        minParams = 3;
                    } else if (args[base].equals("-d")) {
                        mlsd = true;
                        minParams = 3;
                    } else if (args[base].equals("-e")) {
                        useEpsvWithIPv4 = true;
                    } else if (args[base].equals("-E")) {
                        encoding = args[++base];
                    } else if (args[base].equals("-f")) {
                        feat = true;
                        minParams = 3;
                    } else if (args[base].equals("-h")) {
                        hidden = true;
                    } else if (args[base].equals("-i")) {
                        size = true;
                        minParams = 3;
                    } else if (args[base].equals("-k")) {
                        keepAliveTimeoutSeconds = Long.parseLong(args[++base]);
                    } else if (args[base].equals("-l")) {
                        listFiles = true;
                        minParams = 3;
                    } else if (args[base].equals("-m")) {
                        mdtm = true;
                        minParams = 3;
                    } else if (args[base].equals("-L")) {
                        lenient = true;
                    } else if (args[base].equals("-n")) {
                        listNames = true;
                        minParams = 3;
                    } else if (args[base].equals("-p")) {
                        protocol = args[++base];
                    } else if (args[base].equals("-S")) {
                        serverType = args[++base];
                    } else if (args[base].equals("-t")) {
                        mlst = true;
                        minParams = 3;
                    } else if (args[base].equals("-U")) {
                        saveUnparseable = true;
                    } else if (args[base].equals("-w")) {
                        controlKeepAliveReplyTimeoutMillis = Integer.parseInt(args[++base]);
                    } else if (args[base].equals("-T")) {
                        trustmgr = args[++base];
                    } else if (args[base].equals("-y")) {
                        defaultDateFormat = args[++base];
                    } else if (args[base].equals("-Y")) {
                        recentDateFormat = args[++base];
                    } else if (args[base].equals("-Z")) {
                        serverTimeZoneId = args[++base];
                    } else if (args[base].equals("-z")) {
                        displayTimeZoneId = args[++base];
                    } else if (args[base].equals("-PrH")) {
                        String[] parts;
                        if ((parts = (proxyHost = args[++base]).split(":")).length == 2) {
                            proxyHost = parts[0];
                            proxyPort = Integer.parseInt(parts[1]);
                        }
                    } else if (args[base].equals("-PrU")) {
                        proxyUser = args[++base];
                    } else if (args[base].equals("-PrP")) {
                        proxyPassword = args[++base];
                    } else {
                        if (!args[base].equals("-#")) break;
                        printHash = true;
                    }
                    ++base;
                }
                int remain = args.length - base;
                if (user != null) {
                    minParams -= 2;
                }
                if (remain < minParams) {
                    if (args.length > 0) {
                        System.err.println("Actual Parameters: " + Arrays.toString(args));
                    }
                    System.err.println(USAGE);
                    System.exit(1);
                }
                String server = args[base++];
                int port = 0;
                String[] parts = server.split(":");
                if (parts.length == 2) {
                    server = parts[0];
                    port = Integer.parseInt(parts[1]);
                }
                if (user == null) {
                    user = args[base++];
                    password = args[base++];
                }
                remote = null;
                if (args.length - base > 0) {
                    remote = args[base++];
                }
                local = null;
                if (args.length - base > 0) {
                    local = args[base++];
                }
                if (protocol == null) {
                    if (proxyHost != null) {
                        System.out.println("Using HTTP proxy server: " + proxyHost);
                        ftp = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
                    } else {
                        ftp = new FTPClient();
                    }
                } else {
                    String[] prot;
                    FTPSClient ftps = protocol.equals("true") ? new FTPSClient(true) : (protocol.equals("false") ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
                    ftp = ftps;
                    if ("all".equals(trustmgr)) {
                        ftps.setTrustManager(TrustManagerUtils.getAcceptAllTrustManager());
                    } else if ("valid".equals(trustmgr)) {
                        ftps.setTrustManager(TrustManagerUtils.getValidateServerCertificateTrustManager());
                    } else if ("none".equals(trustmgr)) {
                        ftps.setTrustManager(null);
                    }
                }
                if (printHash) {
                    ftp.setCopyStreamListener(FTPClientExample.createListener());
                }
                if (keepAliveTimeoutSeconds >= 0L) {
                    ftp.setControlKeepAliveTimeout(Duration.ofSeconds(keepAliveTimeoutSeconds));
                }
                if (controlKeepAliveReplyTimeoutMillis >= 0) {
                    ftp.setControlKeepAliveReplyTimeout(Duration.ofMillis(controlKeepAliveReplyTimeoutMillis));
                }
                if (encoding != null) {
                    ftp.setControlEncoding(encoding);
                }
                ftp.setListHiddenFiles(hidden);
                ftp.addProtocolCommandListener(new PrintCommandListener(Util.newPrintWriter(System.out), true));
                config = serverType != null ? new FTPClientConfig(serverType) : new FTPClientConfig();
                config.setUnparseableEntries(saveUnparseable);
                if (defaultDateFormat != null) {
                    config.setDefaultDateFormatStr(defaultDateFormat);
                }
                if (recentDateFormat != null) {
                    config.setRecentDateFormatStr(recentDateFormat);
                }
                ftp.configure(config);
                try {
                    if (port > 0) {
                        ftp.connect(server, port);
                    } else {
                        ftp.connect(server);
                    }
                    System.out.println("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort()));
                    int reply = ftp.getReplyCode();
                    if (!FTPReply.isPositiveCompletion(reply)) {
                        ftp.disconnect();
                        System.err.println("FTP server refused connection.");
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    if (ftp.isConnected()) {
                        try {
                            ftp.disconnect();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    System.err.println("Could not connect to server.");
                    e.printStackTrace();
                    System.exit(1);
                }
                if (ftp.login(user, password)) break block170;
                ftp.logout();
                error = true;
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                break block173;
            }
            try {
                System.out.println("Remote system is " + ftp.getSystemType());
                if (binaryTransfer) {
                    ftp.setFileType(2);
                } else {
                    ftp.setFileType(0);
                }
                if (localActive) {
                    ftp.enterLocalActiveMode();
                } else {
                    ftp.enterLocalPassiveMode();
                }
                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                if (storeFile) {
                    Throwable e = null;
                    Object var46_61 = null;
                    try (FileInputStream input = new FileInputStream(local);){
                        ftp.storeFile(remote, input);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                    if (keepAliveTimeoutSeconds > 0L) {
                        FTPClientExample.showCslStats(ftp);
                    }
                } else if (listFiles || mlsd || mdtm || mlst || listNames || size) {
                    FTPFile f;
                    int input;
                    Object[] objectArray;
                    if (mlsd) {
                        objectArray = ftp.mlistDir(remote);
                        input = objectArray.length;
                        int n = 0;
                        while (n < input) {
                            Object f2 = objectArray[n];
                            System.out.println(((FTPFile)f2).getRawListing());
                            System.out.println(((FTPFile)f2).toFormattedString(displayTimeZoneId));
                            ++n;
                        }
                    }
                    if (mdtm) {
                        FTPFile f3 = ftp.mdtmFile(remote);
                        if (f3 != null) {
                            System.out.println(f3.getRawListing());
                            System.out.println(f3.toFormattedString(displayTimeZoneId));
                        } else {
                            System.out.println("File not found");
                        }
                    }
                    if (mlst && (f = ftp.mlistFile(remote)) != null) {
                        System.out.println(f.toFormattedString(displayTimeZoneId));
                    }
                    if (listNames) {
                        objectArray = ftp.listNames(remote);
                        input = objectArray.length;
                        int n = 0;
                        while (n < input) {
                            Object s = objectArray[n];
                            System.out.println((String)s);
                            ++n;
                        }
                    }
                    if (size) {
                        System.out.println("Size=" + ftp.getSize(remote));
                    }
                    if (listFiles) {
                        if (lenient || serverTimeZoneId != null) {
                            config.setLenientFutureDates(lenient);
                            if (serverTimeZoneId != null) {
                                config.setServerTimeZoneId(serverTimeZoneId);
                            }
                            ftp.configure(config);
                        }
                        objectArray = ftp.listFiles(remote);
                        input = objectArray.length;
                        int n = 0;
                        while (n < input) {
                            Object f4 = objectArray[n];
                            System.out.println(((FTPFile)f4).getRawListing());
                            System.out.println(((FTPFile)f4).toFormattedString(displayTimeZoneId));
                            ++n;
                        }
                    }
                } else if (feat) {
                    if (remote != null) {
                        if (ftp.hasFeature(remote)) {
                            System.out.println("Has feature: " + remote);
                        } else if (FTPReply.isPositiveCompletion(ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " was not detected");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                        String[] features = ftp.featureValues(remote);
                        if (features != null) {
                            String[] stringArray = features;
                            int n = features.length;
                            int input = 0;
                            while (input < n) {
                                String f = stringArray[input];
                                System.out.println("FEAT " + remote + "=" + f + ".");
                                ++input;
                            }
                        } else if (FTPReply.isPositiveCompletion(ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " is not present");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                    } else if (!ftp.features()) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else if (doCommand != null) {
                    if (!ftp.doCommand(doCommand, remote)) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else {
                    Throwable features = null;
                    Object var46_67 = null;
                    try (FileOutputStream output = new FileOutputStream(local);){
                        ftp.retrieveFile(remote, output);
                    }
                    catch (Throwable throwable) {
                        if (features == null) {
                            features = throwable;
                        } else if (features != throwable) {
                            features.addSuppressed(throwable);
                        }
                        throw features;
                    }
                    if (keepAliveTimeoutSeconds > 0L) {
                        FTPClientExample.showCslStats(ftp);
                    }
                }
                ftp.noop();
                ftp.logout();
            }
            catch (FTPConnectionClosedException e) {
                error = true;
                System.err.println("Server closed connection.");
                e.printStackTrace();
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                break block173;
            }
            catch (IOException e) {
                try {
                    error = true;
                    e.printStackTrace();
                    break block173;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ftp.isConnected()) {
                        try {
                            ftp.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.exit(error ? 1 : 0);
    }

    private static void showCslStats(FTPClient ftp) {
        int[] stats = ftp.getCslDebug();
        System.out.println("CslDebug=" + Arrays.toString(stats));
    }
}

