/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.jquery.datatables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.script.SrpClosureCompiler;
import jp.co.extreme.web.javascript.WbfNewJsUtil;
import jp.co.extreme.web.jquery.datatables.DataTablesColumn;
import jp.co.extreme.web.jquery.datatables.DataTablesWords;

public class DataTablesUtil {
    Map<String, String> scriptMap = new HashMap<String, String>();
    public static final String languageUrl = "./datatables-2.3.3/plug-ins/2.3.3/i18n/ja.json";
    public static final String displayLength = "100";
    public static final String lengthMenu = "[25, 50, 100, 500, 1000, 10000, { label: 'All', value: -1 }]";

    public static DataTablesUtil getInstance() {
        return SingletonHolder.instance;
    }

    public List<String> getHeadElementList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<link rel=\"stylesheet\" href=\"./datatables-2.3.3/datatables.min.css\">");
        list.add("<link rel=\"stylesheet\" href=\"https://cdn.datatables.net/scroller/2.4.3/css/scroller.dataTables.min.css\">");
        return list;
    }

    public List<String> getBodyScriptSrcList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("<script src=\"./datatables-2.3.3/datatables.min.js\"></script>");
        list.add("<script src=\"https://cdn.datatables.net/scroller/2.4.3/js/dataTables.scroller.min.js\"></script>");
        return list;
    }

    public String getScript_standard(String selector, String columnDefs) throws Exception {
        String fileName = "data_tables_standard.js";
        String script = this.scriptMap.get(fileName);
        if (script == null) {
            script = WbfNewJsUtil.getScript(this.getClass().getResourceAsStream(fileName));
            this.scriptMap.put(fileName, script);
        }
        String scriptWk = script;
        scriptWk = scriptWk.replace("${selector}", selector);
        if (!BcStringUtil.isEmpty(columnDefs)) {
            columnDefs = "columnDefs:" + columnDefs;
        }
        scriptWk = BcStringUtil.replace2(scriptWk, "${columnDefs}", columnDefs);
        scriptWk = BcStringUtil.replace2(scriptWk, "${languageUrl}", languageUrl);
        scriptWk = BcStringUtil.replace2(scriptWk, "${displayLength}", displayLength);
        scriptWk = BcStringUtil.replace2(scriptWk, "${lengthMenu}", lengthMenu);
        scriptWk = SrpClosureCompiler.getInstance().compile(scriptWk);
        return WbfNewJsUtil.addTag(scriptWk);
    }

    public String getScript_standard(String selector, Collection<DataTablesColumn> columnCollection) throws Exception {
        String jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(columnCollection);
        return this.getScript_standard(selector, jsonStr);
    }

    public String getScript_serverSide(String selector, String ajaxUrl, String columnDefs, boolean serverSide) throws Exception {
        String fileName = "data_tables_server_side.js";
        String script = this.scriptMap.get(fileName);
        if (script == null) {
            script = WbfNewJsUtil.getScript(DataTablesUtil.class.getResourceAsStream(fileName));
            this.scriptMap.put(fileName, script);
        }
        String scriptWk = script;
        scriptWk = scriptWk.replace("${selector}", selector);
        scriptWk = scriptWk.replace("${ajaxUrl}", ajaxUrl);
        if (!BcStringUtil.isEmpty(columnDefs)) {
            columnDefs = "columnDefs:" + columnDefs;
        }
        scriptWk = BcStringUtil.replace2(scriptWk, "${columnDefs}", columnDefs);
        scriptWk = BcStringUtil.replace2(scriptWk, "${displayLength}", displayLength);
        scriptWk = BcStringUtil.replace2(scriptWk, "${lengthMenu}", lengthMenu);
        scriptWk = BcStringUtil.replace2(scriptWk, "${serverSide}", Boolean.toString(serverSide));
        scriptWk = BcStringUtil.replace2(scriptWk, "${info}", DataTablesWords.getInstance().Showing_START_to_END_of_TOTAL_results);
        scriptWk = SrpClosureCompiler.getInstance().compile(scriptWk);
        return WbfNewJsUtil.addTag(scriptWk);
    }

    public String getScript_serverSide(String selector, String ajaxUr, Collection<DataTablesColumn> columnCollection, boolean serverSide) throws Exception {
        String jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(columnCollection);
        return this.getScript_serverSide(selector, ajaxUr, jsonStr, serverSide);
    }

    public String toElementId(int num) throws Exception {
        return "dataTables_" + num;
    }

    public String elementIdDefault() throws Exception {
        return this.toElementId(1);
    }

    public static String toDtAlignment(int horizonalAlignmentId) throws Exception {
        String str = null;
        str = horizonalAlignmentId == MmdUtil.Alignment.CENTER.id ? "dt-body-center" : (horizonalAlignmentId == MmdUtil.Alignment.RIGHT.id ? "dt-body-right" : "dt-body-left");
        return str;
    }

    private static final class SingletonHolder {
        private static final DataTablesUtil instance = new DataTablesUtil();

        private SingletonHolder() {
        }
    }
}

