/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.co.extreme.awt.AwtColorUtil;
import jp.co.extreme.awt.AwtFontUtil;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.math.BcMath;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdStringConverter;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCompareUtil;
import jp.co.extreme.base.util.BcConditionElement;
import jp.co.extreme.base.util.BcGeneralComparator;
import jp.co.extreme.html.util.EtcHtmlUtil;
import jp.co.extreme.swing.BcConditionTableView;
import jp.co.extreme.swing.SwgNumberField;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTextField;
import jp.co.extreme.swing.lookAndFeel.SwgLafManager;

public class SwgTableViewUtil {
    public static int COLUMN_MARGIN = 1;
    public static int ROW_HEIGHT;
    public static int ROW_MARGIN;
    static double widthMargin;
    static double minWidth;
    public static Dimension INTERCELL_SPACING;

    static {
        ROW_MARGIN = 1;
        widthMargin = 10.0;
        INTERCELL_SPACING = new Dimension(COLUMN_MARGIN, ROW_MARGIN);
        try {
            int textHeight = AwtFontUtil.getTextSize((Font)SwgLafManager.getInstance().font).height;
            ROW_HEIGHT = textHeight + 6;
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    private SwgTableViewUtil() throws Exception {
    }

    public static void setEditable(BcTableColumnModel tableColumnModel, boolean isEditable) {
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            tableColumn.isEditable = isEditable;
            ++i;
        }
    }

    public static void setColumnWidth(BcTableColumn tableColumn, Font font) throws Exception {
        tableColumn.defaultWidth = SwgTableViewUtil.calcColumnWidth(tableColumn, font);
        tableColumn.setPreferredWidth((int)tableColumn.defaultWidth);
        tableColumn.setWidth((int)tableColumn.defaultWidth);
        if (tableColumn.defaultWidth <= 0.0) {
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
    }

    public static double calcColumnWidth(TableColumn tableColumn, Font font) throws Exception {
        MmdField mmdField = null;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass())) {
            BcTableColumn tableColumn2 = (BcTableColumn)tableColumn;
            mmdField = tableColumn2.getMmdField();
        }
        return SwgTableViewUtil.calcColumnWidth(mmdField, tableColumn.getHeaderValue(), font);
    }

    public static double calcColumnWidth(MmdField mmdField, Object headerValue, Font font) throws Exception {
        double width1 = -1.0;
        if (mmdField != null && mmdField.columnCount > -1) {
            Dimension dim = AwtFontUtil.getTextSize(font, mmdField.columnCount);
            width1 = (double)dim.width + widthMargin;
        }
        double width2 = -1.0;
        if (headerValue != null && String.class.isAssignableFrom(headerValue.getClass())) {
            String str = (String)headerValue;
            List<String> strList = EtcHtmlUtil.toStringList(str);
            int i = 0;
            while (i < strList.size()) {
                String str2 = strList.get(i);
                Dimension dim = AwtFontUtil.getTextSize(font, str2);
                width2 = Math.max(width2, (double)(dim.width + 4));
                ++i;
            }
        }
        double widthMax = BcMath.max(width1, width2, SwgTableViewUtil.getMinWidth(font));
        return widthMax;
    }

    public static double getMinWidth(Font font) {
        if (minWidth <= 0.0) {
            Dimension dim = AwtFontUtil.getTextSize(font, 1);
            minWidth = (double)dim.width + widthMargin;
        }
        return minWidth;
    }

    public static int addRowSelection(JTable tableView, int[] indexs) {
        int cnt = 0;
        int[] nArray = indexs;
        int n = indexs.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index >= 0 && index <= tableView.getRowCount() - 1) {
                tableView.addRowSelectionInterval(index, index);
                ++cnt;
            }
            ++n2;
        }
        return cnt;
    }

    public static int addRowSelection(JTable tableView, int index1, int index2) {
        int cnt = 0;
        if (index1 >= 0 && index2 <= tableView.getRowCount() - 1) {
            tableView.addRowSelectionInterval(index1, index2);
            cnt += Math.abs(index1 - index2) + 1;
        }
        return cnt;
    }

    public static int addRowSelection(JTable tableView, int index1) {
        return SwgTableViewUtil.addRowSelection(tableView, index1, index1);
    }

    public static void setValueAllRow(JTable tableView, Object value, int ... columnIndexes) {
        int i = 0;
        while (i < tableView.getRowCount()) {
            int j = 0;
            while (j < columnIndexes.length) {
                tableView.setValueAt(value, i, columnIndexes[j]);
                ++j;
            }
            ++i;
        }
        tableView.repaint();
    }

    public static void setValueAllRowAtModel(SwgTableView tableView, Object value, int ... columnIds) {
        BcTableModel tableModel = (BcTableModel)tableView.getModel();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            int j = 0;
            while (j < columnIds.length) {
                tableModel.setValueAtModel(value, i, columnIds[j]);
                ++j;
            }
            ++i;
        }
        tableView.repaint();
    }

    public static List<List> getRowList(SwgTableView tableView, int[] rowIndexes, int[] columnIds) {
        TableModel tableModel = tableView.getModel();
        List<List> rowList = BcTableUtil.getValues(tableModel, rowIndexes, columnIds);
        return rowList;
    }

    public static List<List> getRowList(SwgTableView tableView, int[] rowIds, String ... tableColumnNames) throws Exception {
        BcTableColumnModel tableColumnModel = (BcTableColumnModel)tableView.getColumnModel();
        int[] columnIds = BcTableUtil.getColumnIds(tableColumnModel, true, tableColumnNames);
        return SwgTableViewUtil.getRowList(tableView, rowIds, columnIds);
    }

    public static List<List> getRowList(SwgTableView tableView, int rowId, String ... tableColumnNames) throws Exception {
        int[] rowIds = new int[]{rowId};
        return SwgTableViewUtil.getRowList(tableView, rowIds, tableColumnNames);
    }

    public static List<List> getSelectedRowList(SwgTableView tableView, int ... columnIds) throws Exception {
        int[] rowIndexes = tableView.getSelectedRows();
        return SwgTableViewUtil.getRowList(tableView, rowIndexes, columnIds);
    }

    public static List<List> getSelectedRowList(SwgTableView tableView, String ... tableColumnNames) throws Exception {
        BcTableColumnModel tableColumnModel = (BcTableColumnModel)tableView.getColumnModel();
        int[] columnIds = BcTableUtil.getColumnIds(tableColumnModel, true, tableColumnNames);
        return SwgTableViewUtil.getSelectedRowList(tableView, columnIds);
    }

    public static List getSelectedRowTop(SwgTableView tableView, String ... tableColumnNames) throws Exception {
        List<List> rowList = SwgTableViewUtil.getSelectedRowList(tableView, tableColumnNames);
        List row = null;
        if (rowList.size() > 0) {
            row = rowList.get(0);
        }
        return row;
    }

    public static List getSelectedValueList(SwgTableView tableView, String tableColumnName) throws Exception {
        List<List> rowList = SwgTableViewUtil.getSelectedRowList(tableView, tableColumnName);
        ArrayList valueList = new ArrayList();
        int i = 0;
        while (i < rowList.size()) {
            List row = rowList.get(i);
            valueList.add(row.get(0));
            ++i;
        }
        return valueList;
    }

    public static int[] selectSameValueRow(JTable tableView, int columnId, Collection<?> valueCollection, Comparator comparator) throws Exception {
        TableModel tableModel = tableView.getModel();
        List<Integer> rowIndexList = BcTableUtil.getSameValueRowIndex(tableModel, columnId, valueCollection, comparator);
        int[] rowIndexes = BcNumberUtil.toIntArray(rowIndexList);
        SwgTableViewUtil.addRowSelection(tableView, rowIndexes);
        return rowIndexes;
    }

    public static int[] selectSameValueRow(JTable tableView, int columnId, Collection<?> valueCollection) throws Exception {
        return SwgTableViewUtil.selectSameValueRow(tableView, columnId, valueCollection, BcGeneralComparator.getInstance());
    }

    public static int getSelectedCount(ListSelectionModel listSelectionModel) {
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return 0;
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int cnt = 0;
        int i = iMin;
        while (i <= iMax) {
            if (listSelectionModel.isSelectedIndex(i)) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public static Component getCellComponent_Number(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, MmdStringConverter sringConverter, SwgNumberField numberField, JLabel label) throws Exception {
        if (!Number.class.isAssignableFrom(valueClass)) {
            return null;
        }
        Number number = (Number)cellValue;
        if (isEditor) {
            if (BcNumberUtil.isIntegeraClass(mmdField.dataClass)) {
                numberField.setDecimalPosition(0);
            } else if (BcNumberUtil.isFloatingaPointClass(mmdField.dataClass) || mmdField.dataClass.equals(BigDecimal.class)) {
                numberField.setDecimalPosition(mmdField.decimalDigit);
                numberField.setNullable(BcBooleanUtil.toBoolean(mmdField.nullable));
            }
            numberField.setValue(number);
            numberField.selectAll();
            return numberField;
        }
        String text = sringConverter.toString(mmdField, cellValue);
        label.setText(text);
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static Component getCellComponent_Calendar(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, SwgTextField textField, JLabel label) throws Exception {
        String str;
        Calendar calendar = null;
        if (Calendar.class.isAssignableFrom(valueClass) || Date.class.isAssignableFrom(valueClass)) {
            if (Calendar.class.isAssignableFrom(valueClass)) {
                calendar = (Calendar)cellValue;
            } else if (Date.class.isAssignableFrom(valueClass)) {
                Date date = (Date)cellValue;
                calendar = BcTimeUtil.toCalendar(date);
            }
        }
        if (calendar == null) {
            return null;
        }
        if (isEditor) {
            str = BcTimeUtil.toString(calendar, mmdField.fieldDisplay.formatStr);
            textField.setText(str);
            textField.selectAll();
            return textField;
        }
        str = BcTimeUtil.toString(calendar, mmdField.fieldDisplay.formatStr);
        label.setText(str);
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static Component getCellComponent_Boolean(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, boolean isEditable, JCheckBox checkBox, JLabel label) throws Exception {
        if (!Boolean.class.isAssignableFrom(valueClass)) {
            return null;
        }
        Boolean bool = (Boolean)cellValue;
        if (isEditor || isEditable) {
            checkBox.setSelected(bool);
            return checkBox;
        }
        label.setText(BcBooleanUtil.toYN(bool));
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static Component getCellComponent_Text(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, JTextField textField, JLabel label, JComponent jComponent) throws Exception {
        JComponent component = null;
        if (isEditor) {
            textField.setText(cellValue.toString());
            textField.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
            textField.selectAll();
            component = textField;
        } else {
            JLabel label2 = label;
            if (jComponent instanceof JLabel) {
                label2 = (JLabel)jComponent;
                label2.setText(cellValue.toString());
                label2.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
                component = label2;
            } else if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.setText(cellValue.toString());
                textField.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
                component = jTextField;
            } else if (jComponent instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)jComponent;
                jTextArea.setText(cellValue.toString());
                jTextArea.setLineWrap(true);
                jTextArea.setBackground(Color.CYAN);
                jTextArea.setForeground(Color.RED);
                component = jTextArea;
            }
        }
        return component;
    }

    public static List getSelectedValueList(JTable tableView, int columnIndex, boolean isUnique, Comparator comparator) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        int tmpId = -1;
        int[] rowIds = tableView.getSelectedRows();
        if (rowIds.length > 0) {
            int i = 0;
            while (i < rowIds.length) {
                Object obj1 = tableView.getValueAt(rowIds[i], columnIndex);
                if (isUnique) {
                    tmpId = -1;
                    int j = 0;
                    while (j < valueList.size()) {
                        Object obj2 = valueList.get(j);
                        if (comparator.compare(obj1, obj2) == BcCompareUtil.Comparison.equals.value) {
                            tmpId = j;
                            break;
                        }
                        ++j;
                    }
                    if (tmpId < 0) {
                        valueList.add(obj1);
                    }
                } else {
                    valueList.add(obj1);
                }
                ++i;
            }
        }
        return valueList;
    }

    public static int calcHeaderHeight(double textHeight, double rowCount) {
        int topMargin = 6;
        int botomMargin = 6;
        int rowDiff = 6;
        double headerHeight = (double)(topMargin + botomMargin) + textHeight * rowCount + (double)rowDiff * (rowCount - 1.0);
        return (int)Math.round(headerHeight);
    }

    public static Rectangle scrollRectToVisible(JTable jTable, int rowId, int columnId) {
        Rectangle rectangle = jTable.getCellRect(rowId, columnId, true);
        jTable.scrollRectToVisible(rectangle);
        return rectangle;
    }

    public static List getSelectedValueList(JTable tableView, int columnIndex, boolean isUnique) {
        return SwgTableViewUtil.getSelectedValueList(tableView, columnIndex, isUnique, BcGeneralComparator.getInstance());
    }

    public static Color toGridColor(Color baseColor) {
        return AwtColorUtil.toColor(baseColor, -40);
    }

    public static Color toRowOddBg(Color baseColor) {
        return AwtColorUtil.toColor(baseColor, -15);
    }

    public static Color toRowEvenBg(Color baseColor) {
        return AwtColorUtil.toColor(baseColor, -25);
    }

    public static Color toRowSelectedBg(Color baseColor) {
        return AwtColorUtil.toSelectionColor(baseColor, -20);
    }

    public static Color toRowSelectedFg(Color baseColor) {
        return AwtColorUtil.toComplementaryColor(baseColor, 0);
    }

    public static void setHeaderHeight(JTableHeader tableHeader, int height) throws Exception {
        Dimension dim = tableHeader.getPreferredSize();
        dim.height = height;
        tableHeader.setPreferredSize(dim);
    }

    public static int setHeaderRowCount(JTableHeader tableHeader, double rowCount) throws Exception {
        int textHeight = AwtFontUtil.getTextSize((Font)SwgLafManager.getInstance().font).height;
        int height = SwgTableViewUtil.calcHeaderHeight(textHeight, rowCount);
        SwgTableViewUtil.setHeaderHeight(tableHeader, height);
        return height;
    }

    public static SwgTableView createConditionTableView(BcTableContext tableContext) throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        SwgTableViewUtil.createConditionTableColumnModel(tableColumnModel);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        SwgTableViewUtil.createConditionTable(tableContext.getConditionList(), tableModel);
        BcConditionTableView tableView = new BcConditionTableView(tableModel, tableColumnModel);
        return tableView;
    }

    public static void createConditionTable(List<? extends BcConditionElement> conditionList, BcTableModel tableModel) {
        int i = 0;
        while (i < conditionList.size()) {
            BcConditionElement conditionElement = conditionList.get(i);
            ArrayList<String> row = new ArrayList<String>();
            row.add(conditionElement.name);
            row.add(":");
            row.add(conditionElement.value);
            tableModel.addRow(row);
            ++i;
        }
    }

    public static void createConditionTableColumnModel(BcTableColumnModel tableColumnModel) {
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.fieldDisplay.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.setMinWidth(140);
        tableColumn.setMaxWidth(140);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.fieldDisplay.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.setMinWidth(10);
        tableColumn.setMaxWidth(10);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.fieldDisplay.horizonalAlignment = 2;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.setMinWidth(200);
        tableColumn.setMaxWidth(200);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
    }
}

