/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import jp.co.extreme.swing.SwgAlphabetKeyPanel;
import jp.co.extreme.swing.SwgPanel;
import jp.co.extreme.swing.SwgTenKeyPanel;
import jp.co.extreme.swing.SwgTenkeyListener;
import jp.co.extreme.swing.SwgUtil;

public class SwgKeyboardPanel
extends SwgPanel {
    private static final long serialVersionUID = 839355720442544165L;
    public static final int TYPE_number = 1;
    public static final int TYPE_alphabet = 2;
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected SwgTenKeyPanel tenKeyPanel = new SwgTenKeyPanel();
    protected SwgAlphabetKeyPanel alphabetKeyPanel = new SwgAlphabetKeyPanel();

    public SwgKeyboardPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public void setKeyboardType(int type) {
        this.tabbedPane.removeAll();
        if ((type & 1) != 0) {
            this.tabbedPane.add((Component)this.tenKeyPanel, "\u30c6\u30f3\u30ad\u30fc");
        }
        if ((type & 2) != 0) {
            this.tabbedPane.add((Component)this.alphabetKeyPanel, "\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8");
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            components[i].setFont(font);
            ++i;
        }
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        super.componentResized(ev);
        this.resized();
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        super.componentResized(ev);
        this.resized();
    }

    public void resized() {
        this.tenKeyPanel.resized();
        this.alphabetKeyPanel.resized();
    }

    public void addTenkeyListener(SwgTenkeyListener listener) {
        this.tenKeyPanel.addTenkeyListener(listener);
        this.alphabetKeyPanel.addTenkeyListener(listener);
    }

    public static void main(String[] args) {
        try {
            SwgKeyboardPanel keyboardPanel = new SwgKeyboardPanel();
            JFrame frame = new JFrame();
            frame.getContentPane().add((Component)keyboardPanel, "Center");
            SwgUtil.setCenter(frame, 780.0, 540.0);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

