/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.session;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcRandamUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.session.BcSessionImpl;
import jp.co.extreme.session.BcSessionValidator;

public class BcSessionManager<T extends BcSessionImpl>
extends BcLoggableObject
implements AutoCloseable {
    private Map<String, T> map = new ConcurrentHashMap<String, T>();
    public BcSessionValidator sessionValidator = new BcSessionValidator();
    private Random random = new Random();
    private int sessrionIdLengt = 32;
    public int maxInactiveInterval = -1;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BcSessionManager() {
        this.sessionValidator.setMap(this.map);
        this.setName(this.getClass().getSimpleName());
    }

    public void addcSession(T session) throws Exception {
        String sessionId;
        BcSessionImpl preValue;
        if (!BcStringUtil.isEmpty(((BcSessionImpl)session).getId()) || ((BcSessionImpl)session).getInvalidatedTime() != null) {
            throw new IllegalStateException("sessionId=" + ((BcSessionImpl)session).getId() + " invalidatedTime=" + ((BcSessionImpl)session).getInvalidatedTime());
        }
        while ((preValue = (BcSessionImpl)this.map.putIfAbsent(sessionId = BcRandamUtil.createCode(this.random, 5, this.sessrionIdLengt), session)) != null) {
        }
        ((BcSessionImpl)session).setId(sessionId);
        ((BcSessionImpl)session).setCreationTime(System.currentTimeMillis());
        ((BcSessionImpl)session).setLastAccessedTime(((BcSessionImpl)session).getCreationTime());
        ((BcSessionImpl)session).setMaxInactiveInterval(this.maxInactiveInterval);
        BcSessionImpl bcSessionImpl = (BcSessionImpl)this.map.put(sessionId, session);
    }

    public T getSession(String sessionId, boolean updateAccessedTime) {
        BcSessionImpl session = (BcSessionImpl)this.map.get(sessionId);
        if (session != null && updateAccessedTime) {
            session.setLastAccessedTime(System.currentTimeMillis());
        }
        return (T)session;
    }

    public T getSession(String sessionId) {
        T httpSession = this.getSession(sessionId, true);
        return httpSession;
    }

    public T removeSession(String sessionId) throws Exception {
        BcSessionImpl session = (BcSessionImpl)this.map.remove(sessionId);
        if (session == null) {
            this.getLogger().warning(BcWords.getInstance().$_does_not_exists("SessionId=" + sessionId));
            return null;
        }
        session.invalidate();
        return (T)session;
    }

    @Override
    public void close() throws Exception {
        this.getLogger().info(String.valueOf(this.getName()) + " is closesing...");
        try {
            this.sessionValidator.close();
            this.sessionValidator = null;
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        try {
            this.map.clear();
            this.map = null;
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }
}

