/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.rmo;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.sql.ScfMmdServerUtil;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf8.dao.KscfQueryColumnDAO;
import jp.co.extreme.scf8.model.KscfQueryColumn;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;

public class KscfQueryColumnRMO
extends RmiAbstractRMO {
    public void putQueryColumn(RmiRmoArgument rmoArg) throws Exception {
        List queryColumnList = (List)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int i = 0;
        while (i < queryColumnList.size()) {
            KscfQueryColumn queryColumn = (KscfQueryColumn)queryColumnList.get(i);
            KscfQueryColumnDAO.getInstance().putEntity(dtsSession, queryColumn);
            ++i;
        }
    }

    public void queryColumnList(RmiRmoArgument rmoArg) throws Exception {
        int queryId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.createDtsSession();
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder();
        ArrayList<String> columnNameList = new ArrayList<String>();
        columnNameList.add("frwk_query_column.column_name");
        columnNameList.add("frwk_query_column.view_index");
        query.append("SELECT " + SqlUtil.enumerateByCommma(columnNameList));
        query.append(" FROM frwk_query_column");
        query.append(" WHERE frwk_query_column.query_id = " + queryId);
        query.append(" ORDER BY frwk_query_column.column_name");
        BcLogUtil.debug("query=" + query);
        SqlStatement stmt = sqlContext.createStatementForScroll(dtsSession.getConnection());
        try {
            SqlResultSet rs = stmt.executeQuery(query.toString());
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData(), columnNameList);
            BcTableContext tableContext = new BcTableContext();
            ScfSqlUtil.setRespons(dtsSession, rs, tableColumnList, tableContext, rmoArg);
        }
        catch (Exception ex) {
            stmt.close();
            throw ex;
        }
    }
}

