/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.dao;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf8.model.KscfGeneralTreeNode;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class KscfAbstractTreeNodeDAO
extends OrmAbstractDAO {
    public String treePathTableName;
    public String sep = "/";

    public KscfAbstractTreeNodeDAO() {
        super(new Object[0]);
    }

    protected List<String> getUpdateColumnList() throws Exception {
        if (this.updateColumnList != null) {
            return this.updateColumnList;
        }
        this.updateColumnList = new ArrayList();
        this.updateColumnList.add("code");
        this.updateColumnList.add("name");
        this.updateColumnList.add("name_short");
        this.updateColumnList.add("code_path");
        this.updateColumnList.add("name_path");
        this.updateColumnList.add("import_id");
        this.updateColumnList.add("import_data_no");
        this.updateColumnList.add("note_");
        return this.updateColumnList;
    }

    protected List<Object> toValueList(Object entity) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        KscfGeneralTreeNode treeNode = (KscfGeneralTreeNode)entity;
        valueList.add(treeNode.code);
        valueList.add(treeNode.name);
        valueList.add(treeNode.nameShort);
        valueList.add(treeNode.codePath);
        valueList.add(treeNode.namePath);
        valueList.add(treeNode.importId);
        valueList.add(treeNode.importDataNo);
        valueList.add(treeNode.note);
        return valueList;
    }

    protected String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? "," : "," + tableAlias + ".";
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPersistenceProxy().createCommonSelectPhrase(KscfGeneralTreeNode.class, tableAlias));
        int i = 0;
        while (i < this.getUpdateColumnList().size()) {
            sb.append(String.valueOf(asTable2) + this.getUpdateColumnList().get(i));
            ++i;
        }
        return sb.toString();
    }

    public void putNode(DtsSession dtsSession, KscfGeneralTreeNode treeNode) throws Exception {
        List<String> columnList = this.getUpdateColumnList();
        List<Object> valueList = this.toValueList(treeNode);
        this.getPersistenceProxy().putEntity(dtsSession, this.tableName, columnList, valueList, treeNode);
        this.checkTreeStruct(dtsSession, treeNode);
        this.updatePath(dtsSession, treeNode.getDataId());
    }

    public int deleteNode(DtsSession dtsSession, int treeNodeId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int deletedCount = 0;
        KscfGeneralTreeNode treeNode = this.getNode(dtsSession, treeNodeId);
        if (treeNode == null) {
            return deletedCount;
        }
        String query = "DELETE  FROM " + this.tableName + " WHERE " + "id IN (" + " SELECT end_id" + " FROM " + this.treePathTableName + " WHERE start_id=" + treeNodeId + " )" + " OR " + "id=" + treeNodeId;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            deletedCount = stmt.executeUpdate(query);
        }
        return deletedCount;
    }

    public void checkTreeStruct(DtsSession dtsSession, KscfGeneralTreeNode treeNode) throws Exception {
        if (treeNode.getDataId() == treeNode.getParentId()) {
            throw new Exception("\u30ce\u30fc\u30c9ID\u3068\u89aa\u30ce\u30fc\u30c9ID\u304c\u540c\u4e00\u5024\u3067\u3059\u3002");
        }
        KscfGeneralTreeNode treeNode1 = (KscfGeneralTreeNode)treeNode.clone();
        while (treeNode1.getParentId() > 0) {
            KscfGeneralTreeNode parentTreeNode = this.getNode(dtsSession, treeNode1.getParentId());
            if (parentTreeNode != null) {
                if (treeNode1.getParentId() == parentTreeNode.getDataId()) {
                    treeNode1 = parentTreeNode;
                    continue;
                }
                throw new Exception("\u30c4\u30ea\u30fc\u69cb\u9020\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002treeNode1.getParentDataId()=" + treeNode1.getParentId() + " parentTreeNode.getDataId()=" + parentTreeNode.getDataId());
            }
            throw new Exception("\u89aa\u30ce\u30fc\u30c9\uff08id:" + treeNode1.getParentId() + "\uff09\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public KscfGeneralTreeNode getNode(DtsSession dtsSession, int nodeId, Class dataClass) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.viewName + " WHERE " + "id=" + nodeId;
        KscfGeneralTreeNode treeNode = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                treeNode = (KscfGeneralTreeNode)BcReflectUtil.createInstance(dataClass);
                this.getNode(dtsSession, rs, columnIndex, treeNode);
            }
            rs.close();
        }
        return treeNode;
    }

    public KscfGeneralTreeNode getNode(DtsSession dtsSession, int nodeId) throws Exception {
        return this.getNode(dtsSession, nodeId, KscfGeneralTreeNode.class);
    }

    protected void getNode(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, KscfGeneralTreeNode treeNode) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, treeNode);
        treeNode.code = rs.getString(columnIndex);
        treeNode.name = rs.getString(columnIndex);
        treeNode.nameShort = rs.getString(columnIndex);
        treeNode.codePath = rs.getString(columnIndex);
        treeNode.namePath = rs.getString(columnIndex);
        treeNode.importId = rs.getInt(columnIndex);
        treeNode.importDataNo = rs.getInt(columnIndex);
        treeNode.note = rs.getString(columnIndex);
        treeNode.childCount = this.getChildCount(dtsSession, treeNode.getDataId());
    }

    public KscfGeneralTreeNode getTreeNodeByCode(DtsSession dtsSession, int parentNodeId, String code, Class dataClass) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int nodeId = -1;
        StringBuilder query = new StringBuilder(256);
        query.append("SELECT " + this.getSelectColumns01(null) + " FROM " + this.viewName + " WHERE " + "code=" + sqlContext.toSet(code));
        if (parentNodeId >= 0) {
            query.append(" AND parent_id=" + parentNodeId);
        }
        KscfGeneralTreeNode treeNode = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query.toString());
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                treeNode = (KscfGeneralTreeNode)BcReflectUtil.createInstance(dataClass);
                this.getNode(dtsSession, rs, columnIndex, treeNode);
            }
            rs.close();
        }
        return treeNode;
    }

    public List<KscfGeneralTreeNode> getTreePath(DtsSession dtsSession, int nodeId) throws Exception {
        ArrayList<KscfGeneralTreeNode> tmpList = new ArrayList<KscfGeneralTreeNode>();
        int tmpDataId = nodeId;
        while (tmpDataId > 0) {
            KscfGeneralTreeNode treeNode = this.getNode(dtsSession, tmpDataId);
            if (treeNode == null) {
                throw new Exception("not found tmpDataId=" + nodeId);
            }
            tmpList.add(treeNode);
            tmpDataId = treeNode.getParentId();
        }
        ArrayList<KscfGeneralTreeNode> pathList = new ArrayList<KscfGeneralTreeNode>();
        BcCollectionUtil.reverse(tmpList, pathList);
        return pathList;
    }

    public List<KscfGeneralTreeNode> getChildNodeList(DtsSession dtsSession, int nodeId, Class dataClass) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder(256);
        query.append("SELECT " + this.getSelectColumns01(null) + " FROM " + this.viewName + " WHERE " + "parent_id=" + nodeId + " ORDER BY " + "code");
        ArrayList<KscfGeneralTreeNode> treeNodeList = new ArrayList<KscfGeneralTreeNode>();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query.toString());
            BcInteger columnIndex = new BcInteger();
            while (rs.next()) {
                columnIndex.value = 0;
                KscfGeneralTreeNode treeNode = (KscfGeneralTreeNode)BcReflectUtil.createInstance(dataClass);
                this.getNode(dtsSession, rs, columnIndex, treeNode);
                treeNodeList.add(treeNode);
            }
            rs.close();
        }
        return treeNodeList;
    }

    public int getChildCount(DtsSession dtsSession, int nodeId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int resValue = 0;
        String query = "SELECT COUNT(*) FROM " + this.viewName + " WHERE " + "parent_id=" + nodeId;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resValue = rs.getInt(1);
            }
            rs.close();
        }
        return resValue;
    }

    public String createCodePath(List<KscfGeneralTreeNode> nodeList) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < nodeList.size()) {
            if (i > 0) {
                sb.append(this.sep);
            }
            KscfGeneralTreeNode treeNode = nodeList.get(i);
            sb.append(treeNode.code);
            ++i;
        }
        return sb.toString();
    }

    public String getCodePath(DtsSession dtsSession, int nodeId) throws Exception {
        List<KscfGeneralTreeNode> nodeList = this.getTreePath(dtsSession, nodeId);
        return this.createCodePath(nodeList);
    }

    public String createNamePath(List<KscfGeneralTreeNode> nodeList) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < nodeList.size()) {
            if (i > 0) {
                sb.append(this.sep);
            }
            KscfGeneralTreeNode treeNode = nodeList.get(i);
            sb.append(treeNode.nameShort);
            ++i;
        }
        return sb.toString();
    }

    public String getNamePath(DtsSession dtsSession, int nodeId) throws Exception {
        List<KscfGeneralTreeNode> nodeList = this.getTreePath(dtsSession, nodeId);
        return this.createNamePath(nodeList);
    }

    public void updatePath(DtsSession dtsSession, int nodeId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        List<KscfGeneralTreeNode> nodeList = this.getTreePath(dtsSession, nodeId);
        String codePath = this.createCodePath(nodeList);
        String namePath = this.createNamePath(nodeList);
        String query = "UPDATE " + this.tableName + " SET " + "code_path=" + sqlContext.toSet(codePath) + ",name_path=" + sqlContext.toSet(namePath) + " WHERE " + "id=" + nodeId;
        int updateCount = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            updateCount = stmt.executeUpdate(query);
        }
        List<KscfGeneralTreeNode> childNodeList = this.getChildNodeList(dtsSession, nodeId, KscfGeneralTreeNode.class);
        int i = 0;
        while (i < childNodeList.size()) {
            KscfGeneralTreeNode treeNode = childNodeList.get(i);
            this.updatePath(dtsSession, treeNode.getDataId());
            ++i;
        }
    }

    public void makeTreePath(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            String query = " DELETE FROM " + this.treePathTableName;
            stmt.executeUpdate(query);
            query = " INSERT INTO " + this.treePathTableName + " (start_id, end_id, path_length)" + " SELECT" + " a.id" + ",b.id" + ",1" + " FROM" + " " + this.tableName + " AS a" + "," + this.tableName + " AS b" + " WHERE" + " a.id = b.parent_id";
            stmt.executeUpdate(query);
            query = " INSERT INTO " + this.treePathTableName + " (start_id, end_id, path_length)" + " SELECT" + " a.start_id" + ",b.end_id" + ",(A.path_length + 1)" + " FROM" + " " + this.treePathTableName + " AS a" + "," + this.treePathTableName + " AS b" + " WHERE" + " a.end_id = b.start_id" + " AND" + " b.path_length = 1" + " AND" + " a.path_length = (SELECT MAX(path_length) FROM " + this.treePathTableName + ")";
            while (stmt.executeUpdate(query) != 0) {
            }
        }
    }
}

