/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.Component;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.swing.lookAndFeel.SwgLafEventHandler;
import jp.co.extreme.swing.lookAndFeel.SwgLafManager;
import jp.co.extreme.swing.lookAndFeel.SwgLafUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HswgLafHelper
implements SwgLafEventHandler {
    private File lafFile;
    private Document lafXml;
    private Element rootElem;
    private int setupCnt = 0;
    public static final String laf_file = "laf.xml";
    public static final String TAG_laf = "laf";
    public static final String TAG_font_size = "font/size";
    public static final String TAG_theme = "theme";

    private HswgLafHelper() {
    }

    public static HswgLafHelper getInstance() {
        return SingletonHolder.instance;
    }

    public void setup(Component component) throws Exception {
        if (this.setupCnt > 0) {
            BcLogUtil.warning("L&F\u30d8\u30eb\u30d1\u306f\u65e2\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            return;
        }
        ++this.setupCnt;
        String lafFilePath = AfbApplication.getInstance().toReal("${APP}config/laf.xml");
        this.lafFile = new File(lafFilePath);
        String themeName = null;
        int fontSize = -1;
        if (this.lafFile.exists()) {
            this.lafXml = BcXmlUtil.createDocument(this.lafFile);
            this.rootElem = this.lafXml.getDocumentElement();
            themeName = BcXmlUtil.getTextValue(this.rootElem, TAG_theme);
            fontSize = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(this.rootElem, TAG_font_size), -1);
        } else {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.lafXml = documentBuilder.newDocument();
            this.rootElem = this.lafXml.createElement(TAG_laf);
            this.lafXml.appendChild(this.rootElem);
        }
        if (BcStringUtil.isEmpty(themeName)) {
            themeName = SwgLafUtil.getDefaultThemeName();
        }
        if (fontSize <= 0) {
            BcLogUtil.warning("\u30d5\u30a9\u30f3\u30c8\u306e\u30b5\u30a4\u30ba\u6307\u5b9a\u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002fontSize=" + fontSize);
            fontSize = 12;
        }
        SwgLafManager.getInstance().setFontSize(fontSize);
        SwgLafManager.getInstance().setTheme(component, themeName);
        SwgLafManager.getInstance().addLafEventHandler(this);
    }

    public Document getLafXml() {
        return this.lafXml;
    }

    public void setupNotException(Component component) {
        try {
            this.setup(component);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            try {
                String themeName = SwgLafUtil.getDefaultThemeName();
                int fontSize = 12;
                SwgLafManager.getInstance().setTheme(component, themeName);
            }
            catch (Exception ex2) {
                BcLogUtil.error(ex2);
            }
        }
    }

    @Override
    public void lafChanged(int fontSize, String lafMode) throws Exception {
        BcXmlUtil.setTextValue(this.rootElem, TAG_font_size, fontSize);
        BcXmlUtil.setTextValue(this.rootElem, TAG_theme, lafMode);
        File tmpFile = File.createTempFile(BcFileUtil.getBaseName(this.lafFile), ".tmp", this.lafFile.getParentFile());
        BcXmlUtil.output(this.lafXml, tmpFile, true);
        BcFileUtil.deleteIfExists(this.lafFile);
        BcFileUtil.rename(tmpFile, this.lafFile);
    }

    /* synthetic */ HswgLafHelper(HswgLafHelper hswgLafHelper) {
        this();
    }

    private static final class SingletonHolder {
        private static final HswgLafHelper instance = new HswgLafHelper(null);

        private SingletonHolder() {
        }
    }
}

