/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf3.client;

import java.util.List;
import javax.swing.event.EventListenerList;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.rmi.client.RmiLocalAgent;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.stub.ScfHandleStub;
import jp.co.extreme.scf3.client.ScfSqlClientEventHandler;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.task.TskAbstractCallable;

public class ScfSqlClientTask
extends TskAbstractCallable {
    private int statusId;
    protected boolean eod;
    protected int requireRowCount = 100;
    private Integer rowCount;
    protected int loadedRowSize;
    private int requestCount;
    private RmiRequest rmiReq1;
    private RmiRespons rmiRes1;
    private RmiRequest rmiReq2;
    private String handleId;
    private List<BcTableColumn> tableColumnList;
    private RmiLocalAgent localAgent;
    private EventListenerList eventListenerList = new EventListenerList();

    protected int getStatusId() {
        return this.statusId;
    }

    protected void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public String getHandleId() {
        return this.handleId;
    }

    public RmiLocalAgent getLocalAgent() {
        return this.localAgent;
    }

    public void setLocalAgent(RmiLocalAgent localAgent) {
        this.localAgent = localAgent;
    }

    public ScfSqlClientTask() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.statusId = Status.init.id;
        this.rmiRes1 = null;
        this.handleId = null;
        this.eod = false;
        this.rowCount = -1;
        this.loadedRowSize = 0;
        this.requestCount = 0;
        this.tableColumnList = null;
    }

    protected Object taskProcess() throws Exception {
        this.setStatusId(Status.running.id);
        if (this.rmiRes1 == null) {
            this.started();
            RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq1);
            Object result = this.setRespons1(rmiRes);
            if (result != null) {
                this.setStatusId(Status.idling.id);
                this.resultReceived(result);
                return result;
            }
        }
        try {
            this.rmiReq2 = ScfDatabaseStub.getInstance().getNextRecord(this.handleId, this.requireRowCount);
            while (!this.eod) {
                if (this.getStatusId() != Status.running.id) {
                    break;
                }
                this.loadRows();
            }
        }
        finally {
            try {
                ScfHandleStub.getInstance().removeHandle(this.getLocalAgent(), this.handleId);
            }
            finally {
                this.setStatusId(Status.idling.id);
            }
        }
        this.loaded(this.eod);
        return this.loadedRowSize;
    }

    public Object setRespons1(RmiRespons rmiRes1) throws Exception {
        this.rmiRes1 = rmiRes1;
        if (rmiRes1.getStatusId() == -9) {
            throw rmiRes1.getException();
        }
        Object result = rmiRes1.getObject("result");
        if (result instanceof Number) {
            Number number = (Number)result;
            return number;
        }
        this.handleId = rmiRes1.getDataAsString("hId");
        Object tmpObject = rmiRes1.getObject("tableColumnList");
        if (tmpObject == null) {
            RmiRespons rmiRes = ScfDatabaseStub.getInstance().getTableHeader(this.getLocalAgent(), this.handleId);
            this.setRespons2(rmiRes);
        } else {
            this.setRespons2(rmiRes1);
        }
        return null;
    }

    protected void setRespons2(RmiRespons rmiRes2) throws Exception {
        boolean isOk = rmiRes2.getDataAsBoolean();
        if (isOk) {
            Object result = rmiRes2.getObject("tableColumnList");
            if (result instanceof List) {
                List tableColumnList = (List)rmiRes2.getObject("tableColumnList");
                this.rowCount = (Integer)rmiRes2.getObject("tb_rs");
                if (this.rowCount == null) {
                    this.rowCount = -1;
                }
                BcTableContext tableContext = (BcTableContext)rmiRes2.getObject("tb_ctx");
                this.tableColumnReceived(tableColumnList, this.rowCount, tableContext);
            } else {
                this.eod = true;
                this.resultReceived(result);
            }
        } else {
            Object reason = rmiRes2.getObject("result");
            String msg = null;
            if (reason != null) {
                this.setStatusId(Status.canceled.id);
                msg = reason.toString();
            } else {
                msg = "\u30c6\u30fc\u30d6\u30eb\u30d8\u30c3\u30c0\u53d6\u5f97\u306e\u5fdc\u7b54\u304c\u60f3\u5b9a\u5916\u3067\u3059\u3002";
            }
            throw new Exception(msg);
        }
    }

    protected void loadRows() throws Exception {
        List rowList;
        ++this.requestCount;
        RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq2);
        Integer eodNum = (Integer)rmiRes.getObject("eod");
        if (eodNum != null) {
            boolean bl = this.eod = eodNum == BcConstants.Existence.TRUE.value;
        }
        if ((rowList = (List)rmiRes.getObject("tb_rl")) != null) {
            this.rowListReceived(rowList);
        }
    }

    protected RmiRequest getRequest() {
        return this.rmiReq1;
    }

    public void setRequest(RmiRequest rmiReq1) throws Exception {
        this.rmiReq1 = rmiReq1;
    }

    protected void started() throws Exception {
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.started(this);
            ++n2;
        }
    }

    protected void tableColumnReceived(List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        this.tableColumnList = tableColumnList;
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.tableColumnReceived(this, tableColumnList, rowCount, tableContext);
            ++n2;
        }
    }

    protected void rowListReceived(List<List> rowList) throws Exception {
        this.loadedRowSize += rowList.size();
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.rowListReceived(this, rowList);
            ++n2;
        }
        this.loadedRowCountChanged(this.rowCount, this.loadedRowSize);
    }

    protected void loaded(boolean eod) throws Exception {
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.loaded(this, eod);
            ++n2;
        }
    }

    protected void loadedRowCountChanged(int rowCount, int loadedRowCount) throws Exception {
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.loadedRowCountChanged(this, rowCount, loadedRowCount);
            ++n2;
        }
    }

    protected void resultReceived(Object result) throws Exception {
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler tableLoadEvent = scfSqlClientEventHandlerArray[n2];
            tableLoadEvent.resultReceived(this, result);
            ++n2;
        }
    }

    protected void cancelStarted(Object source) throws Exception {
        this.setStatusId(Status.cancelling.id);
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.cancelStarted(this, source);
            ++n2;
        }
    }

    protected void canceled() throws Exception {
        this.setStatusId(Status.canceled.id);
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.canceled(this);
            ++n2;
        }
    }

    protected void tableLoadError(Throwable throwable) {
        this.setStatusId(Status.erred.id);
        ScfSqlClientEventHandler[] scfSqlClientEventHandlerArray = (ScfSqlClientEventHandler[])this.eventListenerList.getListeners(ScfSqlClientEventHandler.class);
        int n = scfSqlClientEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfSqlClientEventHandler sqlClientEventHandler = scfSqlClientEventHandlerArray[n2];
            sqlClientEventHandler.errorOccurred(this, throwable);
            ++n2;
        }
    }

    public void cancel(Object source) throws Exception {
        if (this.getStatusId() != Status.running.id) {
            this.getLogger().warning("Table loader not running.");
            return;
        }
        this.cancelStarted(source);
        RmiRespons rmiRes = ScfDatabaseStub.getInstance().cancelQuery(this.getLocalAgent(), this.handleId);
        this.canceled();
    }

    @Override
    protected void handleException(Throwable throwable) {
        this.tableLoadError(throwable);
    }

    public List<BcTableColumn> getTableColumnList() {
        return this.tableColumnList;
    }

    public EventListenerList getEventListenerList() {
        return this.eventListenerList;
    }

    public static enum Status {
        init(0),
        idling(1),
        running(2),
        cancelling(3),
        canceled(4),
        erred(5);

        public final int id;

        private Status(int value) {
            this.id = value;
        }
    }
}

