/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcRandamUtil;
import jp.co.extreme.scf.server.ScfServerLogger;

public class ScfServerLoggerManager
extends BcLoggableObject {
    private Map<String, ScfServerLogger> loggerMap = new HashMap<String, ScfServerLogger>();
    protected Random random = new Random();

    public static ScfServerLoggerManager getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    public synchronized ScfServerLogger createLogger() throws Exception {
        String handleId;
        ScfServerLogger serverLogger = null;
        while (this.loggerMap.containsKey(handleId = BcRandamUtil.createCode(this.random, 5, 32))) {
        }
        serverLogger = new ScfServerLogger(handleId);
        this.loggerMap.put(handleId, serverLogger);
        return serverLogger;
    }

    public ScfServerLogger getLogger(String handleId) throws Exception {
        ScfServerLogger serverLogger = this.loggerMap.get(handleId);
        return serverLogger;
    }

    public ScfServerLogger removeLogger(String handleId) throws Exception {
        ScfServerLogger serverLogger = this.loggerMap.remove(handleId);
        return serverLogger;
    }

    private static final class SingletonHolder {
        private static final ScfServerLoggerManager instance = new ScfServerLoggerManager();

        private SingletonHolder() {
        }
    }
}

