/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.pdf.object;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.pdf.PdfUtil;
import jp.co.extreme.pdf.object.PdfFont;
import jp.co.extreme.pdf.object.PdfObject;

public class PdfContents
extends PdfObject
implements Serializable {
    private static final long serialVersionUID = -7897322390612415789L;
    protected StringBuilder buf = new StringBuilder();
    protected static String FONTMAP_NAME = "ext.lib.pdf.font.fontmap";
    protected PdfFont currentFont;
    protected double currentFontSize = 10.0;
    protected double currentCharSpace = 0.0;
    protected double currentWordSpace = 0.0;
    protected double currentLeading = 0.0;
    protected boolean isPathOpened = false;
    protected boolean isInText = false;

    @Override
    protected byte[] getObjectDetail() {
        if (this.isPathOpened) {
            this.closePath();
        }
        if (this.isInText) {
            this.endText();
        }
        String str = "<<\r\n/Length " + Integer.toString(this.buf.length()) + "\r\n" + ">>\r\n" + "stream\r\n" + this.buf.toString() + "endstream\r\n";
        return str.getBytes();
    }

    public void closeFillStroke() {
        this.buf.append("b\n");
        this.isPathOpened = false;
    }

    public void fillAndStroke() {
        this.buf.append("B\n");
    }

    public void closePathEofillStroke() {
        this.buf.append("b*\n");
        this.isPathOpened = false;
    }

    public void eofillStroke() {
        this.buf.append("B*\n");
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.buf.append(String.valueOf(Double.toString(x1)) + " " + Double.toString(y1) + " " + Double.toString(x2) + " " + Double.toString(y2) + " " + Double.toString(x3) + " " + Double.toString(y3) + " c\n");
    }

    public void curveTo(double[] dv) {
        this.curveTo(dv[0], dv[1], dv[2], dv[3], dv[4], dv[5]);
    }

    public void curveTo(double x1, double y1, double x2, double y2) {
        this.buf.append(String.valueOf(Double.toString(x1)) + " " + Double.toString(y1) + " " + Double.toString(x2) + " " + Double.toString(y2) + " v\n");
    }

    public void concat(double a, double b, double c, double d, double e, double f) {
        this.buf.append(String.valueOf(Double.toString(a)) + " " + Double.toString(b) + " " + Double.toString(c) + " " + Double.toString(d) + " " + Double.toString(e) + " " + Double.toString(f) + " cm\n");
    }

    public void setDash(int value1, int value2, int phase) {
        this.buf.append("[");
        if (value1 > 0) {
            this.buf.append(String.valueOf(Integer.toString(value1)) + " ");
        }
        if (value2 > 0) {
            this.buf.append(String.valueOf(Integer.toString(value2)) + " ");
        }
        this.buf.append("]" + Integer.toString(phase) + " d\n");
    }

    public void beginText() {
        if (this.isPathOpened) {
            this.closePath();
        }
        if (this.isInText) {
            this.endText();
        }
        this.buf.append("BT\n");
    }

    public void endText() {
        this.buf.append("ET\n");
    }

    public void fillPath() {
        this.buf.append("f\n");
    }

    public void EofillPath() {
        this.buf.append("f*\n");
    }

    public void closePath() {
        this.isPathOpened = false;
        this.buf.append("h\n");
    }

    public void setFlat(int value) {
        this.buf.append(String.valueOf(Integer.toString(value)) + " i\n");
    }

    public void setLineJoin(int value) {
        this.buf.append(String.valueOf(Integer.toString(value)) + " j\n");
    }

    public void setLineCap(int value) {
        this.buf.append(String.valueOf(Integer.toString(value)) + " J\n");
    }

    public void lineTo(double x, double y) {
        this.buf.append(String.valueOf(Double.toString(x)) + " " + Double.toString(y) + " l\n");
    }

    public void moveTo(double x, double y) {
        this.buf.append(String.valueOf(Double.toString(x)) + " " + Double.toString(y) + " m\n");
    }

    public void setMiterLimit(double limit) {
        this.buf.append(String.valueOf(Double.toString(limit)) + " M\n");
    }

    public void endPath() {
        this.isPathOpened = false;
        this.buf.append("n\n");
    }

    public void saveGraphicsState() {
        this.buf.append("q\n");
    }

    public void restoreGraphicsState() {
        this.buf.append("Q\n");
    }

    public void setRgbFillColor(int r, int g, int b) {
        this.buf.append(String.valueOf(Float.toString((float)r / 255.0f)) + " " + Float.toString((float)g / 255.0f) + " " + Float.toString((float)b / 255.0f) + " rg\n");
    }

    public void setRgbStrokeColor(int r, int g, int b) {
        this.buf.append(String.valueOf(Float.toString((float)r / 255.0f)) + " " + Float.toString((float)g / 255.0f) + " " + Float.toString((float)b / 255.0f) + " RG\n");
    }

    public void closeAndStrokePath() {
        this.isPathOpened = false;
        this.buf.append("s\n");
    }

    public void strokePath() {
        this.buf.append("S\n");
    }

    protected void rectangle(double x, double y, double width, double height) {
        this.buf.append(String.valueOf(Double.toString(x)) + " " + Double.toString(y) + " " + Double.toString(width) + " " + Double.toString(height) + " re\n");
    }

    public void setCharacterSpacing(double value) {
        this.buf.append(String.valueOf(Double.toString(value)) + " Tc\n");
        this.currentCharSpace = value;
    }

    public void moveTextPoint(double x, double y) {
        this.buf.append(String.valueOf(Double.toString(x)) + " " + Double.toString(y) + " Td\n");
    }

    public void setFont(String name, double size) {
        this.currentFont = this.getOwner().getFont(name);
        this.currentFontSize = size;
        this.buf.append("/F" + Integer.toString(this.currentFont.getName()) + " " + Double.toString(size) + " Tf\r\n");
    }

    protected String escapeText(String text) throws Exception {
        char[] escapeChars = new char[]{'(', ')', '\\'};
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            int j = 0;
            while (j < escapeChars.length) {
                if (ch == escapeChars[j]) {
                    sb.append('\\');
                    break;
                }
                ++j;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public void showText(String text) throws Exception {
        this.buf.append("(" + this.escapeText(text) + ") Tj\r\n");
    }

    public void showJText(String text) {
        this.buf.append("<" + PdfUtil.toUnicodeString(text) + "> Tj\r\n");
    }

    public void setLeading(double value) {
        this.buf.append(String.valueOf(Double.toString(value)) + " TL\n");
        this.currentLeading = value;
    }

    public void setTextRenderingMode(int value) {
        this.buf.append(String.valueOf(Integer.toString(value)) + " Tr\n");
    }

    public void setTextRise(double value) {
        this.buf.append(String.valueOf(Double.toString(value)) + " Ts\n");
    }

    public void setWordSpacing(double value) {
        this.buf.append(String.valueOf(Double.toString(value)) + " Tw\n");
        this.currentWordSpace = value;
    }

    public void setHorizontalScaling(double value) {
        this.buf.append(String.valueOf(Double.toString(value)) + " Tz\n");
    }

    public void moveToStartOfNextLine() {
        this.buf.append("T*\n");
    }

    public void setLineWidth(double value) {
        this.buf.append(String.valueOf(Double.toString(value)) + " w\n");
    }

    public void clip() {
        this.buf.append("W\n");
    }

    public void eoclip() {
        this.buf.append("W*\n");
    }

    protected String getDefaultFont() {
        ResourceBundle b = ResourceBundle.getBundle(FONTMAP_NAME);
        return b.getString("DefaultFont");
    }

    public void clipRect(double x, double y, double width, double height) {
        this.rectangle(x, y, width, height);
        this.saveGraphicsState();
        this.clip();
        this.endPath();
    }

    public void changeFontType() {
        this.restoreGraphicsState();
    }

    protected void changeFontType(boolean isMultibyteFont, boolean Dummy) {
        if (this.currentFont == null) {
            this.setFont(this.getDefaultFont(), this.currentFontSize);
        }
        if (this.currentFont.isMultibyteFont() != isMultibyteFont) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(FONTMAP_NAME);
            String oldFontName = this.currentFont.getClass().getName();
            try {
                String newFontName = resourceBundle.getString(oldFontName);
                if (!Dummy) {
                    this.setFont(newFontName, this.currentFontSize);
                } else {
                    this.currentFont = this.getOwner().getFont(newFontName);
                }
            }
            catch (MissingResourceException ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.moveTo(x1, y1);
        this.lineTo(x2, y2);
        this.strokePath();
        this.endPath();
    }

    public void drawLine(double x1, double y1, double x2, double y2, double lineWidth) {
        this.setLineWidth(lineWidth);
        this.moveTo(x1, y1);
        this.lineTo(x2, y2);
        this.strokePath();
        this.endPath();
    }

    public void drawRect(double x, double y, double width, double height) {
        this.rectangle(x, y, width, height);
        this.closeAndStrokePath();
    }

    public void fillRect(double x, double y, double width, double height) {
        this.rectangle(x, y, width, height);
        this.closePath();
        this.fillPath();
    }

    public void drawAndFillRect(double x, double y, double width, double height) {
        this.rectangle(x, y, width, height);
        this.closePath();
        this.fillAndStroke();
    }

    public void textOut(double x, double y, String text, double size) throws Exception {
        this.beginText();
        this.moveTextPoint(x, y);
        this.setFont(this.getDefaultFont(), size);
        this.showTextEx(this.splitText(text));
        this.endText();
    }

    public void textOut(double x, double y, String text, String fontName, double size) throws Exception {
        this.beginText();
        this.moveTextPoint(x, y);
        this.setFont(fontName, size);
        this.showTextEx(this.splitText(text));
        this.endText();
    }

    public void textOut(double x, double y, String text) throws Exception {
        this.beginText();
        this.moveTextPoint(x, y);
        this.showTextEx(this.splitText(text));
        this.endText();
    }

    public void textOut(double x, double y, double width, String text) throws Exception {
        if (this.currentLeading == 0.0) {
            this.setLeading(this.currentFontSize);
        }
        this.beginText();
        this.moveTextPoint(x, y);
        String s = this.formatText(text, width);
        ArrayList list = this.splitText(s);
        this.showTextEx(list);
        this.endText();
    }

    public ArrayList splitText(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int strPos = 0;
        int len = text.length();
        int i = 0;
        while (i < len) {
            if (text.charAt(i) == '\n') {
                String s = new String(text.substring(strPos, i));
                list.add(s);
                strPos = i + 1;
            }
            ++i;
        }
        if (text.charAt(len - 1) != '\n') {
            String s = new String(text.substring(strPos, len));
            list.add(s);
        }
        return list;
    }

    private double getCharWidth(char ch) {
        if (ch > '\u00ff') {
            this.changeFontType(true, true);
        } else {
            this.changeFontType(false, false);
        }
        return (double)this.currentFont.getCharWidth(ch) * this.currentFontSize / 1000.0;
    }

    public int measureText(String text, double width) {
        double w = 0.0;
        int len = text.length();
        int ret = 0;
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            w += this.getCharWidth(ch);
            w += this.currentCharSpace;
            if (ch == ' ') {
                if (width < (w += this.currentWordSpace)) break;
                ret = i + 1;
            } else if (text.charAt(i) > '\u00ff') {
                if (width < w && ch != '\u3002' && ch != '\u3001') break;
                ret = i + 1;
            }
            ++i;
        }
        if (w < width || ret == 0) {
            return len;
        }
        return ret;
    }

    public String formatText(String text, double width) {
        int strPos = 0;
        int len = text.length();
        StringBuilder sb = new StringBuilder("");
        while (strPos < len) {
            int ret = this.measureText(text.substring(strPos), width);
            sb.append(String.valueOf(text.substring(strPos, strPos + ret)) + "\n");
            strPos += ret;
        }
        return sb.toString();
    }

    public double getTextWidth(String text) {
        double w = 0.0;
        int len = text.length();
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            w += this.getCharWidth(ch);
            w += this.currentCharSpace;
            if (ch == ' ') {
                w += this.currentWordSpace;
            }
            ++i;
        }
        return w;
    }

    public void showTextEx(String text) throws Exception {
        int strPos = 0;
        boolean inAsciiChar = true;
        int len = text.length();
        int i = 0;
        while (i < len) {
            if (text.charAt(i) > '\u00ff') {
                if (inAsciiChar) {
                    String subString1 = text.substring(strPos, i);
                    this.changeFontType(false, false);
                    this.showText(subString1);
                    inAsciiChar = false;
                    strPos = i;
                }
            } else if (text.charAt(i) <= '\u00ff' && !inAsciiChar) {
                String subString2 = text.substring(strPos, i);
                this.changeFontType(true, false);
                this.showJText(subString2);
                inAsciiChar = true;
                strPos = i;
            }
            ++i;
        }
        if (strPos <= len) {
            String subString3 = text.substring(strPos, len);
            if (inAsciiChar) {
                this.changeFontType(false, false);
                this.showText(subString3);
            } else {
                this.changeFontType(true, false);
                this.showJText(subString3);
            }
        }
    }

    public void showTextEx(List textList) throws Exception {
        int i = 0;
        while (i < textList.size()) {
            this.showTextEx((String)textList.get(i));
            this.moveToStartOfNextLine();
            ++i;
        }
    }

    public void drawImage() throws Exception {
    }

    public void drawImage_bak() {
        BcLogUtil.debug("drawImage..................................");
        this.buf.append("0 0.5 0 rg\n144 0 0 144 72 144 cm\nBI\n/W 16\n/H 16\n/BPC 1\n/F /AHx\n/IM true\nID\n0FFF\n0FFF\n0FFF\n0FFF\n00FF\n00FF\n00FF\n00FF\n000F\n000F\n000F\n000F\n0000\n0000\n0000\n0000>\nEI");
    }
}

