/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcKanaUtil;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpModule;
import jp.co.extreme.nlp.NlpNounFinderHelper;
import jp.co.extreme.nlp.NlpPersonNameUtil;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpUtil;
import jp.co.extreme.nlp.NlpWord;

public class NlpPersonNameFinder2
extends BcLoggableObject
implements NlpModule {
    private NounFinderHelper nounFinderHelper = new NounFinderHelper();
    private Map<String, NlpWord> lastNameMap;
    private Map<String, NlpWord> firstNameManMap;
    private Map<String, NlpWord> firstNameWomanMap;
    private Map<String, NlpWord> kanaMap;
    public Map<String, NlpWord> famousPersonNounMap;

    public void init() throws Exception {
        NlpWord noun2;
        NlpWord noun1;
        this.getLogger().debug("ExtNameFinderImpl2 setup...");
        this.lastNameMap = new LinkedHashMap<String, NlpWord>();
        this.setup_L2(this.lastNameMap, NlpPersonNameUtil.lastNameDat, false);
        this.firstNameManMap = new LinkedHashMap<String, NlpWord>();
        this.setup_L2(this.firstNameManMap, NlpPersonNameUtil.firstNameManDat, true);
        this.firstNameWomanMap = new LinkedHashMap<String, NlpWord>();
        this.setup_L2(this.firstNameWomanMap, NlpPersonNameUtil.firstNameWomanDat, true);
        this.kanaMap = new LinkedHashMap<String, NlpWord>();
        for (Map.Entry<String, NlpWord> mapEentry : this.firstNameManMap.entrySet()) {
            noun1 = mapEentry.getValue();
            if (this.kanaMap.containsKey(noun1.reading)) continue;
            noun2 = new NlpWord();
            noun2.text = noun2.key = noun1.reading;
            noun2.reading = noun2.key;
            noun2.score = 1;
            this.kanaMap.put(noun2.key, noun2);
        }
        for (Map.Entry<String, NlpWord> mapEentry : this.firstNameWomanMap.entrySet()) {
            noun1 = mapEentry.getValue();
            if (this.kanaMap.containsKey(noun1.reading)) continue;
            noun2 = new NlpWord();
            noun2.text = noun2.key = noun1.reading;
            noun2.reading = noun2.key;
            noun2.score = 1;
            this.kanaMap.put(noun2.key, noun2);
        }
        for (Map.Entry<String, NlpWord> mapEentry : this.famousPersonNounMap.entrySet()) {
            NlpWord noun22;
            String[] strArray;
            noun1 = mapEentry.getValue();
            if (noun1.text.indexOf(BcUnicode.space.char_) < 0 || (strArray = noun1.text.split("\\s")).length != 2) continue;
            if (!this.lastNameMap.containsKey(strArray[0])) {
                noun22 = new NlpWord();
                noun22.text = noun22.key = strArray[0];
                noun22.score = 1;
                this.lastNameMap.put(noun22.key, noun22);
            }
            if (this.firstNameManMap.containsKey(strArray[1])) continue;
            noun22 = new NlpWord();
            noun22.text = noun22.key = strArray[1];
            noun22.score = 1;
            this.firstNameManMap.put(noun22.key, noun22);
        }
    }

    protected void setup_L2(Map<String, NlpWord> map1, String fileName, boolean isOne) throws Exception {
        BcTableModel tableModel = null;
        Throwable throwable = null;
        Object var6_9 = null;
        try (InputStream is = this.getClass().getResourceAsStream(fileName);){
            ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bais, BcConstants.charset);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            tableModel = BcCsvToTable.getInstance().csvToTable(inputStreamReader, -1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int i = 0;
        while (i < tableModel.getRowCount()) {
            String key = (String)tableModel.getValueAt(i, 1);
            if (!isOne || key.length() != 1) {
                NlpWord word = map1.get(key);
                if (word == null) {
                    word = new NlpWord();
                    word.text = word.key = key;
                    word.reading = (String)tableModel.getValueAt(i, 2);
                    word.score = 1;
                    map1.put(word.key, word);
                } else {
                    List<String> valueList = BcCsvUtil.parseCsvRow(word.reading, false);
                    valueList.add((String)tableModel.getValueAt(i, 2));
                    word.reading = BcCsvUtil.toCsv(valueList);
                }
            }
            ++i;
        }
        this.getLogger().debug(String.valueOf(fileName) + ":map-size=" + map1.size());
    }

    @Override
    public List<NlpElement> find(List<NlpTokenWrap> tokenWrapList) throws Exception {
        List<NlpElement> elementList = this.nounFinderHelper.find(tokenWrapList);
        return elementList;
    }

    NlpWord getNoun(List<NlpTokenWrap> tokenWrapList) throws Exception {
        if (this.lastNameMap == null) {
            this.init();
        }
        NlpWord noun = null;
        int i = 0;
        while (i < tokenWrapList.size() - 1) {
            List<NlpTokenWrap> tokenWrapList31 = tokenWrapList.subList(0, i + 1);
            String lastName = NlpUtil.toStringForJA(tokenWrapList31);
            List<NlpTokenWrap> tokenWrapList32 = tokenWrapList.subList(i + 1, tokenWrapList.size());
            String firstName = NlpUtil.toStringForJA(tokenWrapList32);
            NlpWord noun_lastName = this.lastNameMap.get(lastName);
            if (noun_lastName != null) {
                NlpWord noun_firstName = this.firstNameManMap.get(firstName);
                if (noun_firstName == null) {
                    noun_firstName = this.firstNameWomanMap.get(firstName);
                }
                if (noun_firstName == null) {
                    String kana = BcKanaUtil.hanKanaToZenKana(firstName, 2);
                    NlpWord noun_temp = this.kanaMap.get(kana = BcKanaUtil.hiraganaToZenKana(kana, 2));
                    if (noun_temp != null) {
                        noun_firstName = new NlpWord();
                        noun_firstName.text = noun_firstName.key = firstName;
                        noun_firstName.reading = noun_temp.reading;
                    }
                }
                if (noun_firstName != null) {
                    noun = new NlpWord();
                    noun.key = String.valueOf(noun_lastName.key) + noun_firstName.key;
                    noun.text = String.valueOf(noun_lastName.text) + " " + noun_firstName.text;
                    if (noun_lastName.reading != null && noun_firstName.reading != null) {
                        noun.reading = String.valueOf(this.getFirst(noun_lastName.reading)) + " " + this.getFirst(noun_firstName.reading);
                    }
                    noun.score = 1;
                    break;
                }
            }
            ++i;
        }
        NlpWord noun2 = null;
        if (noun != null) {
            noun2 = (NlpWord)noun.clone();
        }
        return noun2;
    }

    protected String getFirst(String str) throws Exception {
        List<String> valueList = BcCsvUtil.parseCsvRow(str, false);
        String first = BcCollectionUtil.getFirst(valueList);
        return first;
    }

    class NounFinderHelper
    extends NlpNounFinderHelper {
        NounFinderHelper() {
        }

        @Override
        NlpWord getNoun(List<NlpTokenWrap> tokenWrapList) throws Exception {
            return NlpPersonNameFinder2.this.getNoun(tokenWrapList);
        }
    }
}

