/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.web;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcSharedObjectManager;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvResourceHolder;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.module.wbfw.common.WbSessionTimeoutException;
import jp.co.extreme.module.wbfw.common.WbfwConstants;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.server.XwebMailHelper;
import jp.co.extreme.module.wbfw.servlet.WbfwMainServlet;
import jp.co.extreme.module.wbs1.model.Wbs1Access;
import jp.co.extreme.module.wbs1.wcb.Wbs1ErrorWCB;
import jp.co.extreme.module.wbs1.wcb.X_Wbs1ImageListWCB;
import jp.co.extreme.module.xweb.common.WbxAccessLoggerImpl;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.module.xweb.web.InnerImageWCB;
import jp.co.extreme.module.xweb.web.XwebFileManagerWCB;
import jp.co.extreme.module.xweb.web.XwebPathSetting;
import jp.co.extreme.rmi.common.RmiMethodContext;

public class XwebMainServlet
extends WbfwMainServlet {
    private static final long serialVersionUID = -3436012240721836043L;
    WbxAccessLoggerImpl accessLogger = new WbxAccessLoggerImpl();

    public XwebMainServlet() throws Exception {
        HtsvSiteContext siteContextDefault = HtsvResourceHolder.getInstance().webContainer.getSiteContextDefault();
        Map<String, RmiMethodContext> servletPathMap = siteContextDefault.servletPathMap;
        XwebPathSetting pathSetting = new XwebPathSetting();
        List<String> classNameList = pathSetting.getDbTool();
        for (String className : classNameList) {
            XwebUtil.putToMap(className, servletPathMap);
        }
    }

    @Override
    public void httpTrans(HtsvArgument wcbArg) throws Exception {
        HttpServletRequest httpReq = wcbArg.getRequest();
        Wbs1Access access = XwebUtil.createAccessLog(wcbArg);
        this.accessLogger.log(access);
        if ("/".equals(httpReq.getServletPath())) {
            HtsvSiteContext siteContext = wcbArg.getSiteContext();
            if (BcStringUtil.isEmpty(siteContext.homePath)) {
                throw new Exception("homePath=" + siteContext.homePath);
            }
            XwebUtil.forward(wcbArg, siteContext.homePath);
            return;
        }
        ImageMenu[] imageMenuArray = ImageMenu.values();
        int n = imageMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageMenu imageMenu = imageMenuArray[n2];
            if (imageMenu.getPath().equals(httpReq.getServletPath())) {
                this.imageProc(wcbArg, imageMenu);
                return;
            }
            ++n2;
        }
        HtsvSiteContext siteContextDefault = HtsvResourceHolder.getInstance().webContainer.getSiteContextDefault();
        wcbArg.methodContext = siteContextDefault.servletPathMap.get(wcbArg.servletPath);
        if (wcbArg.methodContext != null) {
            WbfwUtil.invoke(wcbArg.methodContext.className, wcbArg.methodContext.methodName, wcbArg);
            return;
        }
        super.httpTrans(wcbArg);
    }

    @Override
    protected void fileList(HtsvArgument wcbArg, File file) throws Exception {
        XwebFileManagerWCB fileManagerWCB = new XwebFileManagerWCB();
        fileManagerWCB.file(wcbArg);
    }

    @Override
    protected void notFound(HtsvArgument wcbArg) throws Exception {
        Object notFound = wcbArg.getRequest().getAttribute(WbfwConstants.RequestAttributeKey.notFound.name());
        if (notFound == null) {
            wcbArg.getRequest().setAttribute(WbfwConstants.RequestAttributeKey.notFound.name(), null);
            String path = XwebUtil.toContextPath(Wbs1ErrorWCB.Method.notFound);
            XwebUtil.forward(wcbArg, path);
        } else {
            BcLogUtil.warning("notFound=" + notFound);
            super.notFound(wcbArg);
        }
    }

    @Override
    public void sessionTimeoutOccurred(HtsvArgument wcbArg, WbSessionTimeoutException ex) throws Exception {
        if (this.isThrowableLoop(wcbArg, ex)) {
            return;
        }
        wcbArg.getRequest().setAttribute(WbfwConstants.RequestAttributeKey.throwable.name(), (Object)ex);
        String path = XwebUtil.toContextPath(Wbs1ErrorWCB.Method.error);
        XwebUtil.forward(wcbArg, path);
    }

    @Override
    public void exceptionOccurred(HtsvArgument wcbArg, Throwable throwable) throws Exception {
        if (this.isThrowableLoop(wcbArg, throwable)) {
            return;
        }
        this.getLogger().error(throwable);
        wcbArg.getResponse().sendError(500, throwable.getMessage());
        wcbArg.getRequest().setAttribute(WbfwConstants.RequestAttributeKey.throwable.name(), (Object)throwable);
        this.getLogger().error(BcLogUtil.convertMessage(throwable));
        String path = XwebUtil.toContextPath(Wbs1ErrorWCB.Method.error);
        XwebUtil.forward(wcbArg, path);
        XwebMailHelper.getInstance().addMailToWebMaster(wcbArg.getSiteContext(), "Error", BcLogUtil.convertMessage(throwable));
    }

    public boolean isThrowableLoop(HtsvArgument wcbArg, Throwable throwable) throws Exception {
        Throwable throwablePre = (Throwable)wcbArg.getRequest().getAttribute(WbfwConstants.RequestAttributeKey.throwable.name());
        if (throwablePre == null) {
            return false;
        }
        this.getLogger().error("========== \u4f8b\u5916\u30eb\u30fc\u30d7 ==========\u3011");
        this.getLogger().error(BcLogUtil.convertMessage(throwable));
        String content = BcLogUtil.convertMessage(throwable);
        StringBuilder html = new StringBuilder(WbxConstants.htmlTemplateSimple);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.headTitle.value, "\u4f8b\u5916\u30eb\u30fc\u30d7");
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, content);
        WbfwUtil.outputHtml(wcbArg, html.toString());
        XwebMailHelper.getInstance().addMailToWebMaster(wcbArg.getSiteContext(), "\u4f8b\u5916\u30eb\u30fc\u30d7", content.toString());
        return true;
    }

    @Override
    protected void defaultPage(HtsvArgument wcbArg) throws Exception {
        File file = WbfwUtil.getFile(wcbArg, "index.html");
        this.fileOutput(wcbArg, file);
    }

    protected void imageProc(HtsvArgument wcbArg, ImageMenu imageMenu) throws Exception {
        this.getLogger().debug("imageProc:imageMenu=" + imageMenu);
        Object wcbInstance = BcSharedObjectManager.getInstance().get(imageMenu.name());
        this.getLogger().debug("#1 wcbInstance=" + wcbInstance);
        if (wcbInstance == null) {
            if (imageMenu.equals(ImageMenu.image1)) {
                InnerImageWCB imageWCB = new InnerImageWCB();
                imageWCB.setHeadTitle(imageMenu.headTitle);
                wcbInstance = imageWCB;
            } else if (imageMenu.equals(ImageMenu.gomatachi)) {
                X_Wbs1ImageListWCB imageWCB = new X_Wbs1ImageListWCB();
                String tmpPath = AfbApplication.getInstance().toReal("${APP}data/" + imageMenu.subDir);
                imageWCB.setHeadTitle(imageMenu.headTitle);
                imageWCB.setDir(new File(tmpPath));
                wcbInstance = imageWCB;
            }
            BcSharedObjectManager.getInstance().put(imageMenu.name(), wcbInstance);
        }
        this.getLogger().debug("#2 wcbInstance=" + wcbInstance);
        WbfwUtil.invoke(wcbInstance, X_Wbs1ImageListWCB.Method.imageList.name(), wcbArg);
    }

    public static enum ImageMenu implements WbxPath
    {
        image1("image1", "\u753b\u50cf\uff11", "image1"),
        gomatachi("gomatachi", "\u30b4\u30de\u9054", "gomatachi");

        public final String path;
        public final String headTitle;
        public final String subDir;

        private ImageMenu(String path, String headTitle, String subDir) {
            this.path = XwebUtil.createPath(this, path);
            this.headTitle = headTitle;
            this.subDir = subDir;
        }

        @Override
        public String getClassName() {
            return XwebMainServlet.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

