/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlTagAttribute;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.mmdx.common.MmdxUtil;
import jp.co.extreme.module.mmdx.model.YwebFieldContext;
import jp.co.extreme.module.mmdx.model.YwebFieldPack;
import jp.co.extreme.module.xsys.validation.XsysFieldKeyCreator;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.XwebLabelAndInputBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class WbsFiledHtmlCreator
extends BcLoggableObject {
    private HtmlBuilder htmlBuilder;
    XwebLabelAndInputBuilder labelAndInputBuilder = new XwebLabelAndInputBuilder();
    String style = "display:flex; justify-content: left;";
    public String errorColorCode;

    public WbsFiledHtmlCreator(HtmlBuilder htmlBuilder) {
        this.errorColorCode = HtmlConstants.HtmlColor.tomato.code;
        this.setHtmlBuilder(htmlBuilder);
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public String create(YwebFieldPack fieldPack, XsysValidationResult validationResult) throws Exception {
        StringBuilder sb1 = new StringBuilder();
        String msg = XwebUtil.createMsg(validationResult);
        if (!BcStringUtil.isEmpty(msg)) {
            sb1.append(MdlCreator.getInstance().card_supporting_text(msg, this.errorColorCode, null));
        }
        int i = 0;
        while (i < fieldPack.groupList.size()) {
            List<YwebFieldContext> fieldContextList = fieldPack.groupList.get(i);
            if (fieldContextList != null) {
                String sb2 = this.create_L2(fieldContextList, validationResult);
                sb1.append(sb2);
                sb1.append(this.getHtmlBuilder().lineSep);
            }
            ++i;
        }
        return sb1.toString();
    }

    public String create(Object entity, String entityName, XsysValidationResult validationResult) throws Exception {
        YwebFieldPack fieldPack = MmdxUtil.creatFieldPack(entity.getClass(), entity, entityName);
        return this.create(fieldPack, validationResult);
    }

    public String create(Object entity, XsysValidationResult validationResult) throws Exception {
        return this.create(entity, entity.getClass().getSimpleName(), validationResult);
    }

    protected String create_L2(Collection<YwebFieldContext> fieldContextCollection, XsysValidationResult validationResult) throws Exception {
        StringBuilder sb1 = new StringBuilder();
        for (YwebFieldContext fieldContext : fieldContextCollection) {
            String str = this.create_L3(fieldContext.entity, fieldContext.entityName, validationResult, fieldContext.field, fieldContext.mmdField);
            sb1.append(str);
            sb1.append(this.getHtmlBuilder().lineSep);
        }
        return sb1.toString();
    }

    protected String create_L3(Object entity, String entityName, XsysValidationResult validationResult, Field field, MmdField mmdField) throws Exception {
        StringBuilder sb1 = new StringBuilder();
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            Object array = field.get(entity);
            if (array == null) {
                this.getLogger().warning("\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u914d\u5217\u578b\u3067NULL\u306e\u305f\u3081\u51e6\u7406\u3057\u307e\u305b\u3093\u3002\u30d5\u30a3\u30fc\u30eb\u30c9=" + BcReflectUtil.toClassFieldName(field));
                return sb1.toString();
            }
            int arrayLength = Array.getLength(array);
            int i = 0;
            while (i < arrayLength) {
                if (this.isEnabled(field, mmdField, i)) {
                    String sb2 = this.createFiledHtml(entity, entityName, validationResult, field, mmdField, i);
                    sb1.append(sb2);
                    sb1.append(this.getHtmlBuilder().lineSep);
                }
                ++i;
            }
        } else if (this.isEnabled(field, mmdField, -1)) {
            String sb2 = this.createFiledHtml(entity, entityName, validationResult, field, mmdField, -1);
            sb1.append(sb2);
            sb1.append(this.getHtmlBuilder().lineSep);
        }
        return sb1.toString();
    }

    protected boolean isEnabled(Field field, MmdField mmdField, int arrayIndex) throws Exception {
        return mmdField.enabled;
    }

    protected String createFiledHtml(Object entity, String entityName, XsysValidationResult validationResult, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        String inputName = XsysFieldKeyCreator.getInstance().createKey(arrayIndex, entityName, mmdField.fieldName);
        String strValue = this.toStringValue(entity, field, mmdField, arrayIndex);
        if (HtmlConstants.HtmlInputType.hidden.name().equalsIgnoreCase(mmdField.inputType)) {
            return this.getHtmlBuilder().hidden(inputName, strValue);
        }
        List errMsgList = XwebUtil.getFieldErrorMsg(validationResult, inputName);
        boolean required = this.isRequired(entity, field, mmdField, arrayIndex);
        boolean disabled = this.isSubmitDisabled(entity, field, mmdField, arrayIndex);
        boolean readonly = this.isReadonly(entity, field, mmdField, arrayIndex);
        boolean characterCounterEnabled = this.characterCounterEnabled(entity, field, mmdField, arrayIndex);
        String label = MmdUtil.getProvisionalHeaderValue(mmdField);
        String script = null;
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = null;
        if (field.getName().equals("sexCode")) {
            sb2 = XwebUtil.createSexSelection(inputName, strValue, false);
            sb1.append((CharSequence)sb2);
            if (required) {
                sb1.append(XwebUtil.getRequiredBox("0.8rem", "\u5fc5\u9808"));
            }
            sb1.append(this.getHtmlBuilder().br());
        } else if (BcBooleanUtil.isBoolean(field.getType())) {
            Object value = this.getFieldValue(entity, field, mmdField, arrayIndex);
            String errMsg = HtmlUtil.encode(errMsgList);
            String checkbox = this.createCheckBox(inputName, mmdField.columnCount, disabled, readonly, label, strValue, field.getType(), required, mmdField.inputPattern, mmdField.placeholder, mmdField.inputDescription, script, errMsg, mmdField.autocomplete, characterCounterEnabled);
            sb1.append(checkbox);
        } else if (HtmlConstants.HtmlTag.select.name().equals(mmdField.inputType)) {
            String errMsg = HtmlUtil.encode(errMsgList);
            sb1.append(this.labelAndInputBuilder.createSelect(inputName, disabled, readonly, label, strValue, required, mmdField.inputDescription, script, errMsg, mmdField.options));
        } else {
            String labelAndTextField = this.labelAndTextField(inputName, entity, field, mmdField, strValue, errMsgList, arrayIndex, required, disabled, readonly, characterCounterEnabled);
            sb1.append(labelAndTextField);
        }
        sb1.append((CharSequence)this.htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        return sb1.toString();
    }

    protected String labelAndTextField(String inputName, Object entity, Field field, MmdField mmdField, String value, Collection errMsgCollection, int arrayIndex, boolean required, boolean disabled, boolean readonly, boolean characterCounterEnabled) throws Exception {
        HtmlConstants.HtmlInputType inputType = HtmlConstants.HtmlInputType.getByValue(mmdField.inputType);
        if (inputType == null) {
            inputType = HtmlConstants.HtmlInputType.text;
        }
        String script = null;
        String label = this.getLabelText(entity, field, mmdField, arrayIndex);
        String errMsg = HtmlUtil.encode(errMsgCollection);
        return this.labelAndInputBuilder.create(inputType, inputName, mmdField.columnCount, mmdField.fieldDisplay.rowCount, disabled, readonly, label, value, required, mmdField.inputPattern, mmdField.placeholder, mmdField.inputDescription, script, errMsg, mmdField.autocomplete, characterCounterEnabled, mmdField.options);
    }

    protected Object getFieldValue(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        Object value = null;
        if (arrayIndex >= 0) {
            Object array = field.get(entity);
            value = Array.get(array, arrayIndex);
        } else {
            value = BcReflectUtil.getFieldValue(field, entity);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String toStringValue(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        Object value = this.getFieldValue(entity, field, mmdField, arrayIndex);
        if (value == null) {
            return null;
        }
        String strValue = null;
        if (!HtmlConstants.HtmlInputType.date.name().equalsIgnoreCase(mmdField.inputType)) return BcStringUtil.toString(value);
        Class<?> fieldType = field.getType();
        if (!fieldType.equals(Integer.TYPE)) throw new Exception("Not supported. type=" + fieldType.getName());
        Integer yyyyMMdd = (Integer)value;
        return BcTimeUtil.toString(yyyyMMdd, "yyyy-MM-dd");
    }

    protected String getLabelText(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(MmdUtil.getProvisionalHeaderValue(mmdField));
        if (arrayIndex >= 0) {
            sb.append(XsysFieldKeyCreator.getInstance().createArrayIndex(arrayIndex));
        }
        return sb.toString();
    }

    protected boolean isRequired(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        return mmdField.required;
    }

    protected boolean isSubmitDisabled(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        return mmdField.submitDisabled;
    }

    protected boolean isReadonly(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        return mmdField.readonly;
    }

    protected boolean characterCounterEnabled(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
        return mmdField.characterCounter;
    }

    protected XwebLabelAndInputBuilder getInputBuilder() throws Exception {
        return this.labelAndInputBuilder;
    }

    public String createCheckBox(String inputName, int columnCount, boolean disabled, boolean readonly, String label, Object value, Class valueClass, boolean required, String pattern, String placeholder, String helperText, String script, String errMsg, String autocomplete, boolean characterCounterEnabled) throws Exception {
        String helperTextDiv;
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = XwebUtil.toEmenetId(inputName);
        List<HtmlTagAttribute> tagAttributeList1 = this.getHtmlBuilder().toAttributeList(globalAttribute);
        boolean multiple = false;
        String list = XwebUtil.toDataListId(inputName);
        List<HtmlTagAttribute> tagAttributeList2 = this.getHtmlBuilder().toInputAttributeList(HtmlConstants.HtmlInputType.checkbox.name(), inputName, value, columnCount, columnCount, disabled, readonly, multiple, pattern, placeholder, list, autocomplete);
        tagAttributeList1.addAll(tagAttributeList2);
        String helperTextId = String.valueOf(globalAttribute.id) + "__helperText";
        tagAttributeList1.add(new HtmlTagAttribute("aria-controls", helperTextId));
        tagAttributeList1.add(new HtmlTagAttribute("aria-describedby", helperTextId));
        tagAttributeList1.add(new HtmlTagAttribute("autocapitalize", "off"));
        Object value2 = null;
        boolean checked = false;
        if (!Boolean.class.isAssignableFrom(valueClass)) {
            String msg = "Not Supported valueClass. " + valueClass.getName();
            throw new Exception(msg);
        }
        checked = BcBooleanUtil.isTrue(value);
        String inputTag = MdlCreator.getInstance().checkBox(inputName, value2, checked, inputName, label).toString();
        sb.append(inputTag);
        if (!readonly && !BcStringUtil.isEmpty(helperTextDiv = this.labelAndInputBuilder.createHelperTextDiv(helperTextId, helperText, errMsg, characterCounterEnabled))) {
            sb.append(helperTextDiv);
        }
        sb.append(this.getHtmlBuilder().lineSep);
        return sb.toString();
    }
}

