/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.html.util.EtcHtmlUtil;
import jp.co.extreme.module.xweb.common.HtmlTableModel;

public class HtmlTableModelForResultSet
extends BcLoggableObject
implements HtmlTableModel {
    private List<MmdField> mmdFieldList;
    private ResultSet rs;
    private Integer rowCount;
    private Map<Integer, List> rowMap = new HashMap<Integer, List>();

    @Override
    public int getColumnCount() throws Exception {
        return this.getMmdFieldList().size();
    }

    @Override
    public int getRowCount() throws Exception {
        return this.rowCount;
    }

    @Override
    public String getHeaderValue(int columnId) throws Exception {
        MmdField mmdField = this.getMmdFieldList().get(columnId);
        String headerValue1 = MmdUtil.getProvisionalHeaderValue(mmdField);
        List<String> strList = EtcHtmlUtil.toStringList(headerValue1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strList.size()) {
            String str = strList.get(i);
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getCellValue(int rowId, int columnId) throws Exception {
        ArrayList<Object> row = this.rowMap.get(rowId);
        if (row == null) {
            row = new ArrayList<Object>();
            int columnIndex = columnId + 1;
            int i = 0;
            while (i < this.getColumnCount()) {
                Object value = this.getResultSet().getObject(columnIndex);
                row.add(value);
                ++i;
            }
            this.rowMap.put(rowId, row);
        }
        Object value = row.get(columnId);
        return BcStringUtil.toString(value);
    }

    @Override
    public String getWidth(int columnId) throws Exception {
        MmdField mmdField = this.getMmdFieldList().get(columnId);
        String headerValue = MmdUtil.getProvisionalHeaderValue(mmdField);
        String width = null;
        if (!BcStringUtil.isEmpty(headerValue)) {
            int max = 0;
            List<String> strList = EtcHtmlUtil.toStringList(headerValue);
            int i = 0;
            while (i < strList.size()) {
                String str = strList.get(i);
                max = Math.max(max, str.length());
                ++i;
            }
            width = String.valueOf(max) + "em";
        }
        return width;
    }

    public List<MmdField> getMmdFieldList() {
        return this.mmdFieldList;
    }

    public void setMmdFieldList(List<MmdField> mmdFieldList) {
        this.mmdFieldList = mmdFieldList;
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public void setResultSet(ResultSet rs) throws Exception {
        this.rs = rs;
        int rowId = -1;
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            int i = 0;
            while (i < this.getColumnCount()) {
                int columnIndex = i + 1;
                Object value = this.getResultSet().getObject(columnIndex);
                row.add(value);
                ++i;
            }
            this.rowMap.put(++rowId, row);
        }
        this.rowCount = rowId + 1;
    }
}

