/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.fx;

import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbApplicationContext;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.base.util.BcLocaleUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.fx.extension.FxxAbstractDesktopPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.scf4.fx.HfxClientUtil;
import jp.co.extreme.scf6.fx.JfxAboutPane;
import org.w3c.dom.Document;

public abstract class XsysAbstractDesktopPane
extends FxxAbstractDesktopPane {
    protected MenuItem englishMenuItem = new MenuItem(BcISO.ISO_639.English.name());
    protected MenuItem japaneseMenuItem = new MenuItem(BcISO.ISO_639.Japanese.name());

    @Override
    protected Menu createWindowMenu() throws Exception {
        Menu menu = super.createWindowMenu();
        Menu languageMenu = new Menu(BcWords.getInstance().language);
        menu.getItems().add((Object)languageMenu);
        this.englishMenuItem.setOnAction(this.actionEventHandler);
        this.englishMenuItem.setGraphic((Node)FxImageHelper.createImageView_icon("flag_united_kingdom_64x64.png"));
        this.englishMenuItem.setDisable(BcLocaleUtil.getIso639() == BcISO.ISO_639.English);
        languageMenu.getItems().add((Object)this.englishMenuItem);
        this.japaneseMenuItem.setOnAction(this.actionEventHandler);
        this.japaneseMenuItem.setGraphic((Node)FxImageHelper.createImageView_icon("flag_japan_64x64.png"));
        this.japaneseMenuItem.setDisable(BcLocaleUtil.getIso639() == BcISO.ISO_639.Japanese);
        languageMenu.getItems().add((Object)this.japaneseMenuItem);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.englishMenuItem) {
            this.setLangage(BcISO.ISO_639.English.code);
        } else if (ev.getSource() == this.japaneseMenuItem) {
            this.setLangage(BcISO.ISO_639.Japanese.code);
        }
    }

    public void setLangage(String langageCode) throws Exception {
        Document generalConfig = AfbApplication.getInstance().getGeneralConfig();
        BcXmlUtil.setTextValue(generalConfig.getDocumentElement(), "langageCode", langageCode);
        AfbApplication.getInstance().updateGeneralConfig(generalConfig);
        String msg = String.valueOf(BcWords.getInstance().Changed_language) + "\n" + BcWords.getInstance().It_takes_effect_after_restarting_the_system;
        FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().information, 1);
    }

    @Override
    public void aboutAction() throws Exception {
        JfxAboutPane aboutPane = new JfxAboutPane();
        aboutPane.show((Window)this.stage);
    }

    @Override
    public void exitAction() throws Exception {
        if (HfxClientUtil.confirmExit((Window)this.stage)) {
            this.stage.close();
        }
    }

    protected void setOnShown() {
    }

    public void show() throws Exception {
        if (this.stage != null) {
            this.stage.show();
            this.stage.toFront();
            return;
        }
        this.init();
        this.createStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                XsysAbstractDesktopPane.this.setOnShown();
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                if (!HfxClientUtil.confirmExit((Window)XsysAbstractDesktopPane.this.stage)) {
                    ev.consume();
                }
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                AfbApplication.getInstance().exit();
            }
        });
        this.stage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> prop, Boolean oldValue, Boolean newValue) {
            }
        });
        ReadOnlyBooleanProperty fullScreenProperty = this.stage.fullScreenProperty();
        fullScreenProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isFullScreen) {
                isFullScreen.booleanValue();
            }
        });
        this.stage.setResizable(false);
        AfbApplicationContext applicationContext = AfbApplication.getInstance().getApplicationContext();
        this.stage.setTitle(applicationContext.appName);
        FxImageHelper.setStageIcon(this.stage);
        this.setWindowLocation((Window)this.stage);
        this.stage.show();
    }

    protected abstract void setWindowLocation(Window var1) throws Exception;
}

