/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.common;

import java.util.Date;
import java.util.Optional;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbLogUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class XsysConstants {
    public static final String DB_user = "xsys_admin";
    public static final String DB_password = "ex4rhk8x";
    public static final String DB_name = "main";
    public static final String FP_dbPath = "${APP}data/main";
    public static final int SCHEMA_VERSION = 6;
    public static final boolean MODELR = false;
    public static final boolean TASK = false;
    public static final boolean DOWNLOAD = false;
    public static final String MDPK_type = "type";

    private XsysConstants() {
    }

    public static void setWorkbookProperties(XSSFWorkbook workbook, Date date, String creator, String title) throws Exception {
        POIXMLProperties xmlProps = workbook.getProperties();
        POIXMLProperties.CoreProperties coreProps = xmlProps.getCoreProperties();
        Optional<Date> optionalDate = Optional.of(date);
        coreProps.setCreated(optionalDate);
        coreProps.setCreator(creator);
        coreProps.setTitle(title);
    }

    public static void setWorkbookProperties(HSSFWorkbook workbook, Date date, String creator, String title) throws Exception {
        SummaryInformation summaryInformation = workbook.getSummaryInformation();
        summaryInformation.setCreateDateTime(date);
        summaryInformation.setAuthor(creator);
        summaryInformation.setTitle(title);
    }

    public static void setWorkbookProperties(Workbook workbook, String title) throws Exception {
        Date date = BcTimeUtil.createCalendar().getTime();
        AfbApplication application = AfbApplication.getInstance();
        String creator = AfbLogUtil.appNameAndVersion(application.getApplicationContext());
        if (workbook instanceof XSSFWorkbook) {
            XsysConstants.setWorkbookProperties((XSSFWorkbook)workbook, date, creator, title);
        } else if (workbook instanceof HSSFWorkbook) {
            XsysConstants.setWorkbookProperties((XSSFWorkbook)workbook, date, creator, title);
        }
    }

    public static enum AppArg {
        if1("-if1"),
        if2("-if2"),
        of1("-of1"),
        of2("-of2"),
        workbook1("-workbook1"),
        workbook2("-workbook2"),
        comment("-comment"),
        help("-help"),
        h("-h"),
        questionMark("-?");

        public final String value;

        private AppArg(String value) {
            this.value = value;
        }
    }

    public static enum AppType {
        DatabaseClient("rydeen"),
        MovieFiler("movie_filer"),
        CsvDiffex("csv_diffex");

        public final String appType;

        private AppType(String appType) {
            this.appType = appType;
        }
    }
}

