/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.effect.Effect;
import javafx.scene.layout.StackPane;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.etc.util.EtcEventHandlerManager;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.fx.XsodClientUtil;
import jp.co.extreme.module.xsod.fx.XsodController;
import jp.co.extreme.module.xsod.fx.XsodEventHandler;
import jp.co.extreme.module.xsod.fx.XsodMenuElementPane;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodMenuData;
import jp.co.extreme.module.xsod.model.XsodMerchandisePack;

public class XsodMenuDetailPane
extends FxBorderPane
implements XsodEventHandler {
    FxFlowPane flowPane = new FxFlowPane(21);
    List<String> merchandiseCodeList;

    public XsodMenuDetailPane() throws Exception {
        this.initComponent();
        EtcEventHandlerManager.getInstance().addEventHandler(XsodEventHandler.class, this);
    }

    protected void initComponent() throws Exception {
        StackPane stackPane2 = new StackPane();
        stackPane2.getChildren().addAll((Object[])new Node[]{this.flowPane});
        this.setCenter((Node)stackPane2);
    }

    public void setMerchandiseCodeList(List<String> merchandiseCodeList) throws Exception {
        this.merchandiseCodeList = merchandiseCodeList;
        this.flowPane.removeAll();
        String langCode = XsodController.getInstance().langCode;
        XsodMenuData menuData = XsodController.getInstance().getMenuData();
        int i = 0;
        while (i < merchandiseCodeList.size()) {
            String merchandiseCode = merchandiseCodeList.get(i);
            BcLogUtil.debug("merchandiseCode=" + merchandiseCode);
            XsodMerchandisePack merchandisePack = menuData.merchandiseMap.get(merchandiseCode);
            BcLogUtil.debug("merchandisePack=" + merchandisePack);
            if (merchandisePack == null) {
                XsodUtil.warn("merchandiseCode=" + merchandiseCode + " merchandisePack=" + merchandisePack);
            } else {
                int imageId = i + 1;
                Button button = new Button();
                button.setOnAction(this.actionEventHandler);
                button.setUserData((Object)merchandisePack);
                XsodMenuElementPane menuElementPane = new XsodMenuElementPane();
                menuElementPane.setData(merchandisePack, XsodUiFactory.getInstance().menuDetailWidth, XsodUiFactory.getInstance().menuDetailHeight, langCode);
                button.setGraphic((Node)menuElementPane);
                button.setGraphicTextGap(0.0);
                button.setEffect((Effect)FxEffectUtil.createDropShadow());
                button.setPrefWidth(XsodUiFactory.getInstance().menuDetailWidth);
                button.setPrefHeight(XsodUiFactory.getInstance().menuDetailHeight);
                FxNodeUnit nodeUnit = new FxNodeUnit((Node)button, new Node[0]);
                this.flowPane.addNodeUnit(nodeUnit);
            }
            ++i;
        }
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        XsodClientUtil.playAudio();
        if (ev.getSource() instanceof Node) {
            Node node = (Node)ev.getSource();
            XsodMerchandisePack merchandisePack = (XsodMerchandisePack)node.getUserData();
            XsodController.getInstance().merchandiseSelected(merchandisePack.merchandise.code);
        }
    }

    @Override
    public void langChanged(String langCode) throws Exception {
        this.setMerchandiseCodeList(this.merchandiseCodeList);
    }
}

