/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.swg;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.module.xfil.common.HashtagUtil;
import jp.co.extreme.module.xfil.common.XfilTagUtil;
import jp.co.extreme.module.xfil.stub.XfilUriEntityStub;
import jp.co.extreme.swing.SwgTableCellEditor;

class XfilTagCellEditor
extends SwgTableCellEditor {
    int columnId_entityId;

    @Override
    public Component getTableCellEditorComponent(JTable tableView, Object value, boolean isSelected, int rowIndex, int columnIndex) {
        try {
            value = XfilTagUtil.temp(BcStringUtil.toString(value));
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return super.getTableCellEditorComponent(tableView, value, isSelected, rowIndex, columnIndex);
    }

    @Override
    public Object getCellEditorValue() {
        String res = null;
        try {
            Object tmpValue = super.getCellEditorValue();
            String tmpStr = BcStringUtil.toStringNotNull(tmpValue);
            BcLogUtil.debug("getCellEditorValue:tmpValue=" + tmpValue + " tmpStr=" + tmpStr);
            List<String> valueList1 = BcCsvUtil.parseCsvRow(tmpStr, true);
            ArrayList<String> valueList2 = new ArrayList<String>();
            for (String value1 : valueList1) {
                String value2 = HashtagUtil.getInstance().removeNotAllowedCharacter(value1);
                if (BcStringUtil.isEmpty(value2)) continue;
                valueList2.add(value2);
            }
            res = XfilTagUtil.toPersistenceString(valueList2);
            try {
                BcTableModel tableModel = (BcTableModel)this.tableView.getModel();
                long entityId = (Long)tableModel.getValueAt(this.rowIndex, this.columnId_entityId);
                XfilUriEntityStub.getInstance().update(entityId, res);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return res;
    }
}

