/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.httpserver;

import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.httpserver.HtsvUrlParameterMap;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwConstants;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1RecruitmentListWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ShopDataHelper;
import jp.co.extreme.module.wbs1.wcb.Wbs1ShopWCB;
import jp.co.extreme.module.xdts.wcb.XdsDataViewUtil;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlUtil2;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebPaginationBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;

public class XfilFileListWCB
extends Wbs1AbstractWCB {
    @Override
    protected String createHeadStyle(HtsvArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.append(sb, super.createHeadStyle(wcbArg));
        sb.append("\n\n.mdl-layout__content {\nposition: relative;\nbackground-size:cover;\nbackground-image: url(images/main_bg.jpg);\n}");
        return sb.toString();
    }

    public void form(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            StringBuilder content = this.form_L2(wcbArg, dtsSessionSite);
            StringBuilder sb = this.getBaseHtml(wcbArg);
            String headTitle = "\u30ad\u30e3\u30d0\u30af\u30e9\u691c\u7d22";
            String metaDescription = "\u30ad\u30e3\u30d0\u30af\u30e9\u3001\u30ac\u30fc\u30eb\u30ba\u30d0\u30fc\u3001\u30af\u30e9\u30d6\u3001\u30b9\u30ca\u30c3\u30af\u3092\u3054\u7d39\u4ecb\u3002";
            HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
            String area = requestParameter.getAsString("area");
            if (!BcStringUtil.isEmpty(area)) {
                headTitle = String.valueOf(headTitle) + " : " + area;
                metaDescription = String.valueOf(area) + "\u306e" + metaDescription;
            }
            sb = this.replace(wcbArg, headTitle, metaDescription, sb);
            sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
            WbfwUtil.outputHtml(wcbArg, sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected StringBuilder form_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        HtsvUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        WbsJudgementCondition judgementCondition = null;
        WbsTempCondition tempCondition = null;
        if (tokenContext.validationResult == null) {
            tokenContext.validationResult = new XsysValidationResult();
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            XwebUtil.putToMap(tokenContext.map, urlParam);
            judgementCondition = new WbsJudgementCondition();
            XwebUtil.putToMap(tokenContext.map, judgementCondition);
            tempCondition = new WbsTempCondition();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, tempCondition);
            XwebUtil.putToMap(tokenContext.map, tempCondition);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            judgementCondition = (WbsJudgementCondition)XwebUtil.getMapValue(tokenContext.map, WbsJudgementCondition.class);
            tempCondition = (WbsTempCondition)XwebUtil.getMapValue(tokenContext.map, WbsTempCondition.class);
        }
        EtcPagination pagination = XwebUtil.cretaePagination(wcbArg);
        if (pagination.getPageNumReq() <= 0) {
            WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, tempCondition);
        }
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgementCondition);
        this.getLogger().debug("tempCondition.area=" + tempCondition.area);
        StringBuilder sb = new StringBuilder();
        int contentColumn = 10;
        sb.append((CharSequence)MdlCreator.getInstance().div_grid_cell_start(contentColumn));
        String title = Wbs1Words.getInstance().shopList;
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            title = String.valueOf(title) + ":" + urlParam.mode;
        }
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().h(3, title, "headline1"));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(this.createConditionForm(wcbArg, tokenContext, dtsSessionSite, Method.form.path, urlParam, judgementCondition, tempCondition));
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(this.createDetailList(wcbArg, tokenContext, pagination, dtsSessionSite, urlParam, judgementCondition, tempCondition));
        sb.append(this.getHtmlBuilder().div_end());
        MdlCreator mdlCreator = MdlCreator.getInstance();
        MdlCreator.getInstance();
        sb.append((CharSequence)mdlCreator.div_grid_cell_start(12 - contentColumn));
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1RecruitmentListWCB.Method.form);
        sb.append(this.getHtmlBuilder().div_end());
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        return sb;
    }

    protected String createConditionForm(HtsvArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, String url, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createConditionForm_L2(wcbArg, tokenContext, dtsSessionSite, urlParam, judgementCondition, tempCondition));
        String formName = "form1";
        StringBuilder controls = new StringBuilder();
        String onclickAction = WbfJslUtil.submit2(formName, url);
        String searchButton = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().search, onclickAction);
        controls.append(searchButton);
        sb.append((CharSequence)this.getHtmlBuilder().div(controls.toString(), HtmlConstants.HtmlAlign.center, -1));
        sb.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        sb = HtmlUtil2.form(formName, sb.toString());
        return sb.toString();
    }

    protected String createConditionForm_L2(HtsvArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            sb.append(XwebJudgementUtil.createJudgementCondition(this.getHtmlBuilder(), judgementCondition.judgementStatusId));
        } else {
            if (tempCondition != null) {
                if (BcStringUtil.isEmpty(tempCondition.area) && tokenContext.cnt <= 1L) {
                    HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
                    String area = requestParameter.getAsString("area");
                    tempCondition.area = !BcStringUtil.isEmpty(area) ? area : "\u6e0b\u8c37";
                }
                List<String> areaList = Wbs1ShopDataHelper.getInstance().getAreaList(dtsSessionSite);
                sb.append(XdsDataViewUtil.createCondition(this.getHtmlBuilder(), WbsTempCondition.FieldName.area.fieldName, areaList, null, tempCondition.area, "\u3010\u5730\u57df\u3011"));
                String[] strArray = new String[]{"\u30ad\u30e3\u30d0\u30af\u30e9", "\u30ac\u30fc\u30eb\u30ba\u30d0\u30fc", "\u30af\u30e9\u30d6", "\u30b9\u30ca\u30c3\u30af", "\u671d\u30ad\u30e3\u30d0\u30fb\u663c\u30ad\u30e3\u30d0", "\u30d0\u30fc", "\u30b3\u30f3\u30bb\u30d7\u30c8\u30ab\u30d5\u30a7"};
                List<String> businessTypeList = Arrays.asList(strArray);
                sb.append(XdsDataViewUtil.createCondition(this.getHtmlBuilder(), WbsTempCondition.FieldName.businessType.fieldName, businessTypeList, null, tempCondition.businessType, "\u3010" + Wbs1Words.getInstance().\u696d\u614b + "\u3011"));
            }
            if (urlParam != null) {
                String[] strArray = new String[]{"\u30d5\u30ed\u30a2\u30ec\u30c7\u30a3", "\u30ab\u30a6\u30f3\u30bf\u30fc\u30ec\u30c7\u30a3", "\u30c1\u30fc\u30de\u30de", "\u30a6\u30a8\u30a4\u30c8\u30ec\u30b9", "\u30d0\u30fc\u30c6\u30f3\u30c0\u30fc", "\u30db\u30fc\u30eb\u30b9\u30bf\u30c3\u30d5"};
                List<String> occupationList = Arrays.asList(strArray);
                sb.append(XdsDataViewUtil.createCondition(this.getHtmlBuilder(), WbsTempCondition.FieldName.occupation.fieldName, occupationList, null, tempCondition.occupation, "\u3010" + Wbs1Words.getInstance().\u8077\u7a2e + "\u3011"));
            }
        }
        return sb.toString();
    }

    protected String createDetailList(HtsvArgument wcbArg, WbxTokenContext tokenContext, EtcPagination pagination, DtsSession dtsSessionSite, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        XfilUriEntityDAO dao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
        DtsSessionFactory dtsSessionFactoryWk = DtsSessionFactoryManegaer.getInstance().getSessionFactory("movie_filer");
        DtsSession dtsSessionWk = dtsSessionFactoryWk.createSession(this);
        List entityList = dao.getListByName(dtsSessionWk, -1L, null, true);
        this.getLogger().info("entityList.size()=" + entityList.size());
        pagination.setDataCount(entityList.size());
        List entityList2 = pagination.newList(entityList);
        StringBuilder sb = new StringBuilder();
        InnerPaginationBuilder paginationBuilder = new InnerPaginationBuilder();
        paginationBuilder.tokenContext = tokenContext;
        sb.append((CharSequence)paginationBuilder.create(wcbArg, pagination));
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        int i = 0;
        while (i < entityList2.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)entityList2.get(i);
            sb.append(this.createDetailCell(wcbArg, urlParam, uriEntity));
            sb.append("\n\n");
            ++i;
        }
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)paginationBuilder.create(wcbArg, pagination));
        return sb.toString();
    }

    protected String createDetailCell(HtsvArgument wcbArg, WbsUrlParam tempCondition, XfilUriEntity uriEntity) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_06rem.className));
        String param1 = WbfwUtil.createParameter("shopId", (Object)Long.toString(uriEntity.id));
        String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ShopWCB.Method.view)) + WbfwUtil.createUrlQuery(param1);
        String onclickAction = WbfJslUtil.locationHref(href);
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_button_box.className, ExtwCssUtil.ExtwClass.extw_hover_opacity.className);
        String buttonStart = this.getHtmlBuilder().button_start(globalAttribute, HtmlConstants.HtmlButtonType.button, null, null, false, onclickAction).toString();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_row_wrap.className, ExtwCssUtil.ExtwClass.extw_flex_baseline.className));
        sb.append(this.getHtmlBuilder().h(3, uriEntity.name));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        globalAttribute = new HtmlGlobalAttribute();
        this.getHtmlBuilder().video(globalAttribute, 0.0, 0.0);
        sb.append(this.getHtmlBuilder().div_end());
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(buttonStart);
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        WbfwConstants.TerminalType terminalType = XwebUtil.getTerminalType(wcbArg);
        sb.append(this.getHtmlBuilder().button_end());
        if (Wbs1Constants.OperationMode.administrator.name().equals(tempCondition.mode)) {
            WbsUrlParam urlParam = new WbsUrlParam();
            urlParam.mode = Wbs1Constants.OperationMode.administrator.name();
            urlParam.param1 = Long.toString(uriEntity.id);
            HtsvUrlParameterMap paramMap = WbxParameterUtil.getInstance().createParamMap(urlParam);
            String param2 = WbfwUtil.createEncryptQuery(paramMap);
            href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ShopWCB.Method.form)) + WbfwUtil.createUrlQuery(param2);
            onclickAction = WbfJslUtil.locationHref(href);
            String button = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().edit, onclickAction);
            sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
            sb.append(button);
            sb.append(this.getHtmlBuilder().lineSep);
        }
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    class InnerPaginationBuilder
    extends XwebPaginationBuilder {
        WbxTokenContext tokenContext;
        String area1;

        InnerPaginationBuilder() {
        }

        @Override
        protected String createHref(HtsvArgument wcbArg, int pageNo) throws Exception {
            String param1 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.token.name(), (Object)XwebUtil.createTokenString(this.tokenContext));
            String param2 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.page.name(), (Object)Integer.toString(pageNo));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1, param2);
            return href;
        }
    }

    public static enum Method implements WbxPath
    {
        form("file");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return XfilFileListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

