/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.etc.util.EtcAbstractConditionSet;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.module.ffmpeg.FfmpegUtil;
import jp.co.extreme.module.xfil.common.XfilCaptureUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.HorizontalPositionComboBox;
import jp.co.extreme.module.xfil.fx.ResolutionComboBox;
import jp.co.extreme.module.xfil.fx.VerticalPositionComboBox;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureCondition;

public class XfilCaptureConditionSet
extends EtcAbstractConditionSet {
    ResolutionComboBox resolutionComboBox = new ResolutionComboBox();
    public FxNodeUnit resolutionUnit;
    FxNumberField capturingWidthField = new FxNumberField();
    FxNumberField capturingHeightField;
    FxNumberField intervalField;
    public FxNodeUnit intervalUnit;
    FxNumberField headMarginField;
    public FxNodeUnit headMarginUnit;
    FxNumberField tailMarginField;
    public FxNodeUnit tailMarginUnit;
    FxNumberField capturingCountMaxField;
    public FxNodeUnit capturingCountMaxUnit;
    FxCheckBox elapsedTimeCheckBox;
    HorizontalPositionComboBox elapsedTimeHorizontalPositionComboBox;
    VerticalPositionComboBox elapsedTimeVerticalPositionComboBox;
    public FxNodeUnit elapsedTimeUnit;

    public XfilCaptureConditionSet() throws Exception {
        this.capturingWidthField.setPrefColumnCount(4);
        FxNodeUnit capturingWidthUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(BcWords.getInstance().width) + "(px)"), new Node[]{this.capturingWidthField});
        this.capturingHeightField = new FxNumberField();
        this.capturingHeightField.setPrefColumnCount(4);
        FxNodeUnit capturingHeightUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(BcWords.getInstance().height) + "(px)"), new Node[]{this.capturingHeightField});
        FxFlowPane resolutionPane = new FxFlowPane(21);
        resolutionPane.topMargin = 0.0;
        resolutionPane.addNodeUnit(capturingWidthUnit);
        resolutionPane.addNodeUnit(capturingHeightUnit);
        resolutionPane.setPrefWidth(600.0);
        this.resolutionUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().resolution), new Node[]{this.resolutionComboBox, resolutionPane});
        this.resolutionComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue ov, Object oldValue, Object newValue) {
                boolean editable = true;
                if (newValue instanceof FfmpegUtil.Resolution) {
                    FfmpegUtil.Resolution resolution = (FfmpegUtil.Resolution)((Object)newValue);
                    XfilCaptureConditionSet.this.capturingWidthField.setValue(resolution.width);
                    XfilCaptureConditionSet.this.capturingHeightField.setValue(resolution.height);
                    editable = false;
                }
                XfilCaptureConditionSet.this.capturingWidthField.setEditable(editable);
                XfilCaptureConditionSet.this.capturingHeightField.setEditable(editable);
            }
        });
        this.resolutionComboBox.setData();
        this.intervalField = new FxNumberField();
        this.intervalField.setPrefColumnCount(4);
        this.intervalUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(XfilWords.getInstance().captureInterval.toPlain()) + BcWords.getInstance().sec_unit), new Node[]{this.intervalField});
        this.headMarginField = new FxNumberField();
        this.headMarginField.setPrefColumnCount(4);
        this.headMarginUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(XfilWords.getInstance().headMargin.toPlain()) + BcWords.getInstance().sec_unit), new Node[]{this.headMarginField});
        this.tailMarginField = new FxNumberField();
        this.tailMarginField.setPrefColumnCount(4);
        this.tailMarginUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(XfilWords.getInstance().tailMargin.toPlain()) + BcWords.getInstance().sec_unit), new Node[]{this.tailMarginField});
        this.capturingCountMaxField = new FxNumberField();
        this.capturingCountMaxField.setPrefColumnCount(4);
        this.capturingCountMaxUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().maximum_number_of_captures.toPlain()), new Node[]{this.capturingCountMaxField});
        this.elapsedTimeCheckBox = new FxCheckBox();
        this.elapsedTimeHorizontalPositionComboBox = new HorizontalPositionComboBox();
        this.elapsedTimeVerticalPositionComboBox = new VerticalPositionComboBox();
        FxNodeUnit unit1 = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().horizontalPosition), new Node[]{this.elapsedTimeHorizontalPositionComboBox});
        FxNodeUnit unit2 = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().verticalPosition), new Node[]{this.elapsedTimeVerticalPositionComboBox});
        FxFlowPane positionPane = new FxFlowPane(21);
        positionPane.topMargin = 0.0;
        positionPane.addNodeUnit(unit1);
        positionPane.addNodeUnit(unit2);
        positionPane.setPrefWidth(600.0);
        this.elapsedTimeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().elapsedTime), new Node[]{this.elapsedTimeCheckBox, positionPane});
        XfilVideoCaptureCondition videoCaptureCondition = XfilCaptureUtil.createVideoCaptureConditionDefault();
        this.capturingWidthField.setValue(videoCaptureCondition.capturingWidth);
        this.capturingHeightField.setValue(videoCaptureCondition.capturingHeight);
        this.intervalField.setValue(videoCaptureCondition.intervalSec);
        this.headMarginField.setValue(videoCaptureCondition.headMarginSec);
        this.tailMarginField.setValue(videoCaptureCondition.tailMarginSec);
        this.capturingCountMaxField.setValue(videoCaptureCondition.capturingCountMax);
        this.elapsedTimeCheckBox.setSelected(videoCaptureCondition.elapsedTime);
        this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().select((Object)videoCaptureCondition.elapsedTimeHorizontalPositionId);
        this.elapsedTimeVerticalPositionComboBox.getSelectionModel().select((Object)videoCaptureCondition.elapsedTimeVerticalPositionId);
    }

    @Override
    public void clear() throws Exception {
    }

    public void setConditionSet(XfilCaptureConditionSet conditionSet) throws Exception {
        this.resolutionComboBox.getSelectionModel().select(conditionSet.resolutionComboBox.getSelectionModel().getSelectedItem());
        this.capturingWidthField.setValue(conditionSet.capturingWidthField.getBigDecimal());
        this.capturingHeightField.setValue(conditionSet.capturingHeightField.getBigDecimal());
        this.intervalField.setValue(conditionSet.intervalField.getBigDecimal());
        this.headMarginField.setValue(conditionSet.headMarginField.getBigDecimal());
        this.tailMarginField.setValue(conditionSet.tailMarginField.getBigDecimal());
        this.capturingCountMaxField.setValue(conditionSet.capturingCountMaxField.getBigDecimal());
        this.elapsedTimeCheckBox.setSelected(conditionSet.elapsedTimeCheckBox.isSelected());
        this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().select((Object)((Integer)conditionSet.elapsedTimeHorizontalPositionComboBox.getSelectionModel().getSelectedItem()));
        this.elapsedTimeVerticalPositionComboBox.getSelectionModel().select((Object)((Integer)conditionSet.elapsedTimeVerticalPositionComboBox.getSelectionModel().getSelectedItem()));
    }

    public void setCondition(XfilVideoCaptureCondition videoCaptureCondition) throws Exception {
        BcLogUtil.debug("videoCaptureCondition.elapsedTimeHorizontalPositionId=" + videoCaptureCondition.elapsedTimeHorizontalPositionId);
        BcLogUtil.debug("videoCaptureCondition.elapsedTimeVerticalPositionId=" + videoCaptureCondition.elapsedTimeVerticalPositionId);
        FfmpegUtil.Resolution resolution = XfilCaptureUtil.toResolution(videoCaptureCondition.capturingWidth, videoCaptureCondition.capturingHeight);
        this.resolutionComboBox.getSelectionModel().select((Object)resolution);
        this.capturingWidthField.setValue(videoCaptureCondition.capturingWidth);
        this.capturingHeightField.setValue(videoCaptureCondition.capturingHeight);
        this.intervalField.setValue(videoCaptureCondition.intervalSec);
        this.headMarginField.setValue(videoCaptureCondition.headMarginSec);
        this.tailMarginField.setValue(videoCaptureCondition.tailMarginSec);
        this.capturingCountMaxField.setValue(videoCaptureCondition.capturingCountMax);
        this.elapsedTimeCheckBox.setSelected(videoCaptureCondition.elapsedTime);
        this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().select((Object)videoCaptureCondition.elapsedTimeHorizontalPositionId);
        this.elapsedTimeVerticalPositionComboBox.getSelectionModel().select((Object)videoCaptureCondition.elapsedTimeVerticalPositionId);
    }

    public void getCondition(XfilVideoCaptureCondition videoCaptureCondition) throws Exception {
        Object value = this.resolutionComboBox.getSelectionModel().getSelectedItem();
        if (value instanceof FfmpegUtil.Resolution) {
            FfmpegUtil.Resolution resolution = (FfmpegUtil.Resolution)((Object)value);
            videoCaptureCondition.capturingWidth = resolution.width;
            videoCaptureCondition.capturingHeight = resolution.height;
        } else {
            videoCaptureCondition.capturingWidth = this.capturingWidthField.getBigDecimal().intValue();
            videoCaptureCondition.capturingHeight = this.capturingHeightField.getBigDecimal().intValue();
        }
        videoCaptureCondition.intervalSec = this.intervalField.getBigDecimal().intValue();
        videoCaptureCondition.headMarginSec = this.headMarginField.getBigDecimal().intValue();
        videoCaptureCondition.tailMarginSec = this.tailMarginField.getBigDecimal().intValue();
        videoCaptureCondition.capturingCountMax = this.capturingCountMaxField.getBigDecimal().intValue();
        videoCaptureCondition.elapsedTime = this.elapsedTimeCheckBox.isSelected();
        videoCaptureCondition.elapsedTimeHorizontalPositionId = (Integer)this.elapsedTimeHorizontalPositionComboBox.getSelectionModel().getSelectedItem();
        videoCaptureCondition.elapsedTimeVerticalPositionId = (Integer)this.elapsedTimeVerticalPositionComboBox.getSelectionModel().getSelectedItem();
    }

    public XfilVideoCaptureCondition getCondition() throws Exception {
        XfilVideoCaptureCondition condition = new XfilVideoCaptureCondition();
        this.getCondition(condition);
        return condition;
    }
}

