/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.dao.XdtsCustomSqlDAO;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;

public class XdtsCustomSqlRMO
extends RmiAbstractRMO {
    String namePrefix = "SQL-";

    public void put(RmiRmoArgument rmoArg) throws Exception {
        XdtsCustomSql customSql = (XdtsCustomSql)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        customSql.name = BcStringUtil.trim(customSql.name);
        customSql.group = XdtsUtil.reformPath(customSql.group);
        XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
        customSql.name = this.createName(dtsSession, customSql.dataSourceId, customSql.getDataId(), customSql.name, this.namePrefix);
        XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
        rmoArg.getRespons().addData(customSql);
    }

    public void getById(RmiRmoArgument rmoArg) throws Exception {
        long entityId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getById(dtsSession, entityId);
        rmoArg.getRespons().addData(customSql);
    }

    public void delete(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsCustomSql customSql = new XdtsCustomSql();
        int cnt = 0;
        for (Long entityId : entityIdCollection) {
            customSql.setEntityId(entityId);
            cnt += XdtsCustomSqlDAO.getInstance().deleteEntity(dtsSession, customSql);
        }
        rmoArg.getRespons().addData(cnt);
    }

    public void getlList(RmiRmoArgument rmoArg) throws Exception {
        long dataSourceId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List customSqlList = XdtsCustomSqlDAO.getInstance().getList(dtsSession, dataSourceId);
        rmoArg.getRespons().addData(customSqlList);
    }

    public void copy(RmiRmoArgument rmoArg) throws Exception {
        long dataSourceId = rmoArg.getRequest().getDataAsLong();
        Collection customSqlIdCollection = (Collection)rmoArg.getRequest().getData();
        String group = rmoArg.getRequest().getDataAsString();
        this.getLogger().debug("dataSourceId=" + dataSourceId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<XdtsCustomSql> customSqlList = new ArrayList<XdtsCustomSql>();
        Iterator iterator = customSqlIdCollection.iterator();
        while (iterator.hasNext()) {
            int customSqlId = (Integer)iterator.next();
            this.getLogger().debug("copyCustomSql:customSqlId=" + customSqlId);
            XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getById(dtsSession, customSqlId);
            this.getLogger().debug("customSql=" + customSql);
            customSql.setObjectId(-1L);
            customSql.setEntityId(-1L);
            customSql.dataSourceId = dataSourceId;
            customSql.group = group;
            customSql.name = this.createName(dtsSession, customSql.dataSourceId, customSql.getDataId(), customSql.name, this.namePrefix);
            XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
            customSqlList.add(customSql);
        }
        rmoArg.getRespons().addData(customSqlList);
    }

    public String createName(DtsSession dtsSession, long dataSourceId, long entityId, String origName, String namePrefix) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            origName = String.valueOf(namePrefix) + entityId;
        }
        String newName = BcStringUtil.toStringNotNull(origName);
        String baseName = null;
        int tryCnt = 0;
        while (true) {
            XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getByName(dtsSession, dataSourceId, newName);
            this.getLogger().debug("newName=" + newName + " customSql=" + customSql);
            if (customSql == null || (long)customSql.getDataId() == entityId) break;
            if (BcStringUtil.isEmpty(baseName) && BcStringUtil.isEmpty(baseName = EtcWordUtil.getBaseName(origName))) {
                baseName = origName;
            }
            newName = String.valueOf(baseName) + EtcEnumStrUtil.toElement(++tryCnt);
        }
        return newName;
    }

    public static enum Method implements RmiRemoteMethod
    {
        put,
        getById,
        delete,
        getlList,
        copy;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

