/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.awt.image.BufferedImage;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableCell;
import jp.co.extreme.fx.table.FxTableCellFactory;
import jp.co.extreme.fx.table.FxTableColumn;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsImageHelper;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsMenuPane;
import jp.co.extreme.module.xdts.fx.XdtsProfilePane;
import jp.co.extreme.module.xdts.fx.XdtsProfileWizard;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.rmo.XdtsProfileRMO;
import jp.co.extreme.module.xdts.stub.XdtsProfileStub;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf3.client.ScfSqlClientTask;
import jp.co.extreme.scf4.fx.HfxLoadableTablePane;
import jp.co.extreme.sql.SqlConstants;

public class XdtsProfileListPane
extends FxDecoratePane {
    InnerTablePane tablePane = new InnerTablePane();
    FxFlowPane controlPane = new FxFlowPane(22);
    FxButton addButton;
    FxButton editButton;
    FxButton cloneButton;
    FxButton deleteButton;
    FxButton connectionButton;
    FxButton closeButton;
    FxStage stage;
    Mode mode;
    long dataSourceId;
    XdtsMenuPane profileMenuPane;
    String[] tableColumnNames;

    public XdtsProfileListPane(Mode mode, XdtsMenuPane profileMenuPane) throws Exception {
        this.addButton = new FxButton(BcWords.getInstance().add);
        this.editButton = new FxButton(BcWords.getInstance().edit);
        this.cloneButton = new FxButton(BcWords.getInstance().clone);
        this.deleteButton = new FxButton(BcWords.getInstance().delete);
        this.connectionButton = new FxButton(BcWords.getInstance().connect);
        this.closeButton = new FxButton(BcWords.getInstance().close);
        this.tableColumnNames = new String[]{XdtsConstants.xdts_profile.group_.tableColumnName(), XdtsConstants.xdts_profile.name.tableColumnName(), XdtsConstants.xdts_profile.product_id.tableColumnName()};
        this.mode = mode;
        this.profileMenuPane = profileMenuPane;
        this.initComponant();
    }

    protected void initComponant() throws Exception {
        this.addButton.setOnAction(this.actionEventHandler);
        this.addButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_add_64x64.png"));
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.addButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.editButton.setOnAction(this.actionEventHandler);
        this.editButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_gear_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.editButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.cloneButton.setOnAction(this.actionEventHandler);
        this.cloneButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_copy_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.cloneButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.deleteButton.setOnAction(this.actionEventHandler);
        this.deleteButton.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.deleteButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.connectionButton.setOnAction(this.actionEventHandler);
        this.connectionButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_connection_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.connectionButton});
        this.controlPane.addNodeUnit(nodeUnit);
        if (this.mode == Mode.defaullt) {
            this.closeButton.setOnAction(this.actionEventHandler);
            this.closeButton.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
            nodeUnit = new FxNodeUnit(null, new Node[]{this.closeButton});
            this.controlPane.addNodeUnit(nodeUnit);
        }
        this.controlPane.setPrefHeight(36.0);
        this.controlPane.unitSpace = 6.0;
        this.setBottom((Node)this.controlPane);
        this.setCenter((Node)this.tablePane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void doLoad() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsProfileRMO.class.getName());
        rmiReq.setMethodName(XdtsProfileRMO.Method.profileList.getMethodName());
        this.tablePane.doLoad(rmiReq);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.addButton) {
            XdtsProfileWizard profileWizard = new XdtsProfileWizard();
            XdtsProfile profile = new XdtsProfile();
            XdtsProfile profile2 = profileWizard.show(profile, this.getScene().getWindow());
            if (profile2 != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.editButton) {
            XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(this.dataSourceId);
            XdtsProfileWizard profileWizard = new XdtsProfileWizard();
            XdtsProfile profile2 = XdtsProfileWizard.show2(profile, this.getScene().getWindow());
            if (profile2 != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.cloneButton) {
            XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(this.dataSourceId);
            profile.setEntityId(-1L);
            profile.name = String.valueOf(profile.name) + " - clone";
            profile.connectionTimestamp = null;
            profile.connectionCount = 0;
            XdtsProfileWizard profileWizard = new XdtsProfileWizard();
            XdtsProfile profile2 = XdtsProfileWizard.show2(profile, this.getScene().getWindow());
            if (profile2 != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.deleteButton) {
            XdtsProfile profile2;
            XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(this.dataSourceId);
            String msg = String.format(BcWords.getInstance().Do_you_want_to_delete_the_$, profile.name);
            if (FxOptionPane.showConfirmDialog((Node)this, (Object)msg, BcWords.getInstance().confirmation, 3) == 0 && (profile2 = XdtsProfileStub.getInstance().deleteProfile(profile.getEntityId())) != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.connectionButton) {
            XdtsProfilePane.show2(this.dataSourceId, null);
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public boolean isSelectColumn(String tableColumnName) throws Exception {
        int i = 0;
        while (i < this.tableColumnNames.length) {
            if (this.tableColumnNames[i].equalsIgnoreCase(tableColumnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void close() throws Exception {
        this.stage.close();
        this.profileMenuPane.profileListClosed();
    }

    protected void show() throws Exception {
        this.stage = new FxStage();
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene(scene);
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsProfileListPane.this.close();
                }
                catch (Exception ex) {
                    XdtsProfileListPane.this.handleException(ex);
                }
            }
        });
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().dataSourceList);
        Image image = FxImageHelper.getImage("db_64x64.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowLocation((Window)this.stage, 100.0, 100.0, 1200.0, 600.0);
        this.stage.show();
    }

    class InnerTablePane
    extends HfxLoadableTablePane {
        TableCellFactoryDb tableCellFactoryDb = new TableCellFactoryDb();

        @Override
        protected void loadPreCommon() throws Exception {
            super.loadPreCommon();
            XdtsProfileListPane.this.editButton.setDisable(true);
            XdtsProfileListPane.this.cloneButton.setDisable(true);
            XdtsProfileListPane.this.deleteButton.setDisable(true);
            XdtsProfileListPane.this.connectionButton.setDisable(true);
        }

        @Override
        protected void tableColumnListCreated(List<FxTableColumn> tableColumnList) throws Exception {
            super.tableColumnListCreated(tableColumnList);
            for (FxTableColumn tableColumn : tableColumnList) {
                MmdField mmdField = tableColumn.mmdField;
                if (!XdtsConstants.xdts_profile.product_id.tableColumnName().equalsIgnoreCase(mmdField.tableColumnName)) continue;
                tableColumn.setCellFactory(this.tableCellFactoryDb);
            }
        }

        @Override
        protected TableView createTableView() throws Exception {
            InnerTableView2 tableView = new InnerTableView2();
            tableView.setItems(FXCollections.observableArrayList());
            return tableView;
        }

        @Override
        public void loaded(ScfSqlClientTask sqlClientTask, boolean eod) throws Exception {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((InnerTablePane)InnerTablePane.this).XdtsProfileListPane.this.addButton.requestFocus();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        class InnerTableCell
        extends FxTableCell {
            public InnerTableCell(FxTableColumn tableColumn) throws Exception {
                super(tableColumn);
            }

            @Override
            protected void tempProc(Object cellValue, Node graphicNode, MmdField mmdField, boolean isEdit) throws Exception {
                try {
                    if (graphicNode instanceof Label) {
                        String productName = (String)cellValue;
                        SqlConstants.DatabaseProduct databaseProduct = SqlConstants.DatabaseProduct.getByShortName(productName);
                        if (databaseProduct == null) {
                            return;
                        }
                        BufferedImage bufferedImage = XdtsImageHelper.getImage(databaseProduct.id);
                        WritableImage image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                        ImageView imageView = new ImageView((Image)image);
                        imageView.setPreserveRatio(true);
                        imageView.setFitHeight(18.0);
                        Label label = (Label)graphicNode;
                        label.setGraphic((Node)imageView);
                        label.setContentDisplay(ContentDisplay.LEFT);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        class TableCellFactoryDb
        extends FxTableCellFactory {
            TableCellFactoryDb() {
            }

            @Override
            public FxTableCell call(FxTableColumn tableColumn) {
                InnerTableCell tableCell = null;
                try {
                    tableCell = new InnerTableCell(tableColumn);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
                return tableCell;
            }
        }
    }

    class InnerTableView2
    extends FxTableView {
        public InnerTableView2() throws Exception {
            TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionMode(SelectionMode.SINGLE);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            TablePosition tablePosition = BcCollectionUtil.getFirst(tablePositionList);
            XdtsProfileListPane.this.editButton.setDisable(true);
            XdtsProfileListPane.this.cloneButton.setDisable(true);
            XdtsProfileListPane.this.deleteButton.setDisable(true);
            XdtsProfileListPane.this.connectionButton.setDisable(true);
            if (tablePosition != null) {
                XdtsProfileListPane.this.dataSourceId = ((Integer)FxTableUtil.getCellValue((TableView)this, tablePosition.getRow(), XdtsConstants.xdts_profile.id.tableColumnName())).intValue();
                XdtsProfileListPane.this.editButton.setDisable(false);
                XdtsProfileListPane.this.cloneButton.setDisable(false);
                XdtsProfileListPane.this.deleteButton.setDisable(false);
                XdtsProfileListPane.this.connectionButton.setDisable(false);
                if (doubleClicked) {
                    XdtsProfilePane.show2(XdtsProfileListPane.this.dataSourceId, null);
                }
            }
        }

        @Override
        protected void columnChanged(ListChangeListener.Change change) throws Exception {
            super.columnChanged(change);
            if (XdtsProfileListPane.this.mode == Mode.select) {
                for (Object obj : XdtsProfileListPane.this.tablePane.getTableView().getColumns()) {
                    FxTableColumn tableColumn = (FxTableColumn)((Object)obj);
                    tableColumn.setVisible(XdtsProfileListPane.this.isSelectColumn(tableColumn.mmdField.tableColumnName));
                }
            }
        }
    }

    public static enum Mode {
        defaullt,
        select;

    }
}

