/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.Map;
import javafx.scene.Node;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.sql.SqlWords;

class XdtsHttpConfigPane
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField hostNameField = new FxTextField();
    FxNumberField portField = new FxNumberField();
    FxNumberField sessionTimeoutField = new FxNumberField();
    FxNumberField resultTimeoutField = new FxNumberField();
    FxTextField siteNameField = new FxTextField();
    FxCheckBox tableCheckBox = new FxCheckBox();
    FxCheckBox viewCheckBox = new FxCheckBox();
    FxCheckBox sqlCheckBox = new FxCheckBox();
    FxCheckBox conditionCheckBox = new FxCheckBox();

    public XdtsHttpConfigPane() throws Exception {
        this.initComponant();
    }

    protected void initComponant() throws Exception {
        this.hostNameField.setPrefColumnCount(60);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().hostName.toPlain()), new Node[]{this.hostNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.portField.setPrefColumnCount(6);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().port), new Node[]{this.portField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.sessionTimeoutField.setPrefColumnCount(5);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(BcWords.getInstance().sessionTimeout.toPlain()) + "(sec)"), new Node[]{this.sessionTimeoutField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.resultTimeoutField.setPrefColumnCount(5);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(XdtsWords.getInstance().resultTimeout.toPlain()) + "(sec)"), new Node[]{this.resultTimeoutField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.siteNameField.setPrefColumnCount(60);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().siteName), new Node[]{this.siteNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().table), new Node[]{this.tableCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().view), new Node[]{this.viewCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().sql), new Node[]{this.sqlCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().condition), new Node[]{this.conditionCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
    }

    public void storeData(Map<String, String> map) throws Exception {
        map.put(XdtsConstants.Property2.hostName.name(), this.hostNameField.getText());
        map.put(XdtsConstants.Property2.port.name(), this.portField.getBigDecimal().toString());
        map.put(XdtsConstants.Property2.sessionTimeout.name(), this.sessionTimeoutField.getBigDecimal().toString());
        map.put(XdtsConstants.Property2.resultTimeout.name(), this.resultTimeoutField.getBigDecimal().toString());
        map.put(XdtsConstants.Property2.siteName.name(), this.siteNameField.getText());
        map.put(XdtsConstants.Property2.table.name(), Boolean.toString(this.tableCheckBox.isSelected()));
        map.put(XdtsConstants.Property2.view.name(), Boolean.toString(this.viewCheckBox.isSelected()));
        map.put(XdtsConstants.Property2.sql.name(), Boolean.toString(this.sqlCheckBox.isSelected()));
        map.put(XdtsConstants.Property2.condition.name(), Boolean.toString(this.conditionCheckBox.isSelected()));
    }

    public void setData(Map<String, String> map) throws Exception {
        this.hostNameField.setText(map.get(XdtsConstants.Property2.hostName.name()));
        String tmpStr = map.get(XdtsConstants.Property2.port.name());
        this.portField.setValue(BcNumberUtil.parseInteger(tmpStr, 0));
        tmpStr = map.get(XdtsConstants.Property2.sessionTimeout.name());
        this.sessionTimeoutField.setValue(BcNumberUtil.parseInteger(tmpStr, 0));
        tmpStr = map.get(XdtsConstants.Property2.resultTimeout.name());
        this.resultTimeoutField.setValue(BcNumberUtil.parseInteger(tmpStr, 0));
        this.siteNameField.setText(map.get(XdtsConstants.Property2.siteName.name()));
        this.tableCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.Property2.table.name())));
        this.viewCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.Property2.view.name())));
        this.sqlCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.Property2.sql.name())));
        this.conditionCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.Property2.condition.name())));
    }

    public BcResult validation() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        inputValidator.notNullable(BcWords.getInstance().hostName.toPlain(), this.hostNameField.getText(), result.getErrorList());
        String[] items = new String[]{BcWords.getInstance().table, BcWords.getInstance().view, SqlWords.getInstance().sql, BcWords.getInstance().condition};
        boolean[] selects = new boolean[]{this.tableCheckBox.isSelected(), this.viewCheckBox.isSelected(), this.sqlCheckBox.isSelected(), this.conditionCheckBox.isSelected()};
        inputValidator.select_$_or_more_$(items, selects, 1, result.getErrorList());
        return result;
    }
}

