/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextInputControl;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.etc.model.EtcColumnCondition;
import jp.co.extreme.fx.extension.FxxPeriodPane;
import jp.co.extreme.fx.extension.FxxRadioButtonControl;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.fx.XdtsControlUnit;
import jp.co.extreme.module.xdts.fx.XdtsFxCondition;
import jp.co.extreme.module.xdts.fx.XdtsSelectColumnPane;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsColumn;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsElemet;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import jp.co.extreme.module.xdts.model.v001.XdtsWhere;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsFxToConditionModel
extends BcLoggableObject {
    public void storeData(SqlContext sqlContext, XdtsExtractionCondition extractionCondition, XdtsFxCondition fxCondition, XdtsUserSetting userSetting) throws Exception {
        int i = 0;
        while (i < extractionCondition.selectList.size()) {
            XdtsSelect selectContext = extractionCondition.selectList.get(i);
            List<XdtsControlUnit> controlUnitList1 = fxCondition.controlUnitMap1.get(selectContext.id);
            this.storeData_L2(sqlContext, selectContext, controlUnitList1, userSetting);
            ++i;
        }
    }

    public void storeData_L2(SqlContext sqlContext, XdtsSelect selectContext, Collection<XdtsControlUnit> controlUnitCollection, XdtsUserSetting userSetting) throws Exception {
        this.getLogger().debug("storeData_L2:.controlUnitCollection.size()=" + controlUnitCollection.size());
        selectContext.wherecClauseSql = new XdtsWhere();
        for (XdtsControlUnit controlUnit : controlUnitCollection) {
            Node controlNode = controlUnit.nodeUnit.getRightNodeList().get(0);
            this.storeData_L3(sqlContext, selectContext, controlUnit.controlContext, controlNode, userSetting);
        }
    }

    public void storeData_L3(SqlContext sqlContext, XdtsSelect xdtsSelect, XdtsControlContext controlContext, Node controlNode, XdtsUserSetting userSetting) throws Exception {
        this.getLogger().debug("storeData_L3:controlContext.contextType=" + (Object)((Object)controlContext.contextType) + " controlContext.name=" + controlContext.name);
        if (controlContext.contextType == XdtsConstants.ContextType.Select) {
            XdtsSelectColumnPane selectColumnPane = (XdtsSelectColumnPane)controlNode;
            xdtsSelect.columnList.clear();
            int i = 0;
            while (i < selectColumnPane.tableModel.getRowCount()) {
                XdtsColumn selectColumn = new XdtsColumn();
                selectColumn.elemet = new XdtsElemet();
                selectColumn.elemet.template = (String)selectColumnPane.tableModel.getValueAt(i, 0);
                selectColumn.alias = (String)selectColumnPane.tableModel.getValueAt(i, 1);
                selectColumn.order = (Integer)selectColumnPane.tableModel.getValueAt(i, 2);
                xdtsSelect.columnList.add(selectColumn);
                ++i;
            }
        } else if (controlContext.contextType == XdtsConstants.ContextType.From) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            XdtsElemet elemet = new XdtsElemet();
            elemet.template = textInputControl.getText();
            xdtsSelect.from = elemet;
        } else if (controlContext.contextType == XdtsConstants.ContextType.Where) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            xdtsSelect.whereBase.template = textInputControl.getText();
        } else if (controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
            String strValue;
            xdtsSelect.orderByBase = strValue = this.getControlNodeValue(controlNode);
            BcCollectionUtil.addElementUnique(controlContext.inputValueList, strValue);
        } else if (controlContext.contextType == XdtsConstants.ContextType.RowLimit) {
            String value0 = this.getControlNodeValue(controlNode);
            xdtsSelect.rowLimit = BcNumberUtil.parseLong(value0, -1);
            String strValue = Long.toString(xdtsSelect.rowLimit);
            BcCollectionUtil.addElementUnique(controlContext.inputValueList, strValue);
            XdtsUtil.addEntry(controlContext.name, strValue, userSetting);
        } else if (controlContext.contextType == XdtsConstants.ContextType.General) {
            EtcColumnCondition columnCondition = this.createColumnCondition(controlContext, controlNode);
            BcCollectionUtil.addElementUnique(controlContext.inputValueList, columnCondition.value);
            XdtsSqlConditionUtil.createWhereClause_L2(sqlContext, xdtsSelect.wherecClauseSql, columnCondition);
            XdtsUtil.addEntry(controlContext.name, BcStringUtil.toString(columnCondition.value), userSetting);
        }
    }

    public EtcColumnCondition createColumnCondition(XdtsControlContext controlContext, Node controlNode) throws Exception {
        EtcColumnCondition columnCondition = new EtcColumnCondition();
        columnCondition.tableColumnName = controlContext.tableColumnName;
        columnCondition.sqlTypeId = controlContext.sqlTypeId;
        columnCondition.isAnd = controlContext.isAnd;
        columnCondition.patternMatch = controlContext.patternMatch;
        columnCondition.value = this.getControlNodeValue(controlNode);
        return columnCondition;
    }

    public String getControlNodeValue(Node controlNode) throws Exception {
        FxxRadioButtonControl radioButtonControl;
        String strValue = null;
        if (controlNode instanceof TextInputControl) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            strValue = textInputControl.getText();
        } else if (controlNode instanceof ComboBox) {
            ComboBox comboBox = (ComboBox)controlNode;
            Object value = comboBox.getValue();
            strValue = BcStringUtil.toString(value);
        } else if (controlNode instanceof FxxPeriodPane) {
            FxxPeriodPane periodPane = (FxxPeriodPane)controlNode;
            String str1 = BcTimeUtil.toString(periodPane.dateTimePane1.getCalendar(), "yyyy/MM/dd HH:mm:ss");
            String str2 = BcTimeUtil.toString(periodPane.dateTimePane2.getCalendar(), "yyyy/MM/dd HH:mm:ss");
            strValue = BcStringUtil.toCsv(str1, str2);
        } else if (controlNode instanceof FxxRadioButtonControl && !BcStringUtil.isEmpty(strValue = (radioButtonControl = (FxxRadioButtonControl)controlNode).getInputText())) {
            Boolean bool = BcBooleanUtil.parseBoolean(strValue, false);
            strValue = bool.toString();
        }
        return strValue;
    }
}

