/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventManager;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.tree.FxTreeCell;
import jp.co.extreme.fx.tree.FxTreeFolder;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.tree.FxTreeUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.InnerComparator1;
import jp.co.extreme.module.xdts.fx.XdtsFxLauncher;
import jp.co.extreme.module.xdts.fx.XdtsObjectTreeUtil;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreeItemHelper;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.stub.XdtsExtractionConditionStub;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Auto;

class XdtsExtractionConditionTreeItemHelper
extends XdtsProfileTreeItemHelper {
    ComparatorForId comparatorForId = new ComparatorForId();
    ComparatorForSort comparatorForSort = new ComparatorForSort();
    ContextMenu contextMenu;
    MenuItem refreshMenuItem;
    MenuItem editMenuItem;
    MenuItem deleteMenuItem;
    MenuItem copyMenuItem;
    MenuItem pastMenuItem;
    MenuItem dataViewMenuItem;

    public XdtsExtractionConditionTreeItemHelper() throws Exception {
        BcEventManager.getInstance().getEventHandlerList(XdtsExtractionCondition.class).addEventHandler(this);
    }

    @Override
    public FxTreeItem creaeSubTreeItem() throws Exception {
        FxTreeItem treeItem = this.creaeTreeItem();
        treeItem.setValue(new FxTreeFolder(BcWords.getInstance().extractionCondition.toPlain(), (Object)FxTreeFolder.FolderType.subRoot));
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
        return treeItem;
    }

    @Override
    public String getItemText(FxTreeItem treeItem) throws Exception {
        String str = null;
        if (XdtsExtractionCondition.class.isInstance(treeItem.getValue())) {
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)treeItem.getValue();
            str = extractionCondition.name;
        } else {
            str = super.getItemText(treeItem);
        }
        return str;
    }

    @Override
    public void refresh() throws Exception {
        super.refresh();
        List<Object> valueList = FxTreeUtil.getValueList(this.getTreeView().getSelectionModel().getSelectedItems());
        this.refresh_L2();
        ObservableList treeItemList = this.getSubTreeItem().getChildren();
        this.getTreeView().getSelectionModel().clearSelection();
        FxTreeUtil.selectTreeItems((List<? extends TreeItem>)treeItemList, valueList, this.comparatorForId, this.getTreeView().getSelectionModel());
    }

    protected void refresh_L2() throws Exception {
        List extractionConditionList = XdtsExtractionConditionStub.getInstance().getList(this.profile.getEntityId());
        this.getSubTreeItem().getChildren().clear();
        for (XdtsExtractionCondition extractionCondition : extractionConditionList) {
            FxTreeItem treeItem = this.creaeTreeItem();
            treeItem.setValue(extractionCondition);
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            XdtsObjectTreeUtil.setPath1(treeItem, this.getSubTreeItem(), extractionCondition.group, this, this.comparatorForSort);
        }
        String str = String.format(BcWords.getInstance().extractionCondition + "(%d)", extractionConditionList.size());
        this.getSubTreeItem().setValue(new FxTreeFolder(str, (Object)FxTreeFolder.FolderType.subRoot));
    }

    @Override
    public void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        super.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        if (FxTreeUtil.isAncestor(this.getSubTreeItem(), treeItem) && doubleClicked && treeItem.getValue() instanceof XdtsExtractionCondition) {
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)treeItem.getValue();
            this.dataView(extractionCondition.id);
        }
    }

    @Override
    public void treeItemExpanded(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemExpanded(ev);
        TreeItem treeItem = ev.getTreeItem();
        if (FxTreeUtil.isAncestor(this.getSubTreeItem(), treeItem) && treeItem.getValue() instanceof FxTreeFolder) {
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("folder_opened_64x64.png"));
        }
    }

    @Override
    public void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemCollapsed(ev);
        TreeItem treeItem = ev.getTreeItem();
        if (FxTreeUtil.isAncestor(this.getSubTreeItem(), treeItem) && treeItem.getValue() instanceof FxTreeFolder) {
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("folder_closed_64x64.png"));
        }
    }

    @Override
    public void setContextMenu(FxTreeItem treeItem, FxTreeCell treeCell, EventHandler contextMeneEventHandler) throws Exception {
        if (this.contextMenu == null) {
            this.refreshMenuItem = new MenuItem(BcWords.getInstance().refresh, (Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
            this.refreshMenuItem.setOnAction(contextMeneEventHandler);
            this.contextMenu = new ContextMenu();
            this.editMenuItem = new MenuItem(BcWords.getInstance().edit, (Node)FxImageHelper.createImageView_icon("document_edit_64x64.png"));
            this.editMenuItem.setOnAction(contextMeneEventHandler);
            this.deleteMenuItem = new MenuItem(BcWords.getInstance().delete, (Node)FxImageHelper.createImageView_icon("document_delete_64x64.png"));
            this.deleteMenuItem.setOnAction(contextMeneEventHandler);
            this.copyMenuItem = new MenuItem(BcWords.getInstance().copy, (Node)FxImageHelper.createImageView_icon("copy_64x64.png"));
            this.copyMenuItem.setOnAction(contextMeneEventHandler);
            this.pastMenuItem = new MenuItem(BcWords.getInstance().past, (Node)FxImageHelper.createImageView_icon("paste_64x64.png"));
            this.pastMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewMenuItem = new MenuItem(XdtsWords.getInstance().dataView, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewMenuItem.setOnAction(contextMeneEventHandler);
        }
        this.refreshMenuItem.setUserData((Object)treeCell);
        this.editMenuItem.setUserData((Object)treeCell);
        this.deleteMenuItem.setUserData((Object)treeCell);
        this.copyMenuItem.setUserData((Object)treeCell);
        this.pastMenuItem.setUserData((Object)treeCell);
        this.dataViewMenuItem.setUserData((Object)treeCell);
        this.contextMenu.getItems().clear();
        if (treeItem == this.getSubTreeItem()) {
            this.contextMenu.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu.getItems().add((Object)this.copyMenuItem);
            this.contextMenu.getItems().add((Object)this.pastMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.refreshMenuItem);
        } else {
            this.contextMenu.getItems().add((Object)this.dataViewMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.editMenuItem);
            this.contextMenu.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu.getItems().add((Object)this.copyMenuItem);
            this.contextMenu.getItems().add((Object)this.pastMenuItem);
        }
        treeCell.setContextMenu(this.contextMenu);
        this.pastMenuItem.setDisable(true);
        this.clipboardValueList = null;
        try {
            String tmpStr = Clipboard.getSystemClipboard().getString();
            this.getLogger().debug("tmpStr=" + tmpStr);
            this.clipboardValueList = BcCsvUtil.parseCsvRow(tmpStr, true);
            String className = (String)BcCollectionUtil.getElement(this.clipboardValueList, 0);
            this.getLogger().debug("className=" + className);
            if (this.getClass().getName().equals(className)) {
                this.pastMenuItem.setDisable(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void contextMenuHandle(Event ev, FxTreeItem treeItem) throws Exception {
        if (ev.getSource() == this.refreshMenuItem) {
            this.refresh();
        } else if (ev.getSource() == this.editMenuItem) {
            XdtsExtractionCondition extractionCondition1 = (XdtsExtractionCondition)treeItem.getValue();
            XdtsExtractionCondition extractionCondition2 = (XdtsExtractionCondition)XdtsExtractionConditionStub.getInstance().getById(extractionCondition1.id);
            XdtsFxLauncher.extractionCondition(this.sqlContext, extractionCondition2);
        } else if (ev.getSource() == this.deleteMenuItem) {
            this.delete(ev, treeItem);
        } else if (ev.getSource() == this.copyMenuItem) {
            this.copy(ev, treeItem);
        } else if (ev.getSource() == this.pastMenuItem) {
            if (this.past(ev, treeItem)) {
                BcEventManager.getInstance().getEventHandlerList(XdtsExtractionCondition.class).fireEvent(new BcEvent(new XdtsExtractionCondition()));
            }
        } else if (ev.getSource() == this.dataViewMenuItem) {
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)treeItem.getValue();
            this.dataView(extractionCondition.id);
        }
    }

    @Override
    protected void delete(List<FxTreeItem> descendantList) throws Exception {
        ArrayList<Long> entityIdList = new ArrayList<Long>();
        for (FxTreeItem treeItemWk2 : descendantList) {
            if (!(treeItemWk2.getValue() instanceof XdtsExtractionCondition)) continue;
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)treeItemWk2.getValue();
            entityIdList.add(extractionCondition.id);
        }
        XdtsExtractionConditionStub.getInstance().delete(entityIdList);
        BcEventManager.getInstance().getEventHandlerList(XdtsExtractionCondition.class).fireEvent(new BcEvent(new XdtsExtractionCondition()));
    }

    @Override
    public void handle(BcEvent event) throws Exception {
        Object element;
        if (event.getSource() instanceof XdtsExtractionCondition) {
            this.refresh();
        } else if (event.getSource() instanceof List && (element = BcCollectionUtil.getFirst((List)event.getSource())) instanceof XdtsExtractionCondition) {
            this.refresh();
        }
    }

    @Override
    public void destruct() throws Exception {
        super.destruct();
        BcEventManager.getInstance().getEventHandlerList(XdtsExtractionCondition.class).removeEventHandler(this);
    }

    protected void copy(Event ev, FxTreeItem treeItem) throws Exception {
        List treeItemList = FxTreeUtil.extractParent(this.getTreeView().getSelectionModel().getSelectedItems(), this.getSubTreeItem());
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(this.getClass().getName());
        int i = 0;
        while (i < treeItemList.size()) {
            FxTreeItem treeItemWk = (FxTreeItem)treeItemList.get(i);
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)treeItemWk.getValue();
            paramList.add(Long.toString(extractionCondition.id));
            ++i;
        }
        String csv = BcCsvUtil.toCsv(paramList);
        this.getLogger().debug("copy:csv=" + csv);
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(csv);
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    protected boolean past(Event ev, FxTreeItem treeItem) throws Exception {
        this.getLogger().debug("pase:clipboardValueList=" + this.clipboardValueList);
        if (BcCollectionUtil.isEmpty(this.clipboardValueList)) {
            return false;
        }
        String className = (String)this.clipboardValueList.remove(0);
        this.getLogger().debug("past:className=" + className);
        ArrayList<Integer> entityIdList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.clipboardValueList.size()) {
            int entityId = BcNumberUtil.parseInteger((String)this.clipboardValueList.get(i));
            entityIdList.add(entityId);
            ++i;
        }
        String groupPath = this.createGroupPath(treeItem);
        List extractionConditionList = XdtsExtractionConditionStub.getInstance().copy(this.profile.getEntityId(), entityIdList, groupPath);
        return true;
    }

    protected void dataView(long extractionCondition1Id) throws Exception {
        XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)XdtsExtractionConditionStub.getInstance().getById(extractionCondition1Id);
        XdtsDataViewPanel_Auto dataViewPanel = new XdtsDataViewPanel_Auto();
        dataViewPanel.setProfile(this.profile);
        dataViewPanel.setData(extractionCondition, new XdtsUserSetting(), true);
        dataViewPanel.setTitle(extractionCondition.name);
        dataViewPanel.init();
        dataViewPanel.showAsFrame();
    }

    protected class ComparatorForId
    extends InnerComparator1 {
        protected ComparatorForId() {
        }

        @Override
        public int compare2(Object obj1, Object obj2) {
            if (obj1 instanceof XdtsExtractionCondition && obj2 instanceof XdtsExtractionCondition) {
                XdtsExtractionCondition extractionCondition1 = (XdtsExtractionCondition)obj1;
                XdtsExtractionCondition extractionCondition2 = (XdtsExtractionCondition)obj2;
                return super.compare2(extractionCondition1.id, extractionCondition2.id);
            }
            return super.compare2(obj1, obj2);
        }
    }

    protected class ComparatorForSort
    extends InnerComparator1 {
        protected ComparatorForSort() {
        }

        @Override
        public int compare2(Object obj1, Object obj2) {
            if (obj1 instanceof XdtsExtractionCondition && obj2 instanceof XdtsExtractionCondition) {
                XdtsExtractionCondition extractionCondition1 = (XdtsExtractionCondition)obj1;
                XdtsExtractionCondition extractionCondition2 = (XdtsExtractionCondition)obj2;
                return super.compare2(extractionCondition1.name, extractionCondition2.name);
            }
            return super.compare2(obj1, obj2);
        }
    }
}

