/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XdtsProfileDAO
extends OrmAbstractDAO<XdtsProfile> {
    public static XdtsProfileDAO getInstance() {
        return SingletonHolder.instance;
    }

    private XdtsProfileDAO() {
        super(new XdtsProfile[0]);
        this.setTableName("xdts_profile");
        this.setViewName(String.valueOf(this.tableName) + "__v1");
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, Long dataSourceId, String dataSourceName) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (dataSourceId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + dataSourceId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(dataSourceName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "name " + sqlContext.toCondition_string("=", dataSourceName));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(SqlUtil.createTableName(this.getTableName(), alias));
        switch (mode) {
            case id: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
                break;
            }
            case name: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "name");
                break;
            }
            case group: {
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "group_");
                selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "name");
            }
        }
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, Long dataSourceId, String dataSourceName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "prof";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, dataSourceId, dataSourceName);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long dataSourceId, boolean checkExistence) throws Exception {
        String profileName = null;
        List<T> entityList = this.getList(dtsSession, Mode.id, dataSourceId, profileName);
        T entity = BcCollectionUtil.getFirst(entityList);
        if (entity == null && checkExistence) {
            String msg = BcWords.getInstance().$_does_not_exists(XdtsWords.getInstance().dataSourceId + "=" + dataSourceId);
            throw new Exception(msg);
        }
        return entity;
    }

    public <T> T getByName(DtsSession dtsSession, String dataSourceName) throws Exception {
        if (BcStringUtil.isEmpty(dataSourceName)) {
            return null;
        }
        Long dataSourceId = null;
        List<T> entityList = this.getList(dtsSession, Mode.group, dataSourceId, dataSourceName);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ XdtsProfileDAO(XdtsProfileDAO xdtsProfileDAO) {
        this();
    }

    public static enum Mode {
        id,
        name,
        group;

    }

    private static final class SingletonHolder {
        private static final XdtsProfileDAO instance = new XdtsProfileDAO(null);

        private SingletonHolder() {
        }
    }
}

