/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.httpserver.HtsvUrlParameterMap;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.cmsv.common.CmsvConstants;
import jp.co.extreme.module.cmsv.dao.CmsvMessageDAO;
import jp.co.extreme.module.cmsv.model.CmsvMessage;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.dao.Wbs1PointDetailDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1Judgement;
import jp.co.extreme.module.wbs1.model.WbsMessageCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1MessageImput;
import jp.co.extreme.module.wbs1.wcb.Wbs1MessageListWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1PersonProfileWCB;
import jp.co.extreme.module.wbs1.wcb.WbsJudgementFiledHtmlCreator;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.PersonProfileUtil;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebMessageConstants;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.person.common.PsnPersonConstants;
import jp.co.extreme.person.util.PsnPersonUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;

public class Wbs1MessageWCB
extends Wbs1AbstractWCB {
    Wbs1PersonProfileWCB personProfileWCB = new Wbs1PersonProfileWCB();

    public void form(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void form_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        HtsvUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        this.getLogger().debug("decryptMap=" + decryptMap);
        WbsUrlParam urlParam = null;
        XwebMessageConstants.MessageContext messageContext = null;
        Wbs1MessageImput messageImput = null;
        CmsvMessage wbsMessage = null;
        Wbs1Judgement judgement = null;
        if (tokenContext.validationResult == null) {
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            WbsMessageCondition messageCondition = new WbsMessageCondition();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, messageCondition);
            CmsvConstants.MessageCategory messageCategory = messageCondition.messageCategory;
            this.getLogger().debug("messageCategory=" + (Object)((Object)messageCategory));
            messageContext = XwebMessageConstants.ceateMessageContext(messageCategory);
            CmsvMessageDAO messageDAO = CmsvMessageDAO.getInstance(messageCategory.tableName);
            wbsMessage = messageCondition.messageId <= 0L ? new CmsvMessage() : (CmsvMessage)messageDAO.getById(dtsSessionSite, messageCondition.messageId);
            messageImput = new Wbs1MessageImput();
            messageImput.messageCategoryId = messageCategory.id;
            messageImput.messageId = wbsMessage.id;
            messageImput.subject = wbsMessage.subject;
            messageImput.content = wbsMessage.content;
            messageImput.toMessageId = messageCondition.messageId;
            XwebUtil.putToMap(tokenContext.map, messageContext);
            XwebUtil.putToMap(tokenContext.map, messageImput);
            XwebUtil.putToMap(tokenContext.map, wbsMessage);
            judgement = new Wbs1Judgement();
            XwebJudgementUtil.judgementSet(wbsMessage, judgement);
            XwebUtil.putToMap(tokenContext.map, judgement);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            WbsMessageCondition messageCondition = (WbsMessageCondition)XwebUtil.getMapValue(tokenContext.map, WbsMessageCondition.class);
            messageContext = (XwebMessageConstants.MessageContext)XwebUtil.getMapValue(tokenContext.map, XwebMessageConstants.MessageContext.class);
            messageImput = (Wbs1MessageImput)XwebUtil.getMapValue(tokenContext.map, Wbs1MessageImput.class);
            wbsMessage = (CmsvMessage)XwebUtil.getMapValue(tokenContext.map, CmsvMessage.class);
            judgement = (Wbs1Judgement)XwebUtil.getMapValue(tokenContext.map, Wbs1Judgement.class);
        }
        WbxFormData formData = new WbxFormData();
        formData.icon = messageContext.iconTag;
        formData.title = messageContext.title;
        StringBuilder fileds = new StringBuilder();
        WbsFiledHtmlCreator filedHtmlCreator = new WbsFiledHtmlCreator(this.getHtmlBuilder());
        fileds.append(filedHtmlCreator.create(messageImput, tokenContext.validationResult));
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            formData.title = String.valueOf(formData.title) + ":" + urlParam.mode;
            if (wbsMessage != null) {
                formData.title = String.valueOf(formData.title) + " \u5b9b\u5148MSG-ID=" + wbsMessage.id;
            }
            WbsJudgementFiledHtmlCreator judgementFiledHtmlCreator = new WbsJudgementFiledHtmlCreator(this.getHtmlBuilder());
            fileds.append(judgementFiledHtmlCreator.create(judgement, tokenContext.validationResult));
        }
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.submit);
        String onclickAction = WbfJslUtil.submit2(formData.getFormName(), href);
        String buttonText = BcWords.getInstance().save;
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().save, onclickAction));
        onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), Wbs1Constants.JudgementStatus.application.id);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().send, onclickAction));
        controls.append(this.getHtmlBuilder().br());
        controls.append(this.getHtmlBuilder().br());
        onclickAction = XwebUtil.onclickActionToBack(wcbArg);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().cancel, onclickAction));
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        WbxFormBuilder formBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        StringBuilder sb = new StringBuilder();
        sb.append(formBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.getTitle(), null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void submit(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.submit_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void submit_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        Wbs1MessageImput messageImput = new Wbs1MessageImput();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, messageImput);
        Wbs1Judgement judgement = new Wbs1Judgement();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgement);
        XsysValidator validator = XsysValidator.getInstance();
        tokenContext.validationResult = validator.validate(messageImput);
        if (tokenContext.validationResult.hasError()) {
            XwebUtil.putToMap(tokenContext.map, messageImput);
            XwebUtil.inputErrorPreprocessing(tokenContext, requestParameter, tokenContext.validationResult);
            this.form(wcbArg);
            return;
        }
        XwebMessageConstants.MessageContext messageContext = (XwebMessageConstants.MessageContext)XwebUtil.getMapValue(tokenContext.map, XwebMessageConstants.MessageContext.class);
        CmsvMessage wbs1Message = new CmsvMessage();
        wbs1Message.id = messageImput.messageId;
        wbs1Message.subject = messageImput.subject;
        wbs1Message.content = messageImput.content;
        Wbs1Account loginAccount = XwebUtil.getLoginAccount(wcbArg, true);
        wbs1Message.from = Long.toString(loginAccount.personId);
        CmsvMessage parentMessage = (CmsvMessage)XwebUtil.getMapValue(tokenContext.map, CmsvMessage.class);
        long toPersonId = -1L;
        if (parentMessage != null) {
            wbs1Message.to = parentMessage.from;
            wbs1Message.parent_id = parentMessage.id;
            toPersonId = BcNumberUtil.parseLong(wbs1Message.to);
        }
        wbs1Message.sendEndDatetime = wbs1Message.sendStartDatetime = (wbs1Message.fairCopyDatetime = BcTimeUtil.createCalendar());
        int submitMode = BcNumberUtil.parseInt(requestParameter.map.getAsString(WbxConstants.SessionAttributeKey.submitMode), Wbs1Constants.JudgementStatus.NULL.id);
        this.getLogger().debug("### submitMode=" + submitMode);
        if (submitMode == Wbs1Constants.JudgementStatus.application.id) {
            wbs1Message.setJudgementDatetime(null);
            wbs1Message.setJudgementStatusId(Wbs1Constants.JudgementStatus.application.id);
            wbs1Message.setJudgementReason(null);
        } else {
            XwebJudgementUtil.judgementSet(judgement, wbs1Message);
        }
        CmsvMessageDAO messageDAO = CmsvMessageDAO.getInstance(messageContext.messageCategory.tableName);
        messageDAO.putEntity(dtsSessionSite, wbs1Message);
        Wbs1PointDetailDAO.getInstance().addPointDetail(dtsSessionSite, loginAccount, Wbs1Constants.PointEvent.Message, (Object)wbs1Message.id);
        String subject = "?? \u69d8\u304b\u3089\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u5c4a\u304d\u307e\u3057\u305f\u3002";
        StringBuilder content = new StringBuilder();
        content.append("?? \u69d8\u304b\u3089\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u5c4a\u304d\u307e\u3057\u305f\u3002");
        content.append("\n\n");
        content.append("  " + BcStringUtil.toNotNull(wbs1Message.subject));
        content.append("\n\n");
        content.append(" \u6b21\u306eURL\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u4e0b\u3055\u3044\u3002");
        XwebUtil.addMailToQueue(wcbArg, dtsSessionSite, toPersonId, subject, content.toString());
        dtsSessionSite.commit();
        XwebUtil.removeTokenContext(wcbArg, tokenContext);
        XwebUtil.redirectPreUrl(wcbArg);
    }

    public void view(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.view_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void view_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        HtsvUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        WbsMessageCondition messageCondition = new WbsMessageCondition();
        WbxParameterUtil.getInstance().setFieldValue(decryptMap, messageCondition);
        XwebMessageConstants.MessageContext messageContext = XwebMessageConstants.ceateMessageContext(messageCondition.messageCategory);
        CmsvMessageDAO mailDAO = CmsvMessageDAO.getInstance(messageCondition.messageCategory.tableName);
        CmsvMessage wbs1Mail = (CmsvMessage)mailDAO.getById(dtsSessionSite, messageCondition.messageId);
        WbxFormData formData = new WbxFormData();
        formData.icon = messageContext.iconTag;
        StringBuilder title = new StringBuilder();
        formData.title = messageContext.title;
        StringBuilder fileds = new StringBuilder();
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        long profilePersonId = BcNumberUtil.parseLong(wbs1Mail.from, -1);
        Wbs1MessageListWCB messageListWCB = new Wbs1MessageListWCB();
        fileds.append(this.createDetail(wcbArg, dtsSessionSite, urlParam, messageContext, wbs1Mail, profilePersonId, -1L, personManager));
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        HtsvUrlParameterMap paramMap = new HtsvUrlParameterMap();
        paramMap.put2((Object)XwebMessageConstants.MessageParam.messageCategoryId, messageContext.messageCategory.id);
        paramMap.put2((Object)XwebMessageConstants.MessageParam.toMessageId, wbs1Mail.id);
        String param1 = WbfwUtil.createEncryptQuery(paramMap);
        String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1);
        String onclickAction = WbfJslUtil.locationHref(href);
        String button = XwebHtmlBuilder.getInstance().button_button(Wbs1Words.getInstance().\u8fd4\u4fe1\u3059\u308b, onclickAction);
        controls.append(button);
        formData.controls = controls.toString();
        StringBuilder sb = new StringBuilder();
        WbxFormBuilder formBaseBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        sb.append(formBaseBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.title, null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
        if (wbs1Mail.openDatetime == null) {
            wbs1Mail.openDatetime = BcTimeUtil.createCalendar();
            mailDAO.putEntity(dtsSessionSite, wbs1Mail);
            dtsSessionSite.commit();
        }
    }

    protected String createDetail(HtsvArgument wcbArg, DtsSession dtsSessionSite, WbsUrlParam urlParam, XwebMessageConstants.MessageContext messageContext, CmsvMessage wbs1Message, long fromPersonId, long toPersonId, PersonManager personManager) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_04rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table.className));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_table_cell.className);
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.width("6rem").build();
        if (toPersonId > 0L) {
            sb.append(this.getHtmlBuilder().div_start(globalAttribute));
            sb.append(this.personProfileWCB.tableCellLeft(wcbArg, dtsSessionSite, fromPersonId));
            sb.append(this.getHtmlBuilder().div_end());
        }
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table_cell.className));
        sb.append(this.tableCellMiddle(wcbArg, urlParam, wbs1Message, fromPersonId, personManager));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.tableCellRight(wcbArg, dtsSessionSite, urlParam, messageContext, wbs1Message, fromPersonId, toPersonId, personManager));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    protected String tableCellMiddle(HtsvArgument wcbArg, WbsUrlParam urlParam, CmsvMessage wbs1Message, long profilePersonId, PersonManager personManager) throws Exception {
        String datetimeStr;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().h(6, wbs1Message.subject));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().p(wbs1Message.content, true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        Wbs1Account account = personManager.getAccountByPersonId(profilePersonId);
        PsnPersonConstants.Sex sex = PsnPersonUtil.toSexByCode(account.sexCode);
        if (sex != null) {
            String sexSymbolTag = PersonProfileUtil.toSexSymbolTag(sex);
            sb.append(sexSymbolTag);
            sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
            sb.append(this.getHtmlBuilder().p(sex.nameJpn1, true));
        }
        sb.append(this.getHtmlBuilder().space(1));
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().p(account.nickname, true));
        sb.append(this.getHtmlBuilder().space(1));
        if (wbs1Message.sendEndDatetime == null) {
            sb.append(this.getHtmlBuilder().p("\u672a\u9001\u4fe1", true));
        } else {
            datetimeStr = BcTimeUtil.toString(wbs1Message.sendEndDatetime, "yyyy/MM/dd HH:mm");
            sb.append(this.getHtmlBuilder().p("\u9001\u4fe1\u65e5\u6642\uff1a" + datetimeStr, true));
        }
        sb.append(this.getHtmlBuilder().space(1));
        if (wbs1Message.openDatetime == null) {
            sb.append(this.getHtmlBuilder().p("\u672a\u958b\u5c01", true));
        } else {
            datetimeStr = BcTimeUtil.toString(wbs1Message.openDatetime, "yyyy/MM/dd HH:mm");
            sb.append(this.getHtmlBuilder().p("\u958b\u5c01\u65e5\u6642\uff1a" + datetimeStr, true));
        }
        sb.append(this.getHtmlBuilder().space(1));
        sb.append(this.getHtmlBuilder().div_end());
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
            sb.append(XwebJudgementUtil.createJudgementHtml(this.getHtmlBuilder(), wbs1Message, wcbArg, wbs1Message.judgementPersonId));
            sb.append(this.getHtmlBuilder().div_end());
        }
        return sb.toString();
    }

    protected String tableCellRight(HtsvArgument wcbArg, DtsSession dtsSessionSite, WbsUrlParam urlParam, XwebMessageConstants.MessageContext messageContext, CmsvMessage wbs1Message, long fromPersonId, long toPersonId, PersonManager personManager) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_right.className));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.width("6rem").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.personProfileWCB.tableCellLeft(wcbArg, dtsSessionSite, toPersonId));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.viewButton(wcbArg, urlParam, messageContext, wbs1Message));
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    protected String viewButton(HtsvArgument wcbArg, WbsUrlParam urlParam1, XwebMessageConstants.MessageContext messageContext, CmsvMessage wbs1Message) throws Exception {
        String param1;
        HtsvUrlParameterMap paramMap;
        WbsUrlParam urlParam2;
        this.getLogger().debug("viewButton:urlParam1.mod=" + urlParam1.mode + " messageCategory=" + (Object)((Object)messageContext.messageCategory) + " messageId=" + wbs1Message.id);
        WbsMessageCondition messageCondition = new WbsMessageCondition();
        messageCondition.messageCategory = messageContext.messageCategory;
        messageCondition.messageId = wbs1Message.id;
        String href = null;
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam1.mode)) {
            urlParam2 = new WbsUrlParam();
            urlParam2.mode = Wbs1Constants.OperationMode.administrator.name();
            urlParam2.param1 = Long.toString(wbs1Message.id);
            paramMap = WbxParameterUtil.getInstance().createParamMap(urlParam2, messageCondition);
            param1 = WbfwUtil.createEncryptQuery(paramMap);
            href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1);
        } else {
            urlParam2 = new WbsUrlParam();
            urlParam2.param1 = Long.toString(wbs1Message.id);
            paramMap = WbxParameterUtil.getInstance().createParamMap(urlParam2, messageCondition);
            param1 = WbfwUtil.createEncryptQuery(paramMap);
            href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.view)) + WbfwUtil.createUrlQuery(param1);
        }
        StringBuilder sb = new StringBuilder();
        String onclickAction = WbfJslUtil.locationHref(href);
        String button = XwebHtmlBuilder.getInstance().button_button(Wbs1Words.getInstance().\u898b\u308b, onclickAction);
        sb.append(this.getHtmlBuilder().div_start());
        sb.append(button);
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    public static enum Method implements WbxPath
    {
        form("message-form"),
        submit("message-submit"),
        view("message-view");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1MessageWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

