/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.html;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.css.common.CssUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.orm.entity.OrmGeneralData;

public class WbfwHtmlElementBuilder {
    private static WbfwHtmlElementBuilder instance = new WbfwHtmlElementBuilder();
    protected HtmlBuilder htmlBuilder = new HtmlBuilder();

    private WbfwHtmlElementBuilder() {
    }

    public static WbfwHtmlElementBuilder getInstance() {
        return instance;
    }

    public StringBuilder create(MmdModel mmdModel, Object dataObject, Locale locale) throws Exception {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.htmlBuilder.table_start());
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            sb.append(this.htmlBuilder.tr_start(CssUtil.getTableRowClass(i)));
            sb.append(this.htmlBuilder.tableCell());
            sb.append(MmdUtil.getProvisionalHeaderValue(mmdField));
            sb.append(this.htmlBuilder.td_end());
            sb.append(this.htmlBuilder.tableCell());
            sb.append((CharSequence)this.createValueHtml(mmdModel, mmdField, dataObject, locale));
            sb.append(this.htmlBuilder.td_end());
            sb.append(this.htmlBuilder.tr_end());
            ++i;
        }
        sb.append(this.htmlBuilder.table_end());
        sb.append("\n");
        return sb;
    }

    public StringBuilder createValueHtml(MmdModel dataModel, MmdField mmdField, Object dataObject, Locale locale) throws Exception {
        String valueStr;
        StringBuilder sb = new StringBuilder(1024);
        Object value = null;
        if (dataObject.getClass().equals(OrmGeneralData.class)) {
            OrmGeneralData generalData = (OrmGeneralData)dataObject;
            value = generalData.getValue(mmdField.ordinalPosition - 1);
        } else {
            value = MmdUtil.getValue(mmdField, dataObject);
        }
        if (Number.class.isAssignableFrom(mmdField.dataClass)) {
            valueStr = (String)BcObjectConvertor.getInstance().convert(value, String.class, mmdField.fieldDisplay.formatStr, locale);
            int textColCount = mmdField.dataSize;
            if (textColCount <= 0) {
                textColCount = 10;
            }
            sb.append(this.htmlBuilder.textField(mmdField.fieldName, valueStr, textColCount, -1));
        } else if (Date.class.isAssignableFrom(mmdField.dataClass) || Calendar.class.isAssignableFrom(mmdField.dataClass)) {
            int textColCount = 10;
            String valueStr2 = (String)BcObjectConvertor.getInstance().convert(value, String.class, mmdField.fieldDisplay.formatStr, locale);
            sb.append(this.htmlBuilder.textField(mmdField.fieldName, valueStr2, textColCount, -1));
        } else if (String.class.isAssignableFrom(mmdField.dataClass) || StringBuilder.class.isAssignableFrom(mmdField.dataClass) || StringBuffer.class.isAssignableFrom(mmdField.dataClass)) {
            valueStr = (String)BcObjectConvertor.getInstance().convert(value, String.class, mmdField.fieldDisplay.formatStr, locale);
            int textColCountMax = 60;
            int rowCount = mmdField.dataSize / textColCountMax;
            if (rowCount <= 1) {
                sb.append(this.htmlBuilder.textField(mmdField.fieldName, valueStr, mmdField.dataSize, -1));
            } else {
                if (rowCount > 4) {
                    rowCount = 4;
                }
                sb.append(this.htmlBuilder.textArea(null, mmdField.fieldName, valueStr, textColCountMax, rowCount, null));
            }
        }
        return sb;
    }
}

