/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mqsv.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.module.mqsv.server.MqsvRecieveThread;
import jp.co.extreme.module.mqsv.server.MqsvService;

public class MqsvAcceptThread
extends Thread {
    protected BcMonitor threadMon = new BcMonitor();
    protected MqsvService messageServer;
    protected ServerSocket serverSocket;

    public MqsvAcceptThread(MqsvService messageServer) throws Exception {
        this.messageServer = messageServer;
        this.setPriority(1);
        this.threadMon.lock();
        this.start();
    }

    public void startAccept() throws Exception {
        InetAddress inetAddress = null;
        if (!BcStringUtil.isEmpty(this.messageServer.address)) {
            inetAddress = InetAddress.getByName(this.messageServer.address);
            this.serverSocket = new ServerSocket(this.messageServer.port, this.messageServer.backlogCount, inetAddress);
        } else {
            inetAddress = InetAddress.getLocalHost();
            this.serverSocket = new ServerSocket(this.messageServer.port, this.messageServer.backlogCount, inetAddress);
        }
        BcLogUtil.info(BcLogUtil.createLabel("XML Server", "*", 4, 60));
        BcLogUtil.info("   address : " + inetAddress.getHostAddress());
        BcLogUtil.info("  dns name : " + inetAddress.getHostName());
        BcLogUtil.info("      port : " + this.serverSocket.getLocalPort());
        BcLogUtil.info(" log level : " + this.messageServer.logLevel);
        this.threadMon.unLock();
    }

    @Override
    public void run() {
        while (true) {
            this.threadMon.sync();
            try {
                this.accept();
                continue;
            }
            catch (Exception ex) {
                BcLogUtil.debug(ex);
                continue;
            }
            break;
        }
    }

    protected void accept() throws Exception {
        Socket socket = this.serverSocket.accept();
        if (this.messageServer.logLevel > 0) {
            BcLogUtil.debug("SvRequestAcceptThread:accept " + socket.getInetAddress() + "_" + socket.getLocalAddress());
        }
        MqsvRecieveThread reqRecieveThread = new MqsvRecieveThread(this.messageServer, socket);
        this.messageServer.addRequestRecieveThread(reqRecieveThread);
    }

    public void parseHttpRequest(Socket socket) throws Exception {
        String reqStr;
        BufferedReader is = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        while (!BcStringUtil.isEmpty(reqStr = is.readLine())) {
            StringTokenizer st = new StringTokenizer(reqStr, " ", false);
            while (st.hasMoreTokens()) {
            }
        }
        PrintStream os = new PrintStream(socket.getOutputStream());
        os.print("HTTP/1.1 200 OK\r\n");
        os.print("Date: " + new Date() + "\n");
        os.print("Server: EASY Server 2.21\r\n");
        os.print("Content-length: 0\r\n");
        os.print("Content-type: text/xml\r\n\r\n");
        socket.close();
    }
}

