/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.filewatch;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.extreme.base.log.BcLogUtil;

public class ExtWatchKeys {
    private final WatchService watchService;
    private final Map<WatchKey, Path> watchKeysMap = new HashMap<WatchKey, Path>();

    public ExtWatchKeys(Path basedir, WatchService watchService) throws IOException {
        this.watchService = watchService;
        Files.walkFileTree(basedir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ExtWatchKeys.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void register(Path dir) throws IOException {
        BcLogUtil.debug("register:dir=" + dir);
        if (dir == null) {
            return;
        }
        WatchKey watchKey = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchKeysMap.put(watchKey, dir);
    }

    public void sweep() {
        Iterator<Map.Entry<WatchKey, Path>> it = this.watchKeysMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<WatchKey, Path> entry = it.next();
            if (!Files.notExists(entry.getValue(), LinkOption.NOFOLLOW_LINKS)) continue;
            entry.getKey().cancel();
            it.remove();
        }
    }

    public boolean isEmpty() {
        return this.watchKeysMap.isEmpty();
    }

    public void remove(WatchKey key) {
        this.watchKeysMap.remove(key);
    }

    public Path get(WatchKey key) {
        return this.watchKeysMap.get(key);
    }
}

