/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.component;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.component.WhcAbstractTextField;
import jp.co.extreme.html.component.WhcButton;
import jp.co.extreme.html.component.WhcButtonGroup;
import jp.co.extreme.html.component.WhcCheckBox;
import jp.co.extreme.html.component.WhcComponent;
import jp.co.extreme.html.component.WhcDiv;
import jp.co.extreme.html.component.WhcFile;
import jp.co.extreme.html.component.WhcHiddenField;
import jp.co.extreme.html.component.WhcInput;
import jp.co.extreme.html.component.WhcLabel;
import jp.co.extreme.html.component.WhcRadioButton;
import jp.co.extreme.html.component.WhcSelect;
import jp.co.extreme.html.component.WhcSubmitButton;
import jp.co.extreme.html.component.WhcTable;
import jp.co.extreme.html.component.WhcTableCell;
import jp.co.extreme.html.component.WhcTableRow;
import jp.co.extreme.html.component.WhcTextArea;
import jp.co.extreme.html.component.WhcTextField;

public class WhcBuilder
extends BcLoggableObject {
    protected HtmlBuilder htmlBuilder;

    public WhcBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    protected String createHtmlL2(Object object, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (WhcComponent.class.isAssignableFrom(object.getClass())) {
            WhcComponent whcComponent = (WhcComponent)object;
            String componentHtml = this.createComponentHtml(whcComponent, isEdit);
            sb.append(componentHtml);
        } else {
            sb.append(object);
        }
        return sb.toString();
    }

    public String createComponentHtml(WhcComponent whcComponent, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (WhcLabel.class.isAssignableFrom(whcComponent.getClass())) {
            WhcLabel whcLabel = (WhcLabel)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcLabel.value, String.class);
            if (!BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcHiddenField.class.isAssignableFrom(whcComponent.getClass())) {
            WhcHiddenField whcHiddenField = (WhcHiddenField)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcHiddenField.getValue(), String.class);
            if (isEdit) {
                sb.append(this.htmlBuilder.hidden(whcHiddenField.name, valueStr));
            } else if (!BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcTextField.class.isAssignableFrom(whcComponent.getClass())) {
            WhcTextField whcTextField = (WhcTextField)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcTextField.getValue(), String.class);
            if (isEdit) {
                String inputHtml = this.htmlBuilder.input(whcTextField.getGlobalAttribute(), HtmlConstants.HtmlInputType.text, whcTextField.name, valueStr, whcTextField.size, whcTextField.maxSize, whcTextField.disabled, whcTextField.readonly, whcTextField.multiple, whcTextField.pattern, whcTextField.placeholder, whcTextField.list, whcTextField.autocomplete, whcTextField.script);
                sb.append(inputHtml);
            } else if (!BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcTextArea.class.isAssignableFrom(whcComponent.getClass())) {
            WhcTextArea whcTextArea = (WhcTextArea)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcTextArea.getValue(), String.class);
            if (isEdit) {
                sb.append(this.htmlBuilder.textArea(whcTextArea.getGlobalAttribute(), whcTextArea.name, valueStr, whcTextArea.columnCount, whcTextArea.rowCount, whcTextArea.script));
            } else if (!BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcButton.class.isAssignableFrom(whcComponent.getClass())) {
            WhcButton whcButton = (WhcButton)whcComponent;
            sb.append(this.htmlBuilder.inputButton(HtmlConstants.HtmlInputType.button, whcButton.name, (Object)whcButton.getValue(), whcButton.disabled, whcButton.getGlobalAttribute().clazz, whcButton.script));
        } else if (WhcSubmitButton.class.isAssignableFrom(whcComponent.getClass())) {
            WhcSubmitButton whcSubmitButton = (WhcSubmitButton)whcComponent;
            sb.append(this.htmlBuilder.inputButton(HtmlConstants.HtmlInputType.submit, whcSubmitButton.name, (Object)whcSubmitButton.getValue(), whcSubmitButton.disabled, whcSubmitButton.getGlobalAttribute().clazz, whcSubmitButton.script));
        } else if (WhcFile.class.isAssignableFrom(whcComponent.getClass())) {
            WhcFile whcFile = (WhcFile)whcComponent;
            sb.append(this.htmlBuilder.file(whcFile.getGlobalAttribute(), whcFile.name, whcFile.getValue(), whcFile.size, whcFile.disabled, whcFile.multiple, whcFile.script));
        } else if (WhcButtonGroup.class.isAssignableFrom(whcComponent.getClass())) {
            WhcButtonGroup whcButtonGroup = (WhcButtonGroup)whcComponent;
            int i = 0;
            while (i < whcButtonGroup.childList.size()) {
                WhcInput whcImput = (WhcInput)whcButtonGroup.childList.get(i);
                if (i > 0) {
                    sb.append(this.htmlBuilder.space(2));
                }
                if (WhcCheckBox.class.isAssignableFrom(whcImput.getClass())) {
                    WhcCheckBox whcCheckBox = (WhcCheckBox)whcButtonGroup.childList.get(i);
                    String checkBoxHtml = this.htmlBuilder.checkBox(whcCheckBox.getGlobalAttribute(), whcButtonGroup.name, whcImput.getValue(), whcCheckBox.disabled, whcCheckBox.checked, whcCheckBox.script);
                    sb.append(checkBoxHtml);
                    if (!BcStringUtil.isEmpty(whcCheckBox.dispValue)) {
                        sb.append(this.htmlBuilder.span(whcCheckBox.dispValue, true));
                    }
                } else if (WhcRadioButton.class.isAssignableFrom(whcImput.getClass())) {
                    WhcRadioButton whcRadioButton = (WhcRadioButton)whcButtonGroup.childList.get(i);
                    String forValue = null;
                    if (whcRadioButton.getGlobalAttribute() != null) {
                        forValue = whcRadioButton.getGlobalAttribute().id;
                    }
                    sb.append(this.htmlBuilder.label_start(null, forValue));
                    String radioButtonHtml = this.htmlBuilder.radioButton(whcRadioButton.getGlobalAttribute(), whcButtonGroup.name, whcImput.getValue(), whcRadioButton.disabled, whcRadioButton.checked, whcRadioButton.script);
                    sb.append(radioButtonHtml);
                    BcStringUtil.append(sb, whcRadioButton.dispValue);
                    sb.append(this.htmlBuilder.label_end());
                }
                sb.append(this.htmlBuilder.lineSep);
                ++i;
            }
        } else if (WhcSelect.class.isAssignableFrom(whcComponent.getClass())) {
            WhcSelect whcSelect = (WhcSelect)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcSelect.value, String.class);
            sb.append(this.htmlBuilder.select(whcSelect.name, whcSelect.getOptionList(), valueStr));
        } else if (WhcDiv.class.isAssignableFrom(whcComponent.getClass())) {
            WhcDiv div = (WhcDiv)whcComponent;
            sb.append(this.htmlBuilder.div_start(div.getGlobalAttribute(), true));
            int i = 0;
            while (i < div.childList.size()) {
                Object obj = div.childList.get(i);
                sb.append(this.createHtmlL2(obj, isEdit));
                ++i;
            }
            sb.append(this.htmlBuilder.div_end());
        } else if (CharSequence.class.isAssignableFrom(whcComponent.getClass())) {
            CharSequence charSequence = (CharSequence)((Object)whcComponent);
            sb.append(charSequence);
        } else if (WhcTable.class.isAssignableFrom(whcComponent.getClass())) {
            WhcTable whcTable = (WhcTable)whcComponent;
            sb.append(this.createTable(whcTable, isEdit));
        } else {
            throw new Exception("not supported : WhcComponent=" + whcComponent.getClass().getName());
        }
        if (WhcAbstractTextField.class.isAssignableFrom(whcComponent.getClass())) {
            WhcAbstractTextField whcImput = (WhcAbstractTextField)whcComponent;
            if (!BcStringUtil.isEmpty(whcImput.list) && whcImput.optionList != null) {
                sb.append(this.htmlBuilder.datalist(whcImput.list, whcImput.optionList));
            }
        }
        return sb.toString();
    }

    public String createTable(WhcTable whcTable, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.appLineSep());
        sb.append(this.htmlBuilder.table_start(whcTable.getGlobalAttribute(), null, null, 0, -1, -1, null));
        WhcTableRow header = whcTable.getHeader();
        if (header != null) {
            sb.append(this.htmlBuilder.thead_start());
            sb.append(this.createTableRow(header, isEdit));
            sb.append(this.htmlBuilder.thead_end());
        }
        int i = 0;
        while (i < whcTable.getRowCount()) {
            WhcTableRow whcTableRow = whcTable.getRow(i);
            sb.append(this.createTableRow(whcTableRow, isEdit));
            ++i;
        }
        WhcTableRow footer = whcTable.getHeader();
        if (footer != null) {
            sb.append(this.htmlBuilder.tfoot(null));
            sb.append(this.createTableRow(footer, isEdit));
            sb.append(this.htmlBuilder.tfoot_end());
        }
        sb.append(this.htmlBuilder.table_end());
        sb.append(this.htmlBuilder.appLineSep());
        return sb.toString();
    }

    public String createTableRow(WhcTableRow whcTableRow, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("  " + this.htmlBuilder.tr_start());
        int i = 0;
        while (i < whcTableRow.valueList.size()) {
            WhcTableCell whcTableCell = whcTableRow.valueList.get(i);
            sb.append(this.createTableCell(whcTableCell, isEdit));
            ++i;
        }
        sb.append("  " + this.htmlBuilder.tr_end());
        return sb.toString();
    }

    public String createTableCell(WhcTableCell whcTableCell, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + this.htmlBuilder.tableCell(whcTableCell.getGlobalAttribute(), whcTableCell.rowSpan, whcTableCell.colSpan, -1, -1, null, null, null));
        int i = 0;
        while (i < whcTableCell.childList.size()) {
            Object obj = whcTableCell.childList.get(i);
            if (obj != null) {
                sb.append(this.createHtmlL2(obj, isEdit));
            }
            ++i;
        }
        sb.append(this.htmlBuilder.td_end());
        return sb.toString();
    }
}

