/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCompareUtil;
import jp.co.extreme.base.util.BcGeneralComparator;
import jp.co.extreme.base.util.BcIndexer;
import jp.co.extreme.base.util.BcMessageCreator;

public final class BcTableUtil {
    private BcTableUtil() {
    }

    public static List<BcTableColumn> craeteTableColumnList(BcTableModel tableModel, boolean doClone, List<Integer> columnIdList) throws Exception {
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        int i = 0;
        while (i < columnIdList.size()) {
            int columnId = columnIdList.get(i);
            BcTableColumn tableColumn = tableModel.getColumn(columnId);
            if (doClone) {
                tableColumnList.add((BcTableColumn)tableColumn.clone());
            } else {
                tableColumnList.add(tableColumn);
            }
            ++i;
        }
        return tableColumnList;
    }

    public static List<BcTableColumn> craeteTableColumnList(BcTableModel tableModel, boolean doClone, int ... columnIds) throws Exception {
        List<Integer> columnIdList = BcNumberUtil.toList(columnIds);
        return BcTableUtil.craeteTableColumnList(tableModel, doClone, columnIdList);
    }

    public static List<BcTableColumn> createTableColumnList(BcTableModel tableModel, boolean doClone) throws Exception {
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>(tableModel.getColumnCount());
        int i = 0;
        while (i < tableModel.getColumnCount()) {
            BcTableColumn tableColumn = tableModel.getColumn(i);
            if (doClone) {
                tableColumnList.add((BcTableColumn)tableColumn.clone());
            } else {
                tableColumnList.add(tableColumn);
            }
            ++i;
        }
        return tableColumnList;
    }

    public static List<BcTableColumn> createTableColumnList(BcTableColumnModel tableColumnModel, boolean doClone) throws Exception {
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            if (doClone) {
                tableColumnList.add((BcTableColumn)tableColumn.clone());
            } else {
                tableColumnList.add(tableColumn);
            }
            ++i;
        }
        return tableColumnList;
    }

    public static boolean comparatorTableColumnName(BcTableColumn tableColumn, String tableColumnName) {
        MmdField mmdField = tableColumn.getMmdField();
        if (mmdField != null) {
            return BcStringUtil.equalsIgnoreCase(mmdField.tableColumnName, tableColumnName);
        }
        return false;
    }

    public static int getColumnIndexByTableColumnName(BcTableColumnModel tableColumnModel, String tableColumnName) {
        int index = -1;
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            if (BcTableUtil.comparatorTableColumnName(tableColumn, tableColumnName)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static int[] getColumnIds(BcTableColumnModel tableColumnModel, boolean throwException, String ... tableColumnNames) throws Exception {
        int[] columnIds = new int[tableColumnNames.length];
        int i = 0;
        while (i < tableColumnNames.length) {
            String tableColumnName = tableColumnNames[i];
            int columnIndex = BcTableUtil.getColumnIndexByTableColumnName(tableColumnModel, tableColumnName);
            if (columnIndex >= 0) {
                columnIds[i] = tableColumnModel.toModelIndex(columnIndex);
            } else if (throwException) {
                String msg = BcMessageCreator.getInstance().bindMessage("\u5217 '{0}' \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", tableColumnName);
                throw new Exception(msg);
            }
            ++i;
        }
        return columnIds;
    }

    public static int getColumnId(BcTableColumnModel tableColumnModel, String tableColumnName, boolean throwException) throws Exception {
        int[] columnIds = BcTableUtil.getColumnIds(tableColumnModel, throwException, tableColumnName);
        return columnIds[0];
    }

    public static int getColumnId(BcTableColumnModel tableColumnModel, String tableColumnName) throws Exception {
        return BcTableUtil.getColumnId(tableColumnModel, tableColumnName, false);
    }

    public static int getColumnIndex(List<? extends BcTableColumn> tableColumnList, String columnName) {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            MmdField mmdField = tableColumn.getMmdField();
            if (BcStringUtil.equals(mmdField.columnName, columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getColumnIndex(TableColumnModel tableColumnModel, TableColumn tableColumn1) {
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn2 = tableColumnModel.getColumn(i);
            if (tableColumn1 == tableColumn2) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static BcTableColumn getTableColumnByTableColumnName(BcTableColumnModel tableColumnModel, String tableColumnName) {
        int columnIndex = BcTableUtil.getColumnIndexByTableColumnName(tableColumnModel, tableColumnName);
        BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(columnIndex);
        return tableColumn;
    }

    public static BcTableColumn getTableColumnByTableColumnName(List<? extends BcTableColumn> tableColumnList, String tableColumnName) {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            MmdField mmdField = tableColumn.getMmdField();
            if (BcTableUtil.comparatorTableColumnName(tableColumn, tableColumnName)) {
                return tableColumn;
            }
            ++i;
        }
        return null;
    }

    public static void addTableColumn(DefaultTableColumnModel tableColumnModel, Collection<? extends TableColumn> tableColumnCollection) {
        for (TableColumn tableColumn : tableColumnCollection) {
            tableColumnModel.addColumn(tableColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeColumns(BcTableModel tableModel, int ... columnIndexes) throws Exception {
        BcTableColumnModel tableColumnModel;
        Arrays.sort(columnIndexes);
        BcTableColumnModel bcTableColumnModel = tableColumnModel = tableModel.getTableColumnModel();
        synchronized (bcTableColumnModel) {
            int i = 0;
            while (i < columnIndexes.length) {
                int columnIndex = columnIndexes[columnIndexes.length - i - 1];
                BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(columnIndex);
                tableModel.removeColumn(columnIndex);
                ++i;
            }
        }
    }

    public static void addRow(BcTableModel tableModel, List row, Object value) {
        BcCollectionUtil.fill(row, tableModel.getColumnCount(), value);
        tableModel.addRow(row);
    }

    public static void addRow(BcTableModel tableModel, int rowCount, Object value) {
        int i = 0;
        while (i < rowCount) {
            ArrayList row = new ArrayList();
            BcTableUtil.addRow(tableModel, row, value);
            ++i;
        }
    }

    public static List<List> getValues(TableModel tableModel, int[] rowIndexes, int[] columnIds) {
        ArrayList<List> rowList = new ArrayList<List>();
        int i = 0;
        while (i < rowIndexes.length) {
            ArrayList<Object> row = new ArrayList<Object>();
            int j = 0;
            while (j < columnIds.length) {
                Object value = tableModel.getValueAt(rowIndexes[i], columnIds[j]);
                row.add(value);
                ++j;
            }
            rowList.add(row);
            ++i;
        }
        return rowList;
    }

    public static void getValueList(TableModel tableModel, int[] rowIndexes, int columnId, List valueList) {
        int i = 0;
        while (i < rowIndexes.length) {
            Object value = tableModel.getValueAt(rowIndexes[i], columnId);
            valueList.add(value);
            ++i;
        }
    }

    public static List getValueList(TableModel tableModel, int[] rowIndexes, int columnId) {
        ArrayList valueList = new ArrayList();
        BcTableUtil.getValueList(tableModel, rowIndexes, columnId, valueList);
        return valueList;
    }

    public static void getValueList(TableModel tableModel, Collection rowIndexCollection, int columnId, List valueList) {
        int[] rowIndexes = BcNumberUtil.toIntArray(rowIndexCollection);
        BcTableUtil.getValueList(tableModel, rowIndexes, columnId, valueList);
    }

    public static List<Object> getValueList(TableModel tableModel, Collection rowIndexCollection, int columnId) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        BcTableUtil.getValueList(tableModel, rowIndexCollection, columnId, valueList);
        return valueList;
    }

    public static Object getValueAt(List<List> rowList, int rowId, int columnId) {
        List row = rowList.get(rowId);
        Object value = row.get(columnId);
        return value;
    }

    public static <T> void getValueList(List<List> rowList, int columnId, List<T> valueList) {
        int i = 0;
        while (i < rowList.size()) {
            List row = rowList.get(i);
            Object value = BcCollectionUtil.getElement(row, columnId);
            valueList.add(value);
            ++i;
        }
    }

    public static List<Object> getValueList(List<List> rowList, int columnId) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        BcTableUtil.getValueList(rowList, columnId, valueList);
        return valueList;
    }

    public static void setValueAllRow(TableModel tableModel, int columnId, Object value) {
        int i = 0;
        while (i < tableModel.getRowCount()) {
            tableModel.setValueAt(value, i, columnId);
            ++i;
        }
    }

    public static BcTableColumnModel createTableColumnModel(Collection<? extends TableColumn> tableColumnCollection) {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableUtil.addTableColumn(tableColumnModel, tableColumnCollection);
        return tableColumnModel;
    }

    public static BcTableColumnModel createTableColumnModelByHeaderValues(Collection headerValueCollection) {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        for (Object headerValue : headerValueCollection) {
            BcTableColumn tableColumn = new BcTableColumn();
            tableColumn.setHeaderValue(headerValue);
            tableColumnModel.addColumn(tableColumn);
        }
        return tableColumnModel;
    }

    public static BcTableModel createTableModel(Collection<? extends TableColumn> tableColumnCollection) {
        BcTableColumnModel tableColumnModel = BcTableUtil.createTableColumnModel(tableColumnCollection);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        return tableModel;
    }

    public static BcTableModel createTableModelByHeaderValues(Collection headerValueCollection) {
        BcTableColumnModel tableColumnModel = BcTableUtil.createTableColumnModelByHeaderValues(headerValueCollection);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        return tableModel;
    }

    public static BcTableModel createTableModelByHeaderValues(Object ... headerValues) {
        List<Object> headerValueList = Arrays.asList(headerValues);
        return BcTableUtil.createTableModelByHeaderValues(headerValueList);
    }

    public static BcTableModel createTableModel(Map map) {
        BcTableModel tableModel = new BcTableModel();
        BcTableUtil.toTableModel(map, tableModel);
        return tableModel;
    }

    public static void toTableModel(Map<? extends Object, ? extends Object> map, BcTableModel tableModel) {
        for (Map.Entry<? extends Object, ? extends Object> mapEntry : map.entrySet()) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(mapEntry.getKey());
            row.add(mapEntry.getValue());
            tableModel.addRow(row);
        }
    }

    public static int compare(BcTableModel tableModel, List<? extends BcTableColumn> tableColumnList, int rowId1, int rowId2, Comparator comparator) throws Exception {
        int i = 0;
        while (i < tableColumnList.size()) {
            Object obj2;
            BcTableColumn tableColumn = tableColumnList.get(i);
            Object obj1 = tableModel.getValueAtModel(rowId1, tableColumn.getModelIndex());
            int result = comparator.compare(obj1, obj2 = tableModel.getValueAtModel(rowId2, tableColumn.getModelIndex()));
            if (result != BcCompareUtil.Comparison.equals.value) {
                return tableColumn.ascending ? result : -result;
            }
            ++i;
        }
        return BcCompareUtil.Comparison.equals.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuttlesort(BcTableModel tableModel, List<? extends BcTableColumn> tableColumnList, BcIndexer indexer1, BcIndexer indexer2, int low, int high, Comparator comparator) throws Exception {
        BcTableModel bcTableModel = tableModel;
        synchronized (bcTableModel) {
            int middle = (low + high) / 2;
            if (high - low < 2) {
                return;
            }
            BcTableUtil.shuttlesort(tableModel, tableColumnList, indexer2, indexer1, low, middle, comparator);
            BcTableUtil.shuttlesort(tableModel, tableColumnList, indexer2, indexer1, middle, high, comparator);
            int p = low;
            int q = middle;
            if (high - low >= 4 && BcTableUtil.compare(tableModel, tableColumnList, indexer1.toModelId(middle - 1), indexer1.toModelId(middle), comparator) <= 0) {
                int i = low;
                while (i < high) {
                    indexer2.setIndex(i, indexer1.toModelId(i));
                    ++i;
                }
                return;
            }
            int i = low;
            while (i < high) {
                if (q >= high || p < middle && BcTableUtil.compare(tableModel, tableColumnList, indexer1.toModelId(p), indexer1.toModelId(q), comparator) <= 0) {
                    indexer2.setIndex(i, indexer1.toModelId(p++));
                } else {
                    indexer2.setIndex(i, indexer1.toModelId(q++));
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sort(BcTableModel tableModel, List<? extends BcTableColumn> tableColumnList, Comparator comparator) throws Exception {
        BcTableModel bcTableModel = tableModel;
        synchronized (bcTableModel) {
            BcIndexer indexer1 = tableModel.getIndexer();
            if (indexer1 == null) {
                indexer1 = new BcIndexer(tableModel.getRowCount());
            }
            BcIndexer bcIndexer = indexer1;
            synchronized (bcIndexer) {
                BcIndexer indexer2 = (BcIndexer)indexer1.clone();
                BcTableUtil.shuttlesort(tableModel, tableColumnList, indexer1, indexer2, 0, tableModel.getRowCount(), comparator);
                tableModel.setIndexer(indexer2);
            }
        }
    }

    public static void sort(BcTableModel tableModel, List<? extends BcTableColumn> tableColumnList) throws Exception {
        BcGeneralComparator comparator = BcGeneralComparator.getInstance();
        BcTableUtil.sort(tableModel, tableColumnList, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sort(BcTableModel tableModel, boolean ascending, Comparator comparator, int ... columnIndexes) throws Exception {
        BcTableModel bcTableModel = tableModel;
        synchronized (bcTableModel) {
            List<BcTableColumn> tableColumnList = BcTableUtil.craeteTableColumnList(tableModel, true, columnIndexes);
            for (BcTableColumn tableColumn : tableColumnList) {
                tableColumn.ascending = ascending;
            }
            BcTableUtil.sort(tableModel, tableColumnList, comparator);
        }
    }

    public static void sort(BcTableModel tableModel, boolean ascending, int ... columnIndexes) throws Exception {
        BcGeneralComparator comparator = BcGeneralComparator.getInstance();
        BcTableUtil.sort(tableModel, ascending, comparator, columnIndexes);
    }

    public static int getSelectedCount(ListSelectionModel listSelectionModel) {
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return 0;
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int cnt = 0;
        int i = iMin;
        while (i <= iMax) {
            if (listSelectionModel.isSelectedIndex(i)) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public static List<Integer> getSameValueRowIndex(TableModel tableModel, int columnId, Object value, Comparator comparator) throws Exception {
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        int rowId = -1;
        int i = 0;
        while (i < tableModel.getRowCount()) {
            Object value2 = tableModel.getValueAt(i, columnId);
            if (comparator.compare(value, value2) == BcCompareUtil.Comparison.equals.value) {
                rowIndexList.add(i);
            }
            ++i;
        }
        return rowIndexList;
    }

    public static List<Integer> getSameValueRowIndex(TableModel tableModel, int columnId, Collection<?> valueCollection, Comparator comparator) throws Exception {
        ArrayList<Integer> rowIndexList = new ArrayList();
        for (Object value : valueCollection) {
            List<Integer> rowIndexList2 = BcTableUtil.getSameValueRowIndex(tableModel, columnId, value, comparator);
            rowIndexList.addAll(rowIndexList2);
        }
        rowIndexList = BcCollectionUtil.toUniqueList(rowIndexList);
        return rowIndexList;
    }

    public static List<Integer> getSameValueRowIndex(TableModel tableModel, int columnId, Object value) throws Exception {
        BcGeneralComparator comparator = BcGeneralComparator.getInstance();
        return BcTableUtil.getSameValueRowIndex(tableModel, columnId, value, (Comparator)comparator);
    }

    public static void getValueList(BcTableModel tableModel, int comparisonColumnId, Object comparisonValue, int targetColumnId, List valueList) throws Exception {
        List<Integer> rowIdList = BcTableUtil.getSameValueRowIndex(tableModel, comparisonColumnId, comparisonValue);
        int[] rowIds = BcNumberUtil.toIntArray(rowIdList);
        BcTableUtil.getValueList((TableModel)tableModel, rowIds, targetColumnId, valueList);
    }

    public static void getValueList(BcTableModel tableModel, String comparisonTableColumnName, Object comparisonValue, String targetTableColumnName, List valueList) throws Exception {
        BcTableColumnModel tableColumnModel = tableModel.getTableColumnModel();
        int comparisonColumnIndex = BcTableUtil.getColumnIndexByTableColumnName(tableColumnModel, comparisonTableColumnName);
        int comparisonColumnId = tableColumnModel.toModelIndex(comparisonColumnIndex);
        int targetColumnIndex = BcTableUtil.getColumnIndexByTableColumnName(tableColumnModel, targetTableColumnName);
        int targetColumnId = tableColumnModel.toModelIndex(targetColumnIndex);
        BcTableUtil.getValueList(tableModel, comparisonColumnId, comparisonValue, targetColumnId, valueList);
    }

    public static void setColumnVisible(BcTableColumn tableColumn, boolean visible) {
        if (visible) {
            double width = 64.0;
            if (tableColumn.defaultWidth >= 0.0) {
                width = tableColumn.defaultWidth;
            }
            tableColumn.setMaxWidth(Integer.MAX_VALUE);
            tableColumn.setPreferredWidth((int)width);
            tableColumn.setWidth(tableColumn.getPreferredWidth());
            tableColumn.setResizable(true);
        } else {
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
            tableColumn.setWidth(0);
            tableColumn.setResizable(false);
        }
    }

    public static int getRowIndex(TableModel tableModel, int columnId, Object value) {
        int rowId = -1;
        int i = 0;
        while (i < tableModel.getRowCount()) {
            Object value2 = tableModel.getValueAt(i, columnId);
            if (BcCompareUtil.compare(value, value2) == BcCompareUtil.Comparison.equals.value) {
                rowId = i;
                break;
            }
            ++i;
        }
        return rowId;
    }

    public static int getRowIndex(BcTableModel tableModel, String columnName, Object value) {
        return BcTableUtil.getRowIndex((TableModel)tableModel, tableModel.getTableColumnModel().getIndexByTableColumnName(columnName), value);
    }

    public static List<Integer> removeRow(BcTableModel tableModel, int columnId, Object value, Comparator comparator) throws Exception {
        List<Integer> rowIndexList = BcTableUtil.getSameValueRowIndex((TableModel)tableModel, columnId, value, comparator);
        int[] rowIndexes = BcNumberUtil.toIntArray(rowIndexList);
        tableModel.removeRows(rowIndexes);
        return rowIndexList;
    }

    public static List<Integer> removeRow(BcTableModel tableModel, int columnId, Object value) throws Exception {
        BcGeneralComparator comparator = BcGeneralComparator.getInstance();
        return BcTableUtil.removeRow(tableModel, columnId, value, (Comparator)comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> removeRow(BcTableModel tableModel, int columnId, Collection<?> valueCollection, Comparator comparator) throws Exception {
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        BcTableModel bcTableModel = tableModel;
        synchronized (bcTableModel) {
            Collection<?> collection = valueCollection;
            synchronized (collection) {
                for (Object value : valueCollection) {
                    List<Integer> rowIndexList2 = BcTableUtil.removeRow(tableModel, columnId, value, comparator);
                    rowIndexList.addAll(rowIndexList2);
                }
            }
        }
        return rowIndexList;
    }

    public static List<Integer> removeRow(BcTableModel tableModel, int columnId, Collection<?> valueCollection) throws Exception {
        BcGeneralComparator comparator = BcGeneralComparator.getInstance();
        return BcTableUtil.removeRow(tableModel, columnId, valueCollection, (Comparator)comparator);
    }

    public static void copyRows(BcTableModel tableModel1, BcTableModel tableModel2, String ... tableColumnNames) throws Exception {
        BcTableColumnModel tableColumnModel1 = tableModel1.getTableColumnModel();
        int[] columnIds1 = BcTableUtil.getColumnIds(tableColumnModel1, true, tableColumnNames);
        int[] rowIds1 = new int[tableModel1.getRowCount()];
        int i = 0;
        while (i < rowIds1.length) {
            rowIds1[i] = i;
            ++i;
        }
        List<List> rowList1 = BcTableUtil.getValues(tableModel1, rowIds1, columnIds1);
        BcTableColumnModel tableColumnModel2 = tableModel2.getTableColumnModel();
        int[] columnIds2 = BcTableUtil.getColumnIds(tableColumnModel2, true, tableColumnNames);
        int i2 = 0;
        while (i2 < rowList1.size()) {
            List row1 = rowList1.get(i2);
            ArrayList newRow = new ArrayList();
            BcCollectionUtil.fill(newRow, tableColumnModel2.getColumnCount());
            int j = 0;
            while (j < row1.size()) {
                Object value = row1.get(j);
                newRow.set(columnIds2[j], value);
                ++j;
            }
            tableModel2.addRow(newRow);
            ++i2;
        }
    }

    public static List<Integer> createNotExistsColumnIndexList(BcTableColumnModel tableColumnModel, String ... tableColumnNames) throws Exception {
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            boolean exists = false;
            int j = 0;
            while (j < tableColumnNames.length) {
                if (tableColumnNames[j].equalsIgnoreCase(tableColumn.getMmdField().tableColumnName)) {
                    exists = true;
                    break;
                }
                ++j;
            }
            if (!exists) {
                columnIndexList.add(i);
            }
            ++i;
        }
        return columnIndexList;
    }

    public static void adjustToColmnCount(BcTableModel tableModel, Object value) {
        int i = 0;
        while (i < tableModel.getRowCount()) {
            List row = tableModel.getRow(i);
            BcCollectionUtil.fill(row, tableModel.getColumnCount(), value);
            ++i;
        }
    }

    public static List<BcTableColumn> createTableColumnList(Collection<MmdField> mmdFieldCollection) throws Exception {
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        for (MmdField mmdField : mmdFieldCollection) {
            BcTableColumn tableColumn = new BcTableColumn();
            tableColumn.setMmdField(mmdField);
            tableColumnList.add(tableColumn);
        }
        return tableColumnList;
    }

    public static enum Extention {
        csv,
        tsv;

    }
}

